/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.rmi.trace;

import ghidra.app.plugin.core.debug.service.rmi.trace.OpenTrace;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteAsyncResult;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteParameter;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiError;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiHandler;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public interface RemoteMethod {
    public String name();

    public Action action();

    public String description();

    public Map<String, RemoteParameter> parameters();

    public TargetObjectSchema.SchemaName retType();

    public static void checkType(String name, TargetObjectSchema sch, Object arg) {
        TraceObject obj;
        if (sch.getType() != TargetObject.class ? sch.getType().isInstance(arg) : arg instanceof TraceObject && sch.equals((obj = (TraceObject)arg).getTargetSchema())) {
            return;
        }
        throw new IllegalArgumentException("For parameter %s: argument %s is not a %s".formatted(name, arg, sch));
    }

    default public Trace validate(Map<String, Object> arguments) {
        Trace trace = null;
        SchemaContext ctx = EnumerableTargetObjectSchema.MinimalSchemaContext.INSTANCE;
        for (Map.Entry<String, RemoteParameter> entry : this.parameters().entrySet()) {
            if (!arguments.containsKey(entry.getKey())) {
                if (!entry.getValue().required()) continue;
                throw new IllegalArgumentException("Missing required parameter '" + entry.getKey() + "'");
            }
            Object arg = arguments.get(entry.getKey());
            if (arg instanceof TraceObject) {
                TraceObject obj = (TraceObject)arg;
                if (trace == null) {
                    trace = obj.getTrace();
                    ctx = trace.getObjectManager().getRootSchema().getContext();
                } else if (trace != obj.getTrace()) {
                    throw new IllegalArgumentException("All TraceObject parameters must come from the same trace");
                }
            }
            TargetObjectSchema sch = ctx.getSchema(entry.getValue().type());
            RemoteMethod.checkType(entry.getKey(), sch, arg);
        }
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            if (this.parameters().containsKey(entry.getKey())) continue;
            throw new IllegalArgumentException("Extra argument '" + entry.getKey() + "'");
        }
        return trace;
    }

    public RemoteAsyncResult invokeAsync(Map<String, Object> var1);

    default public Object invoke(Map<String, Object> arguments) {
        try {
            return this.invokeAsync(arguments).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TraceRmiError(e);
        }
    }

    public record RecordRemoteMethod(TraceRmiHandler handler, String name, Action action, String description, Map<String, RemoteParameter> parameters, TargetObjectSchema.SchemaName retType) implements RemoteMethod
    {
        @Override
        public RemoteAsyncResult invokeAsync(Map<String, Object> arguments) {
            Trace trace = this.validate(arguments);
            OpenTrace open = this.handler.getOpenTrace(trace);
            return this.handler.invoke(open, this.name, arguments);
        }
    }

    public record Action(String name) {
        public static final Action REFRESH = new Action("refresh");
        public static final Action ACTIVATE = new Action("activate");
        public static final Action FOCUS = new Action("focus");
        public static final Action TOGGLE = new Action("toggle");
        public static final Action DELETE = new Action("delete");
        public static final Action EXECUTE = new Action("execute");
        public static final Action CONNECT = new Action("connect");
        public static final Action ATTACH = new Action("attach");
        public static final Action DETACH = new Action("detach");
        public static final Action LAUNCH = new Action("launch");
        public static final Action KILL = new Action("kill");
        public static final Action RESUME = new Action("resume");
        public static final Action INTERRUPT = new Action("interrupt");
        public static final Action STEP_INTO = new Action("step_into");
        public static final Action STEP_OVER = new Action("step_over");
        public static final Action STEP_OUT = new Action("step_out");
        public static final Action STEP_SKIP = new Action("step_skip");
        public static final Action STEP_BACK = new Action("step_back");
        public static final Action STEP_EXT = new Action("step_ext");
        public static final Action BREAK_SW_EXECUTE = new Action("break_sw_execute");
        public static final Action BREAK_HW_EXECUTE = new Action("break_hw_execute");
        public static final Action BREAK_READ = new Action("break_read");
        public static final Action BREAK_WRITE = new Action("break_write");
        public static final Action BREAK_ACCESS = new Action("break_access");
        public static final Action BREAK_EXT = new Action("break_ext");
        public static final Action READ_MEM = new Action("read_mem");
        public static final Action WRITE_MEM = new Action("write_mem");
        public static final Action WRITE_REG = new Action("write_reg");
    }
}

