/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.DockingUtils;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldInputListener;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.FieldSelectionHelper;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GColor;
import ghidra.app.plugin.core.byteviewer.ByteField;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerHighlighter;
import ghidra.app.plugin.core.byteviewer.ByteViewerLayoutModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.FieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockRange;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.IndexedByteBlockInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Msg;
import help.Help;
import help.HelpService;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import javax.swing.SwingUtilities;

public class ByteViewerComponent
extends FieldPanel
implements FieldMouseListener,
FieldLocationListener,
FieldSelectionListener,
FieldInputListener {
    private ByteViewerPanel panel;
    private DataFormatModel model;
    private int bytesPerLine;
    private FieldFactory[] fieldFactories;
    private FontMetrics fm;
    private IndexMap indexMap;
    private ProgramByteBlockSet blockSet;
    private boolean consumeKeyStrokes;
    private boolean editMode;
    private Color editColor;
    private Color currentCursorColor;
    private Color currentCursorLineColor;
    private ByteViewerLayoutModel layoutModel;
    private boolean doingRefresh;
    private boolean doingEdit;
    private boolean updatingIndexMap;
    private Runnable updateColorRunner;
    private boolean indexUpdate = true;
    private FieldLocation lastFieldLoc;
    private ByteViewerHighlighter highlightProvider = new ByteViewerHighlighter();
    private int highlightButton = 2;

    protected ByteViewerComponent(ByteViewerPanel vpanel, ByteViewerLayoutModel layoutModel, DataFormatModel model, int bytesPerLine, FontMetrics fm) {
        super((LayoutModel)layoutModel, "Byte Viewer");
        this.setFieldDescriptionProvider((l, f) -> this.getFieldDescription(l, f));
        this.panel = vpanel;
        this.model = model;
        this.bytesPerLine = bytesPerLine;
        this.fm = fm;
        this.layoutModel = layoutModel;
        this.setName(model.getName());
        this.initialize();
        this.setBackgroundColorModel(new ByteViewerBackgroundColorModel());
    }

    private String getFieldDescription(FieldLocation fieldLoc, Field field) {
        if (field == null) {
            return null;
        }
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(fieldLoc.getIndex(), fieldLoc.getFieldNum());
        if (info != null) {
            String modelName = this.model.getName();
            return modelName + " format at " + info.getBlock().getLocationRepresentation(info.getOffset()) + ", value = " + field.getText();
        }
        return null;
    }

    public void buttonPressed(FieldLocation fieldLocation, Field field, MouseEvent mouseEvent) {
        if (fieldLocation == null || field == null) {
            return;
        }
        if (!(field instanceof ByteField)) {
            return;
        }
        if (mouseEvent.getButton() == this.highlightButton) {
            String text = field.getText();
            if (text.equals(this.highlightProvider.getText())) {
                this.highlightProvider.setText(null);
            } else {
                this.highlightProvider.setText(text);
            }
            this.repaint();
        }
        if (DockingUtils.isControlModifier((MouseEvent)mouseEvent) && mouseEvent.isShiftDown() && mouseEvent.getButton() == 1) {
            this.fieldLocationChanged(fieldLocation, field, true, false);
        }
    }

    public void fieldLocationChanged(FieldLocation loc, Field field, EventTrigger trigger) {
        this.fieldLocationChanged(loc, field, false, trigger == EventTrigger.GUI_ACTION);
    }

    private void fieldLocationChanged(FieldLocation loc, Field field, boolean isAltDown, boolean setCurrentView) {
        IndexedByteBlockInfo info;
        if (this.doingRefresh || this.doingEdit || loc == null || this.indexMap == null || field == null || this.updatingIndexMap) {
            return;
        }
        if (!(field instanceof ByteField) || !isAltDown && loc.equals((Object)this.lastFieldLoc)) {
            return;
        }
        if (setCurrentView) {
            this.panel.setCurrentView(this);
        }
        SwingUtilities.invokeLater(this.updateColorRunner);
        this.lastFieldLoc = loc;
        ByteField bf = (ByteField)field;
        int fieldOffset = bf.getFieldOffset();
        BigInteger index = loc.getIndex();
        int pos = loc.getCol();
        if (pos >= this.model.getDataUnitSymbolSize()) {
            pos = this.model.getDataUnitSymbolSize() - 1;
        }
        if ((info = this.indexMap.getBlockInfo(index, fieldOffset)) == null) {
            return;
        }
        ByteBlock block = info.getBlock();
        BigInteger offset = info.getOffset();
        int byteOffset = this.model.getByteOffset(info.getBlock(), pos);
        offset = offset.add(BigInteger.valueOf(byteOffset));
        this.panel.setInsertionField(this, block, offset, index, loc.getCol(), isAltDown);
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        if (this.blockSet == null || this.doingRefresh) {
            return;
        }
        ByteBlockSelection sel = this.processFieldSelection(selection);
        this.panel.updateSelection(this, sel);
        this.setViewerSelection(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent ev, BigInteger index, int fieldNum, int row, int col, Field field) {
        ByteBlock block;
        this.panel.setStatusMessage("");
        if (!this.consumeKeyStrokes) {
            return;
        }
        if (DockingUtils.isControlModifier((KeyEvent)ev)) {
            return;
        }
        if (ev.getKeyCode() == 8) {
            this.cursorLeft();
            ev.consume();
            return;
        }
        if (!this.model.isEditable()) {
            this.panel.setStatusMessage(this.model.getName() + " view is not editable");
            ev.consume();
            return;
        }
        char c = ev.getKeyChar();
        if (c < ' ' || c > '\u007f') {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        if (field == null || !(field instanceof ByteField)) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        int fieldOffset = ((ByteField)field).getFieldOffset();
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(index, fieldOffset);
        if (info == null) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        if (col >= this.model.getDataUnitSymbolSize()) {
            col = this.model.getDataUnitSymbolSize() - 1;
        }
        if (!(block = info.getBlock()).isEditable()) {
            this.panel.setStatusMessage("Block is not writable!");
            this.getToolkit().beep();
            ev.consume();
            return;
        }
        BigInteger offset = info.getOffset();
        int transactionID = this.blockSet.startTransaction();
        if (transactionID < 0) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        try {
            byte[] oldValue = this.getByteValue(block, offset);
            boolean success = this.model.replaceValue(block, offset, col, c);
            if (success) {
                byte[] newValue = this.getByteValue(block, offset);
                this.blockSet.notifyByteEditing(block, offset, oldValue, newValue);
                this.cursorRight();
                this.doingEdit = true;
                this.layoutModel.dataChanged(index, index);
            } else {
                this.panel.setStatusMessage("Invalid char '" + c + "' in the " + this.model.getName() + " view");
                this.getToolkit().beep();
            }
        }
        catch (ByteBlockAccessException exc) {
            this.panel.setStatusMessage("Editing not allowed: " + exc.getMessage());
            this.getToolkit().beep();
        }
        catch (AddressOutOfBoundsException e) {
            this.getToolkit().beep();
        }
        catch (IndexOutOfBoundsException e) {
            this.getToolkit().beep();
        }
        catch (Throwable t) {
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error editing memory", (Throwable)t);
        }
        finally {
            ev.consume();
            this.doingEdit = false;
            this.blockSet.endTransaction(transactionID, true);
        }
    }

    private byte[] getByteValue(ByteBlock block, BigInteger offset) {
        byte[] b = new byte[this.model.getUnitByteSize()];
        try {
            for (int i = 0; i < b.length; ++i) {
                b[i] = block.getByte(offset.add(BigInteger.valueOf(i)));
            }
            return b;
        }
        catch (ByteBlockAccessException byteBlockAccessException) {
            return null;
        }
    }

    void addListeners() {
        this.addFieldLocationListener(this);
        this.addFieldSelectionListener(this);
        this.addFieldInputListener(this);
        this.addFieldMouseListener(this);
    }

    void setFontMetrics(FontMetrics fm) {
        this.fm = fm;
        this.createFields();
        this.layoutModel.setIndexMap(this.indexMap);
    }

    void setEditColor(Color c) {
        this.editColor = c;
        for (FieldFactory fieldFactorie : this.fieldFactories) {
            fieldFactorie.setEditColor(c);
        }
        this.layoutModel.layoutChanged();
        this.updateColor();
    }

    void setHighlightButton(int highlightButton) {
        this.highlightButton = highlightButton;
    }

    void setMouseButtonHighlightColor(Color color) {
        this.highlightProvider.setHighlightColor(color);
    }

    void setCurrentCursorColor(Color c) {
        this.currentCursorColor = c;
        this.updateColor();
    }

    void setCurrentCursorLineColor(Color c) {
        this.currentCursorLineColor = c;
    }

    void setSeparatorColor(Color c) {
        for (FieldFactory fieldFactorie : this.fieldFactories) {
            fieldFactorie.setSeparatorColor(c);
        }
        this.layoutModel.layoutChanged();
    }

    Color getEditColor() {
        return this.editColor;
    }

    void setIndexMap(IndexMap map) {
        ByteBlockSet byteBlockSet;
        this.updatingIndexMap = true;
        this.indexMap = map;
        if (map != null) {
            this.bytesPerLine = map.getBytesPerLine();
            this.createFields();
        }
        this.blockSet = (byteBlockSet = this.indexMap.getByteBlockSet()) instanceof ProgramByteBlockSet ? (ProgramByteBlockSet)this.indexMap.getByteBlockSet() : null;
        if (this.indexUpdate) {
            this.layoutModel.setIndexMap(this.indexMap);
        }
        this.updatingIndexMap = false;
    }

    protected IndexMap getIndexMap() {
        return this.indexMap;
    }

    protected ProgramByteBlockSet getBlockSet() {
        return this.blockSet;
    }

    void setGroupSize(int groupSize) {
        this.model.setGroupSize(groupSize);
        this.createFields();
        this.layoutModel.setIndexMap(this.indexMap);
    }

    void setViewerSelection(ByteBlockSelection selection) {
        this.removeFieldSelectionListener(this);
        try {
            this.setSelection(this.getFieldSelection(selection));
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error setting selection", (Throwable)e);
        }
        finally {
            this.addFieldSelectionListener(this);
        }
    }

    protected FieldSelection getFieldSelection(ByteBlockSelection selection) {
        FieldSelection fsel = new FieldSelection();
        for (int i = 0; i < selection.getNumberOfRanges(); ++i) {
            ByteBlockRange r = selection.getRange(i);
            ByteBlock block = r.getByteBlock();
            BigInteger start = r.getStartIndex();
            BigInteger end = r.getEndIndex();
            FieldLocation startLoc = this.indexMap.getFieldLocation(block, start, this.fieldFactories);
            FieldLocation endLoc = this.indexMap.getFieldLocation(block, end, this.fieldFactories);
            int endFieldOffset = endLoc.getFieldNum();
            BigInteger endIndex = endLoc.getIndex();
            if (endFieldOffset == this.fieldFactories.length - 1) {
                endFieldOffset = 0;
                endIndex = endIndex.add(BigInteger.ONE);
            } else {
                ++endFieldOffset;
            }
            fsel.addRange(new FieldLocation(startLoc.getIndex(), startLoc.getFieldNum(), 0, 0), new FieldLocation(endIndex, endFieldOffset, 0, 0));
        }
        return fsel;
    }

    void setViewerHighlight(ByteBlockSelection highlight) {
        try {
            this.setHighlight(this.getFieldSelection(highlight));
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error setting highlight", (Throwable)e);
        }
    }

    int setViewerCursorLocation(ByteBlock block, BigInteger index, int characterOffset) {
        if (this.indexMap == null) {
            return -1;
        }
        try {
            FieldLocation location = this.indexMap.getFieldLocation(block, index, this.fieldFactories);
            if (location == null) {
                return -1;
            }
            int column = this.adjustCharacterOffsetForBytesField(location, characterOffset);
            BigInteger fieldIndex = location.getIndex();
            int fieldNum = location.getFieldNum();
            int row = location.getRow();
            this.setCursorPosition(fieldIndex, fieldNum, row, column, EventTrigger.INTERNAL_ONLY);
            if (this.panel.getCurrentComponent() == this) {
                this.scrollToCursor();
            }
            return fieldIndex.intValue();
        }
        catch (AddressOutOfBoundsException location) {
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error setting cursor location.", (Throwable)e);
        }
        return -1;
    }

    private int adjustCharacterOffsetForBytesField(FieldLocation fieldLoc, int characterOffset) {
        int numCols;
        BigInteger index = fieldLoc.getIndex();
        if (index.compareTo(BigInteger.ZERO) < 0 || index.compareTo(this.layoutModel.getNumIndexes()) >= 0) {
            return characterOffset;
        }
        Layout layout = this.layoutModel.getLayout(index);
        if (layout == null) {
            return characterOffset;
        }
        int column = fieldLoc.getCol() + characterOffset;
        int fieldNum = fieldLoc.getFieldNum();
        int fieldRow = fieldLoc.getRow();
        ByteField field = (ByteField)layout.getField(fieldNum);
        if (field != null && column >= (numCols = field.getNumCols(fieldRow))) {
            column = numCols - 1;
        }
        return column;
    }

    void clearViewerSelection() {
        this.removeFieldSelectionListener(this);
        this.clearSelection();
        this.addFieldSelectionListener(this);
    }

    ByteBlockSelection getViewerSelection() {
        FieldSelection sel = this.getSelection();
        if (sel == null) {
            return null;
        }
        return this.processFieldSelection(sel);
    }

    void clearViewerHighlight() {
        this.clearHighlight();
    }

    ByteBlockSelection getViewerHighlight() {
        FieldSelection hl = this.getHighlight();
        if (hl == null) {
            return null;
        }
        return this.processFieldSelection(hl);
    }

    void returnToView(ByteBlock block, BigInteger index, ViewerPosition vpos) {
        FieldLocation fieldLoc = this.indexMap.getFieldLocation(block, index, this.fieldFactories);
        this.setViewerPosition(vpos.getIndex(), vpos.getXOffset(), vpos.getYOffset());
        this.setCursorPosition(fieldLoc.getIndex(), fieldLoc.getFieldNum(), fieldLoc.getRow(), fieldLoc.getCol());
    }

    ByteBlockInfo getViewerCursorLocation() {
        BigInteger index;
        IndexedByteBlockInfo info;
        FieldLocation loc = this.getCursorLocation();
        if (loc == null) {
            ViewerPosition vp = this.getViewerPosition();
            if (vp == null) {
                return null;
            }
            return this.indexMap.getBlockInfo(vp.getIndex(), 0);
        }
        if (this.indexMap == null) {
            return null;
        }
        Field field = super.getCurrentField();
        if (!(field instanceof ByteField)) {
            return null;
        }
        ByteField currentField = (ByteField)field;
        int fieldOffset = currentField.getFieldOffset();
        int pos = loc.getCol();
        if (pos >= this.model.getDataUnitSymbolSize()) {
            pos = this.model.getDataUnitSymbolSize() - 1;
        }
        if ((info = this.indexMap.getBlockInfo(index = loc.getIndex(), fieldOffset)) == null) {
            return null;
        }
        BigInteger offset = info.getOffset();
        int byteOffset = this.model.getByteOffset(info.getBlock(), pos);
        offset = offset.add(BigInteger.valueOf(byteOffset));
        return new ByteBlockInfo(info.getBlock(), offset, loc.getCol());
    }

    DataFormatModel getDataModel() {
        return this.model;
    }

    void setEditMode(boolean editMode) {
        this.consumeKeyStrokes = editMode;
        if (!this.model.isEditable()) {
            return;
        }
        this.editMode = editMode;
        this.updateColor();
    }

    private void updateColor() {
        if (this.panel.getCurrentComponent() == this) {
            if (this.editMode) {
                this.setFocusedCursorColor(this.editColor);
            } else {
                this.setFocusedCursorColor(this.currentCursorColor);
            }
        }
    }

    boolean getEditMode() {
        return this.editMode;
    }

    void refreshView() {
        try {
            this.doingRefresh = true;
            FieldLocation loc = this.getCursorLocation();
            if (loc != null) {
                ByteBlockSelection sel = this.getViewerSelection();
                this.layoutModel.dataChanged(loc.getIndex(), loc.getIndex());
                if (sel != null && sel.getNumberOfRanges() > 0) {
                    this.setViewerSelection(sel);
                }
            }
        }
        finally {
            this.doingRefresh = false;
        }
    }

    public void dispose() {
        super.dispose();
        this.model.dispose();
        this.layoutModel.dispose();
    }

    private void initialize() {
        this.createFields();
        this.setCursorOn(true);
        this.editColor = ByteViewerComponentProvider.CHANGED_VALUE_COLOR;
        this.currentCursorColor = ByteViewerComponentProvider.CURSOR_ACTIVE_COLOR;
        this.setNonFocusCursorColor((Color)ByteViewerComponentProvider.CURSOR_NOT_FOCUSED_COLOR);
        this.setFocusedCursorColor(this.currentCursorColor);
        this.updateColorRunner = () -> this.updateColor();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    ByteViewerComponent.this.panel.setCurrentView(ByteViewerComponent.this);
                }
            }
        });
        this.enableHelp();
    }

    private void enableHelp() {
        HelpService helpService = Help.getHelpService();
        if (helpService != null) {
            helpService.registerHelp((Object)this, this.model.getHelpLocation());
        }
    }

    private void createFields() {
        int fieldCount = this.bytesPerLine / this.model.getUnitByteSize();
        this.fieldFactories = new FieldFactory[fieldCount];
        int charWidth = this.fm.charWidth('W');
        int fieldOffset = 0;
        for (int i = 0; i < fieldCount; ++i) {
            this.fieldFactories[i] = new FieldFactory(this.model, this.bytesPerLine, fieldOffset, this.fm, this.highlightProvider);
            fieldOffset += this.model.getUnitByteSize();
            this.fieldFactories[i].setEditColor(this.editColor);
            this.fieldFactories[i].setIndexMap(this.indexMap);
        }
        this.layoutModel.setFactorys(this.fieldFactories, this.model, charWidth);
    }

    private IndexedByteBlockInfo getBlockInfoForSelectionStart(FieldLocation loc) {
        BigInteger index = loc.getIndex();
        int fieldNum = loc.getFieldNum();
        if (this.indexMap.isBlockSeparatorIndex(index)) {
            index = index.add(BigInteger.ONE);
            fieldNum = 0;
        }
        int offset = this.indexMap.getFieldOffset(index, fieldNum, this.fieldFactories);
        return this.indexMap.getBlockInfo(index, offset);
    }

    private IndexedByteBlockInfo getBlockInfoForSelectionEnd(FieldLocation loc) {
        BigInteger lineIndex = loc.getIndex();
        int fieldNum = loc.getFieldNum();
        if (this.indexMap.isBlockSeparatorIndex(lineIndex)) {
            lineIndex = lineIndex.subtract(BigInteger.ONE);
            fieldNum = this.fieldFactories.length - 1;
        }
        if (loc.getCol() == 0 && --fieldNum < 0) {
            if (this.indexMap.isBlockSeparatorIndex(lineIndex = lineIndex.subtract(BigInteger.ONE))) {
                lineIndex = lineIndex.subtract(BigInteger.ONE);
            }
            fieldNum = this.fieldFactories.length - 1;
        }
        int bytesFromLineStart = this.indexMap.getFieldOffset(lineIndex, fieldNum, this.fieldFactories);
        int bytesInField = this.model.getUnitByteSize();
        int lastByteInSelectionOnLine = bytesFromLineStart + bytesInField - 1;
        return this.indexMap.getBlockInfo(lineIndex, lastByteInSelectionOnLine);
    }

    private void addByteBlockRange(ByteBlockSelection sel, IndexedByteBlockInfo start, IndexedByteBlockInfo end) {
        ByteBlock endBlock;
        if (start == null || end == null) {
            return;
        }
        if (start.compareTo(end) > 0) {
            return;
        }
        ByteBlock startBlock = start.getBlock();
        if (startBlock == (endBlock = end.getBlock())) {
            ByteBlockRange r = new ByteBlockRange(startBlock, start.getOffset(), end.getOffset());
            sel.add(r);
        } else {
            BigInteger last = startBlock.getLength().subtract(BigInteger.ONE);
            sel.add(new ByteBlockRange(startBlock, start.getOffset(), last));
            sel.add(new ByteBlockRange(endBlock, BigInteger.ZERO, end.getOffset()));
            for (ByteBlock byteBlock : this.indexMap.getBlocksBetween(start, end)) {
                BigInteger maxIndex = byteBlock.getLength().subtract(BigInteger.ONE);
                sel.add(new ByteBlockRange(byteBlock, BigInteger.ZERO, maxIndex));
            }
        }
    }

    protected ByteBlockSelection processFieldSelection(FieldSelection fieldSelection) {
        ByteBlockSelection blockSelection = new ByteBlockSelection();
        int count = fieldSelection.getNumRanges();
        for (int i = 0; i < count; ++i) {
            FieldRange range = fieldSelection.getFieldRange(i);
            IndexedByteBlockInfo start = this.getBlockInfoForSelectionStart(range.getStart());
            IndexedByteBlockInfo end = this.getBlockInfoForSelectionEnd(range.getEnd());
            this.addByteBlockRange(blockSelection, start, end);
        }
        return blockSelection;
    }

    String getTextForSelection() {
        FieldSelection selection = this.getSelection();
        if (selection == null) {
            return null;
        }
        return FieldSelectionHelper.getAllSelectedText((FieldSelection)selection, (FieldPanel)this);
    }

    FieldLocation getFieldLocation(ByteBlock block, BigInteger offset) {
        return this.indexMap.getFieldLocation(block, offset, this.fieldFactories);
    }

    void enableIndexUpdate(boolean b) {
        this.indexUpdate = b;
    }

    int getNumberOfFields() {
        return this.fieldFactories.length;
    }

    ByteField getField(BigInteger index, int fieldNum) {
        if (this.indexMap != null) {
            int fieldOffset = this.indexMap.getFieldOffset(index, fieldNum, this.fieldFactories);
            if (fieldNum < this.fieldFactories.length) {
                return (ByteField)this.fieldFactories[fieldOffset].getField(index);
            }
        }
        return null;
    }

    public AddressSetView getView() {
        AddressSet result = new AddressSet();
        if (this.blockSet != null) {
            for (ByteBlock block : this.blockSet.getBlocks()) {
                Address start = this.blockSet.getBlockStart(block);
                result.add(start, start.add(block.getLength().longValue() - 1L));
            }
        }
        return result;
    }

    private class ByteViewerBackgroundColorModel
    implements BackgroundColorModel {
        private Color defaultBackgroundColor = new GColor("color.bg.byteviewer");

        private ByteViewerBackgroundColorModel() {
        }

        public Color getBackgroundColor(BigInteger index) {
            if (this.indexIsInCurrentLine(index)) {
                return ByteViewerComponent.this.currentCursorLineColor;
            }
            return this.defaultBackgroundColor;
        }

        private boolean indexIsInCurrentLine(BigInteger layoutIndex) {
            Field currentField = ByteViewerComponent.this.getCurrentField();
            if (!(currentField instanceof ByteField)) {
                return false;
            }
            ByteField currentByteField = (ByteField)currentField;
            BigInteger currentIndex = currentByteField.getIndex();
            Layout layout = ByteViewerComponent.this.layoutModel.getLayout(layoutIndex);
            int n = layout.getNumFields();
            for (int i = 0; i < n; ++i) {
                ByteField byteField;
                BigInteger fieldLayoutIndex;
                Field field = layout.getField(i);
                if (!(field instanceof ByteField) || !(fieldLayoutIndex = (byteField = (ByteField)field).getIndex()).equals(currentIndex)) continue;
                return true;
            }
            return false;
        }

        public Color getDefaultBackgroundColor() {
            return this.defaultBackgroundColor;
        }

        public void setDefaultBackgroundColor(Color c) {
            this.defaultBackgroundColor = c;
        }
    }
}

