/*
 * Decompiled with CFR 0.152.
 */
package help;

import generic.application.GenericApplicationLayout;
import generic.theme.HeadlessThemeManager;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import help.HelpBuildUtils;
import help.JavaHelpFilesBuilder;
import help.JavaHelpSetBuilder;
import help.validator.DuplicateAnchorCollection;
import help.validator.JavaHelpValidator;
import help.validator.LinkDatabase;
import help.validator.links.InvalidLink;
import help.validator.location.HelpModuleCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import utility.application.ApplicationLayout;

public class GHelpBuilder {
    private static final String TOC_OUTPUT_FILE_APPENDIX = "_TOC.xml";
    private static final String MAP_OUTPUT_FILE_APPENDIX = "_map.xml";
    private static final String HELP_SET_OUTPUT_FILE_APPENDIX = "_HelpSet.hs";
    private static final String HELP_SEARCH_DIRECTORY_APPENDIX = "_JavaHelpSearch";
    private static final String OUTPUT_DIRECTORY_OPTION = "-o";
    private static final String MODULE_NAME_OPTION = "-n";
    private static final String HELP_PATHS_OPTION = "-hp";
    private static final String DEBUG_SWITCH = "-debug";
    private static final String IGNORE_INVALID_SWITCH = "-ignoreinvalid";
    private String outputDirectoryName;
    private String moduleName;
    private Collection<File> dependencyHelpPaths = new LinkedHashSet<File>();
    private Collection<File> helpInputDirectories = new LinkedHashSet<File>();
    private static boolean debugEnabled = false;
    private boolean ignoreInvalid = false;
    boolean exitOnError = false;
    boolean failed = false;

    public static void main(String[] args) throws Exception {
        GHelpBuilder builder = new GHelpBuilder();
        builder.exitOnError = true;
        ApplicationConfiguration config = new ApplicationConfiguration(){

            protected void initializeApplication() {
                HeadlessThemeManager.initialize();
            }
        };
        Application.initializeApplication((ApplicationLayout)new GenericApplicationLayout("Help Builder", "0.1"), (ApplicationConfiguration)config);
        builder.build(args);
    }

    void build(String[] args) {
        this.parseArguments(args);
        HelpModuleCollection allHelp = this.collectAllHelp();
        LinkDatabase linkDatabase = new LinkDatabase(allHelp);
        GHelpBuilder.debug("Validating help directories...");
        Results results = this.validateHelpDirectories(allHelp, linkDatabase);
        if (results.failed()) {
            String message = "Found invalid help:\n" + results.getMessage();
            if (this.ignoreInvalid) {
                GHelpBuilder.printErrorMessage(message);
            } else {
                this.exitWithError(message, null);
            }
        }
        GHelpBuilder.debug("\tfinished validating help directories");
        GHelpBuilder.debug("Building JavaHelp output files...");
        this.buildJavaHelpFiles(linkDatabase);
        GHelpBuilder.debug("\tfinished building output files");
    }

    private HelpModuleCollection collectAllHelp() {
        ArrayList<File> allHelp = new ArrayList<File>(this.helpInputDirectories);
        for (File file : this.dependencyHelpPaths) {
            allHelp.add(file);
        }
        return HelpModuleCollection.fromFiles(allHelp);
    }

    private Results validateHelpDirectories(HelpModuleCollection help, LinkDatabase linkDatabase) {
        JavaHelpValidator validator = new JavaHelpValidator(this.moduleName, help);
        validator.setDebugEnabled(debugEnabled);
        Collection<InvalidLink> invalidLinks = validator.validate(linkDatabase);
        Collection<DuplicateAnchorCollection> duplicateAnchors = linkDatabase.getDuplicateAnchors();
        if (invalidLinks.size() == 0 && duplicateAnchors.size() == 0) {
            return new Results("Finished validating help files--all valid!", false);
        }
        GHelpBuilder.flush();
        StringBuilder buildy = new StringBuilder();
        if (invalidLinks.size() > 0) {
            buildy.append('[').append(JavaHelpValidator.class.getSimpleName()).append(']');
            buildy.append(" - Found the following ").append(invalidLinks.size()).append(" invalid links:\n");
            for (InvalidLink invalidLink : invalidLinks) {
                buildy.append("Module ").append(this.moduleName).append(" - ").append(invalidLink);
                buildy.append('\n').append("\n");
            }
        }
        if (duplicateAnchors.size() > 0) {
            buildy.append('[').append(JavaHelpValidator.class.getSimpleName()).append(']');
            buildy.append(" - Found the following ").append(duplicateAnchors.size()).append(" topic(s) with duplicate anchor definitions:\n");
            for (DuplicateAnchorCollection collection : duplicateAnchors) {
                buildy.append(collection).append('\n').append("\n");
            }
        }
        return new Results(buildy.toString(), true);
    }

    private void buildJavaHelpFiles(LinkDatabase linkDatabase) {
        Path outputDirectory = Paths.get(this.outputDirectoryName, new String[0]);
        JavaHelpFilesBuilder fileBuilder = new JavaHelpFilesBuilder(outputDirectory, this.moduleName, linkDatabase);
        HelpModuleCollection help = HelpModuleCollection.fromFiles(this.helpInputDirectories);
        try {
            fileBuilder.generateHelpFiles(help);
        }
        catch (Exception e) {
            this.exitWithError("Unexpected error building help module files:\n", e);
        }
        Path helpSetFile = outputDirectory.resolve(this.moduleName + HELP_SET_OUTPUT_FILE_APPENDIX);
        Path helpMapFile = outputDirectory.resolve(this.moduleName + MAP_OUTPUT_FILE_APPENDIX);
        Path helpTOCFile = outputDirectory.resolve(this.moduleName + TOC_OUTPUT_FILE_APPENDIX);
        Path indexerOutputDirectory = outputDirectory.resolve(this.moduleName + HELP_SEARCH_DIRECTORY_APPENDIX);
        JavaHelpSetBuilder helpSetBuilder = new JavaHelpSetBuilder(this.moduleName, helpMapFile, helpTOCFile, indexerOutputDirectory, helpSetFile);
        try {
            helpSetBuilder.writeHelpSetFile();
        }
        catch (IOException e) {
            this.exitWithError("\tError building helpset for module: " + this.moduleName + "\n", e);
        }
    }

    private void exitWithError(String message, Throwable t) {
        this.failed = true;
        GHelpBuilder.flush();
        if (!this.exitOnError) {
            System.err.println(message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            return;
        }
        PrintErrorRunnable runnable = new PrintErrorRunnable(message, t);
        Thread thread = new Thread(runnable);
        thread.setDaemon(false);
        thread.start();
        try {
            thread.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    private static void flush() {
        System.out.flush();
        System.out.println();
        System.out.flush();
        System.err.flush();
        System.err.println();
        System.err.flush();
    }

    private static void debug(String string) {
        if (debugEnabled) {
            GHelpBuilder.flush();
            System.out.println("[" + GHelpBuilder.class.getSimpleName() + "] " + string);
        }
    }

    private void parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            if (opt.equals(OUTPUT_DIRECTORY_OPTION)) {
                if (++i >= args.length) {
                    GHelpBuilder.errorMessage("-o requires an argument");
                    GHelpBuilder.printUsage();
                    System.exit(1);
                }
                this.outputDirectoryName = args[i];
                continue;
            }
            if (opt.equals(MODULE_NAME_OPTION)) {
                if (++i >= args.length) {
                    GHelpBuilder.errorMessage("-n requires an argument");
                    GHelpBuilder.printUsage();
                    System.exit(1);
                }
                this.moduleName = args[i];
                continue;
            }
            if (opt.equals(HELP_PATHS_OPTION)) {
                String hp;
                if (++i >= args.length) {
                    GHelpBuilder.errorMessage("-hp requires an argument");
                    GHelpBuilder.printUsage();
                    System.exit(1);
                }
                if ((hp = args[i]).length() <= 0) continue;
                for (String p : hp.split(File.pathSeparator)) {
                    this.dependencyHelpPaths.add(new File(p));
                }
                continue;
            }
            if (opt.equals(DEBUG_SWITCH)) {
                debugEnabled = true;
                continue;
            }
            if (opt.equals(IGNORE_INVALID_SWITCH)) {
                this.ignoreInvalid = true;
                continue;
            }
            if (opt.startsWith("-")) {
                GHelpBuilder.errorMessage("Unknown option " + opt);
                GHelpBuilder.printUsage();
                System.exit(1);
                continue;
            }
            this.helpInputDirectories.add(new File(opt));
        }
        HelpBuildUtils.debug = debugEnabled;
        if (this.helpInputDirectories.size() == 0) {
            GHelpBuilder.errorMessage("Must specify at least one input directory");
            GHelpBuilder.printUsage();
            System.exit(1);
        }
        if (this.outputDirectoryName == null) {
            GHelpBuilder.errorMessage("Missing output directory: -o [output]");
            GHelpBuilder.printUsage();
            System.exit(1);
        }
        if (this.moduleName == null) {
            GHelpBuilder.errorMessage("Missing module name: -n [name]");
            GHelpBuilder.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        StringBuilder buffy = new StringBuilder();
        buffy.append("Usage: ");
        buffy.append(GHelpBuilder.class.getName()).append(" [-options] [inputs...]\n");
        buffy.append("          (to build help for a Ghidra module)\n");
        buffy.append("where options include:\n");
        buffy.append("    ").append(OUTPUT_DIRECTORY_OPTION).append(" <output directory>\n");
        buffy.append("                  REQUIRED to specify the output location of the built help\n");
        buffy.append("    ").append(DEBUG_SWITCH).append("        to enable debugging output\n");
        buffy.append("    ").append(IGNORE_INVALID_SWITCH).append("\n");
        buffy.append("                  to continue despite broken links and anchors\n");
        GHelpBuilder.errorMessage(buffy.toString());
    }

    private static void printErrorMessage(String message) {
        GHelpBuilder.flush();
        GHelpBuilder.errorMessage(message);
    }

    private static void errorMessage(String message) {
        GHelpBuilder.errorMessage(message, null);
    }

    private static void errorMessage(String message, Throwable t) {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("[" + GHelpBuilder.class.getSimpleName() + "] " + message);
        if (t != null) {
            t.printStackTrace();
        }
        GHelpBuilder.flush();
    }

    private static class Results {
        private final String message;
        private final boolean failed;

        Results(String message, boolean failed) {
            this.message = message;
            this.failed = failed;
        }

        String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }

        boolean failed() {
            return this.failed;
        }
    }

    private static class PrintErrorRunnable
    implements Runnable {
        private String message;
        private Throwable t;

        PrintErrorRunnable(String message, Throwable t) {
            this.message = message;
            this.t = t;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println(this.message);
            if (this.t != null) {
                this.t.printStackTrace(System.err);
            }
        }
    }
}

