/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.gadp.impl;

import agent.dbgeng.dbgeng.DebugAdvanced;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.dbgeng.DebugEventCallbacks;
import agent.dbgeng.dbgeng.DebugInputCallbacks;
import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugOutputCallbacks;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugProcessRecord;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugRunningProcess;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugSymbolEntry;
import agent.dbgeng.dbgeng.DebugSymbolId;
import agent.dbgeng.dbgeng.DebugSymbolName;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgmodel.dbgmodel.bridge.HostDataModelAccess;
import agent.dbgmodel.dbgmodel.debughost.DebugHost;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.debughost.DebugHostMemory1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostModule1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbol1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbolEnumerator;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbols;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.DebugRunningProcessImpl;
import agent.dbgmodel.impl.dbgmodel.bridge.HDMAUtil;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.WinDef;
import ghidra.comm.util.BitmaskSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WrappedDbgModel
implements DebugClient,
DebugSystemObjects,
DebugRegisters,
DebugDataSpaces,
DebugSymbols {
    private HDMAUtil util;
    private DebugClient client;
    private HashMap<Object, String> map = new HashMap();
    private boolean USE_CLIENT = false;

    public WrappedDbgModel(HostDataModelAccess access) {
        this.util = new HDMAUtil(access);
        this.client = access.getClient();
        System.err.println(">>>>>>>>>>>>  USING WRAPPED DBGMODEL  <<<<<<<<<<<<<<");
    }

    public DebugClient getClient() {
        return this;
    }

    public DebugAdvanced getAdvanced() {
        return this.client.getAdvanced();
    }

    public DebugControl getControl() {
        return this.client.getControl();
    }

    public DebugDataSpaces getDataSpaces() {
        return this;
    }

    public DebugRegisters getRegisters() {
        return this;
    }

    public DebugSystemObjects getSystemObjects() {
        return this;
    }

    public DebugSymbols getSymbols() {
        return this;
    }

    public Map<String, ModelObject> getAttributes(List<String> path) {
        return this.getUtil().getAttributes(path);
    }

    public List<ModelObject> getElements(List<String> path) {
        return this.getUtil().getElements(path);
    }

    public ModelObject getMethod(List<String> path) {
        return this.getUtil().getMethod(path);
    }

    public void attachProcess(DebugServerId si, long processId, BitmaskSet<DebugClient.DebugAttachFlags> attachFlags) {
        this.client.attachProcess(si, processId, attachFlags);
    }

    public void createProcess(DebugServerId si, String commandLine, String initialDirectory, String environment, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags, BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags) {
        this.client.createProcess(si, commandLine, initialDirectory, environment, createFlags, engCreateFlags, verifierFlags);
    }

    public void createProcessAndAttach(DebugServerId si, String commandLine, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, int processId, BitmaskSet<DebugClient.DebugAttachFlags> attachFlags) {
        this.client.createProcessAndAttach(si, commandLine, createFlags, processId, attachFlags);
    }

    public void abandonCurrentProcess() {
        this.client.abandonCurrentProcess();
    }

    public void startServer(String options) {
        this.client.startServer(options);
    }

    public void waitForProcessServerEnd(int timeout) {
        this.client.waitForProcessServerEnd(timeout);
    }

    public void terminateCurrentProcess() {
        this.client.terminateCurrentProcess();
    }

    public void detachCurrentProcess() {
        this.client.detachCurrentProcess();
    }

    public void connectSession(int flags) {
        this.client.connectSession(flags);
    }

    public void endSession(DebugClient.DebugEndSessionFlags flags) {
        this.client.endSession(flags);
    }

    public HDMAUtil getUtil() {
        return this.util;
    }

    public DebugClient createClient() {
        return this.client;
    }

    public void endSessionReentrant() {
        this.client.endSessionReentrant();
    }

    public DebugServerId getLocalServer() {
        return this.client.getLocalServer();
    }

    public void attachKernel(long flags, String options) {
        this.client.attachKernel(flags, options);
    }

    public void startProcessServer(String options) {
        this.client.startProcessServer(options);
    }

    public DebugServerId connectProcessServer(String options) {
        return this.client.connectProcessServer(options);
    }

    public boolean dispatchCallbacks(int timeout) {
        return this.client.dispatchCallbacks(timeout);
    }

    public void flushCallbacks() {
        this.client.flushCallbacks();
    }

    public void exitDispatch(DebugClient client) {
        client.exitDispatch(client);
    }

    public void setInputCallbacks(DebugInputCallbacks cb) {
        this.client.setInputCallbacks(cb);
    }

    public void setOutputCallbacks(DebugOutputCallbacks cb) {
        this.client.setOutputCallbacks(cb);
    }

    public void setEventCallbacks(DebugEventCallbacks cb) {
        this.client.setEventCallbacks(cb);
    }

    public DebugRunningProcess.Description getProcessDescription(DebugServerId si, int systemId, BitmaskSet<DebugRunningProcess.Description.ProcessDescriptionFlags> flags) {
        return this.client.getProcessDescription(si, systemId, flags);
    }

    public void openDumpFileWide(String fileName) {
        this.client.openDumpFileWide(fileName);
    }

    public int readVirtual(long offset, ByteBuffer buf, int remaining) {
        DebugHostContext currentContext = this.getUtil().getCurrentContext();
        DebugHost host = this.getUtil().getHost();
        WinDef.ULONGLONG ulOffset = new WinDef.ULONGLONG(offset);
        DbgModelNative.LOCATION base = new DbgModelNative.LOCATION(ulOffset);
        DebugHostMemory1 memory = host.asMemory();
        return (int)memory.readBytes(currentContext, base, buf, remaining);
    }

    public int writeVirtual(long offset, ByteBuffer buf, int remaining) {
        DebugHostContext currentContext = this.getUtil().getCurrentContext();
        DebugHost host = this.getUtil().getHost();
        WinDef.ULONGLONG ulOffset = new WinDef.ULONGLONG(offset);
        DbgModelNative.LOCATION base = new DbgModelNative.LOCATION(ulOffset);
        DebugHostMemory1 memory = host.asMemory();
        return (int)memory.writeBytes(currentContext, base, buf, remaining);
    }

    public int readVirtualUncached(long offset, ByteBuffer into, int len) {
        return this.readVirtual(offset, into, len);
    }

    public int writeVirtualUncached(long offset, ByteBuffer from, int len) {
        return this.readVirtual(offset, from, len);
    }

    public int readPhysical(long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().readPhysical(offset, buf, remaining);
    }

    public int writePhysical(long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().writePhysical(offset, buf, remaining);
    }

    public int readControl(int processor, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().readControl(processor, offset, buf, remaining);
    }

    public int writeControl(int processor, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().writeControl(processor, offset, buf, remaining);
    }

    public int readBusData(int busDataType, int busNumber, int slotNumber, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().readBusData(busDataType, busNumber, slotNumber, offset, buf, remaining);
    }

    public int writeBusData(int busDataType, int busNumber, int slotNumber, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().writeBusData(busDataType, busNumber, slotNumber, offset, buf, remaining);
    }

    public int readIo(int interfaceType, int busNumber, int addressSpace, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().readIo(interfaceType, busNumber, addressSpace, offset, buf, remaining);
    }

    public int writeIo(int interfaceType, int busNumber, int addressSpace, long offset, ByteBuffer buf, int remaining) {
        return this.client.getDataSpaces().writeIo(interfaceType, busNumber, addressSpace, offset, buf, remaining);
    }

    public long readMsr(int msr) {
        return this.client.getDataSpaces().readMsr(msr);
    }

    public void writeMsr(int msr, long value) {
        this.client.getDataSpaces().writeMsr(msr, value);
    }

    public int readDebuggerData(int offset, ByteBuffer buf, int remaining) {
        DebugHostContext currentContext = this.getUtil().getCurrentContext();
        DebugHost host = this.getUtil().getHost();
        WinDef.ULONGLONG ulOffset = new WinDef.ULONGLONG((long)offset);
        DbgModelNative.LOCATION base = new DbgModelNative.LOCATION(ulOffset);
        DebugHostMemory1 memory = host.asMemory();
        return (int)memory.readBytes(currentContext, base, buf, remaining);
    }

    public DebugDataSpaces.DebugMemoryBasicInformation queryVirtual(long offset) {
        return this.client.getDataSpaces().queryVirtual(offset);
    }

    public long virtualToPhysical(long offset) {
        return this.client.getDataSpaces().virtualToPhysical(offset);
    }

    public DebugRegisters.DebugRegisterDescription getRegisterDescription(int i) {
        return this.client.getRegisters().getDescription(i);
    }

    public Set<DebugRegisters.DebugRegisterDescription> getAllRegisterDescriptions() {
        return this.client.getRegisters().getAllDescriptions();
    }

    public int getNumberRegisters() {
        return this.client.getRegisters().getNumberRegisters();
    }

    public DebugRegisters.DebugRegisterDescription getDescription(int registerNumber) {
        return this.getRegisterDescription(registerNumber);
    }

    public int getIndexByName(String name) {
        return this.client.getRegisters().getIndexByName(name);
    }

    public DebugValue getValueByName(String name) {
        return this.client.getRegisters().getValueByName(name);
    }

    public DebugValue getValue(int index) {
        return this.client.getRegisters().getValue(index);
    }

    public Map<Integer, DebugValue> getValues(DebugRegisters.DebugRegisterSource source, Collection<Integer> indices) {
        return this.client.getRegisters().getValues(source, indices);
    }

    public void setValueByName(String name, DebugValue value) {
        this.setValue(this.getIndexByName(name), value);
    }

    public void setValue(int index, DebugValue value) {
        this.client.getRegisters().setValue(index, value);
    }

    public void setValues(DebugRegisters.DebugRegisterSource source, Map<Integer, DebugValue> values) {
        this.client.getRegisters().setValues(source, values);
    }

    public List<DebugThreadId> getThreadIds() {
        ArrayList<DebugThreadId> ids = null;
        ModelObject currentSession = this.getUtil().getCurrentSession();
        ModelObject currentProcess = this.getUtil().getCurrentProcess();
        String pid = this.getUtil().getCtlId(currentProcess);
        List<ModelObject> runningThreads = this.getUtil().getRunningThreads(currentSession, pid);
        ids = new ArrayList<DebugThreadId>();
        for (ModelObject t : runningThreads) {
            String tid = this.getUtil().getCtlId(t);
            ids.add(this.tid2dti(tid));
        }
        return ids;
    }

    public List<DebugProcessId> getProcessIds() {
        ArrayList<DebugProcessId> ids = new ArrayList<DebugProcessId>();
        List<DebugRunningProcess> procs = this.getRunningProcesses(this.sid2dsi());
        for (DebugRunningProcess p : procs) {
            try {
                ids.add(this.pid2dpi("0x" + Integer.toHexString(p.getSystemId())));
            }
            catch (COMException e) {
                System.err.println(p.getSystemId());
            }
        }
        return ids;
    }

    public void setCurrentSystemId(DebugSessionId dpi) {
        this.client.getSystemObjects().setCurrentSystemId(dpi);
    }

    public void setCurrentProcessId(DebugProcessId dpi) {
        this.client.getSystemObjects().setCurrentProcessId(dpi);
    }

    public void setCurrentThreadId(DebugThreadId dti) {
        DebugSystemObjects so = this.client.getSystemObjects();
        DebugThreadId currentThreadId = so.getCurrentThreadId();
        if (!dti.id().equals(currentThreadId.id())) {
            so.setCurrentThreadId(dti);
        }
    }

    public DebugSessionId getCurrentSystemId() {
        return this.client.getSystemObjects().getCurrentSystemId();
    }

    public DebugProcessId getCurrentProcessId() {
        ModelObject currentProcess = this.getUtil().getCurrentProcess();
        DebugProcessId dpi = this.client.getSystemObjects().getCurrentProcessId();
        if (currentProcess != null) {
            String id = this.getUtil().getCtlId(currentProcess);
            this.addObj(dpi, id);
        }
        return dpi;
    }

    public DebugThreadId getCurrentThreadId() {
        ModelObject currentThread = this.getUtil().getCurrentThread();
        DebugThreadId dti = this.client.getSystemObjects().getCurrentThreadId();
        if (currentThread != null) {
            String id = this.getUtil().getCtlId(currentThread);
            this.addObj(dti, id);
        }
        return dti;
    }

    public DebugProcessId getProcessIdByHandle(long handle) {
        return this.client.getSystemObjects().getProcessIdByHandle(handle);
    }

    public DebugThreadId getThreadIdByHandle(long handle) {
        return this.client.getSystemObjects().getThreadIdByHandle(handle);
    }

    public DebugSessionId getEventSystem() {
        return this.client.getSystemObjects().getEventSystem();
    }

    public DebugProcessId getEventProcess() {
        return this.client.getSystemObjects().getEventProcess();
    }

    public DebugThreadId getEventThread() {
        return this.client.getSystemObjects().getEventThread();
    }

    public List<DebugRunningProcess> getRunningProcesses(DebugServerId si) {
        List<ModelObject> processes = this.getUtil().getRunningProcesses(this.obj2id(si));
        ArrayList<DebugRunningProcess> result = new ArrayList<DebugRunningProcess>(processes.size());
        for (ModelObject child : processes) {
            String pid = this.getUtil().getCtlId(child);
            result.add(new DebugRunningProcessImpl(pid, child, si));
        }
        return result;
    }

    public int getCurrentThreadSystemId() {
        return this.client.getSystemObjects().getCurrentThreadSystemId();
    }

    public int getCurrentProcessSystemId() {
        return this.client.getSystemObjects().getCurrentProcessSystemId();
    }

    public long getCurrentThreadDataOffset() {
        return this.client.getSystemObjects().getCurrentThreadDataOffset();
    }

    public long getCurrentProcessDataOffset() {
        return this.client.getSystemObjects().getCurrentProcessDataOffset();
    }

    public long getImplicitThreadDataOffset() {
        return this.client.getSystemObjects().getImplicitThreadDataOffset();
    }

    public long getImplicitProcessDataOffset() {
        return this.client.getSystemObjects().getImplicitProcessDataOffset();
    }

    public void setImplicitThreadDataOffset(long offset) {
        this.client.getSystemObjects().setImplicitThreadDataOffset(offset);
    }

    public void setImplicitProcessDataOffset(long offset) {
        this.client.getSystemObjects().setImplicitProcessDataOffset(offset);
    }

    public int getNumberThreads() {
        return this.client.getSystemObjects().getNumberThreads();
    }

    public List<DebugThreadId> getThreads(int start, int count) {
        return this.client.getSystemObjects().getThreads(start, count);
    }

    public int getNumberProcesses() {
        return this.client.getSystemObjects().getNumberProcesses();
    }

    public List<DebugProcessId> getProcesses(int start, int count) {
        return this.client.getSystemObjects().getProcesses(start, count);
    }

    public int getNumberSystems() {
        return this.client.getSystemObjects().getNumberSystems();
    }

    public List<DebugSessionId> getSystems(int start, int count) {
        return this.client.getSystemObjects().getSystems(start, count);
    }

    public DebugThreadId getThreadIdBySystemId(int systemId) {
        return this.client.getSystemObjects().getThreadIdBySystemId(systemId);
    }

    public DebugProcessId getProcessIdBySystemId(int systemId) {
        return this.client.getSystemObjects().getProcessIdBySystemId(systemId);
    }

    public int getTotalNumberThreads() {
        return this.client.getSystemObjects().getTotalNumberThreads();
    }

    public List<DebugHostModule1> getDebugHostModules() {
        DebugHostSymbol1 next;
        DebugHostSymbols symbols = this.getUtil().getHost().asSymbols();
        DebugHostSymbolEnumerator enumerator = symbols.enumerateModules(this.getUtil().getCurrentContext());
        ArrayList<DebugHostModule1> list = new ArrayList<DebugHostModule1>();
        while ((next = enumerator.getNext()) != null) {
            list.add(next.asModule());
        }
        return list;
    }

    public List<DebugModule> getModuleList() {
        return this.getUtil().getModuleList();
    }

    public int getNumberLoadedModules() {
        return this.getModuleList().size();
    }

    public int getNumberUnloadedModules() {
        return this.client.getSymbols().getNumberUnloadedModules();
    }

    public DebugModule getModuleByIndex(int index) {
        List<DebugModule> modules = this.getModuleList();
        return modules.get(index);
    }

    public DebugModule getModuleByModuleName(String name, int startIndex) {
        List<DebugModule> modules = this.getModuleList();
        for (DebugModule module : modules) {
            String moduleName = module.getName(null);
            if (!moduleName.equals(name)) continue;
            return module;
        }
        System.err.println(name + " not found");
        return null;
    }

    public DebugModule getModuleByOffset(long offset, int startIndex) {
        List<DebugModule> modules = this.getModuleList();
        long min = Long.MAX_VALUE;
        DebugModule ret = null;
        for (DebugModule module : modules) {
            long baseAddress = module.getBase();
            if (offset < baseAddress || baseAddress >= min) continue;
            min = baseAddress;
            ret = module;
        }
        return ret;
    }

    public DebugModuleInfo getModuleParameters(int count, int startIndex) {
        return this.client.getSymbols().getModuleParameters(count, startIndex);
    }

    public Iterable<DebugSymbolName> iterateSymbolMatches(String pattern) {
        return this.client.getSymbols().iterateSymbolMatches(pattern);
    }

    public List<DebugSymbolId> getSymbolIdsByName(String pattern) {
        return this.client.getSymbols().getSymbolIdsByName(pattern);
    }

    public DebugSymbolEntry getSymbolEntry(DebugSymbolId id) {
        return this.client.getSymbols().getSymbolEntry(id);
    }

    public String getSymbolPath() {
        return this.client.getSymbols().getSymbolPath();
    }

    public void setSymbolPath(String path) {
        this.client.getSymbols().setSymbolPath(path);
    }

    public int getSymbolOptions() {
        return this.client.getSymbols().getSymbolOptions();
    }

    public void setSymbolOptions(int options) {
        this.client.getSymbols().setSymbolOptions(options);
    }

    private DebugServerId sid2dsi() {
        DebugServerId dsi = new DebugServerId(0L);
        this.addObj(dsi, "0");
        return dsi;
    }

    private DebugProcessId pid2dpi(String id) {
        int pid;
        if (!((String)id).startsWith("0x")) {
            id = "0x" + (String)id;
        }
        if ((pid = Integer.decode((String)id).intValue()) == 0) {
            return new DebugProcessRecord(-1L);
        }
        DebugProcessId dpi = this.client.getSystemObjects().getProcessIdBySystemId(pid);
        this.addObj(dpi, (String)id);
        return dpi;
    }

    private DebugThreadId tid2dti(String id) {
        if (!((String)id).startsWith("0x")) {
            id = "0x" + (String)id;
        }
        int tid = Integer.decode((String)id);
        DebugThreadId dti = this.client.getSystemObjects().getThreadIdBySystemId(tid);
        this.addObj(dti, (String)id);
        return dti;
    }

    private void addObj(Object obj, String id) {
        if (obj == null || id == null) {
            System.err.println("attempt to add null object");
        }
        this.map.put(obj, id);
    }

    private String obj2id(Object obj) {
        String id = this.map.get(obj);
        return id;
    }

    public DebugValue getDebugValue(ModelObject register) {
        DebugValue.DebugInt16Value dv = null;
        Object value = register.getValue();
        if (value instanceof Short) {
            dv = new DebugValue.DebugInt16Value(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            dv = new DebugValue.DebugInt32Value(((Integer)value).intValue());
        } else if (value instanceof Long) {
            dv = new DebugValue.DebugInt64Value(((Long)value).longValue());
        }
        return dv;
    }

    public byte[] encodeAsBytes(ModelObject register) {
        DebugValue.DebugInt16Value dv = null;
        Object value = register.getValue();
        if (value instanceof Short) {
            Short lval = (Short)value;
            dv = new DebugValue.DebugInt16Value(lval.shortValue());
        } else if (value instanceof Integer) {
            Integer lval = (Integer)value;
            dv = new DebugValue.DebugInt32Value(lval.intValue());
        } else if (value instanceof Long) {
            Long lval = (Long)value;
            dv = new DebugValue.DebugInt64Value(lval.longValue());
        } else {
            return new byte[0];
        }
        return dv.encodeAsBytes();
    }

    private DebugValue decodeBytes(ModelObject register, byte[] bytes) {
        DebugValue.DebugInt16Value dv = null;
        Object value = register.getValue();
        if (value instanceof Short) {
            dv = new DebugValue.DebugInt16Value(bytes);
        } else if (value instanceof Integer) {
            dv = new DebugValue.DebugInt32Value(bytes);
        } else if (value instanceof Long) {
            dv = new DebugValue.DebugInt64Value(bytes);
        }
        return dv;
    }

    private DebugValue.DebugValueType getDVType(ModelObject register) {
        Object value = register.getValue();
        if (value instanceof Short) {
            return DebugValue.DebugValueType.INT16;
        }
        if (value instanceof Integer) {
            return DebugValue.DebugValueType.INT32;
        }
        if (value instanceof Long) {
            return DebugValue.DebugValueType.INT64;
        }
        return DebugValue.DebugValueType.INVALID;
    }

    public int getCurrentScopeFrameIndex() {
        return this.client.getSymbols().getCurrentScopeFrameIndex();
    }

    public void setCurrentScopeFrameIndex(int index) {
        this.client.getSymbols().setCurrentScopeFrameIndex(index);
    }
}

