/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyEnumerator;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.concept.DynamicKeyProviderConceptInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.jna.dbgmodel.concept.IDynamicKeyProviderConcept;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyEnumerator;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DynamicKeyProviderConceptImpl
implements DynamicKeyProviderConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDynamicKeyProviderConcept jnaData;
    private ModelObject keyValue;
    private KeyStore metadata;

    public DynamicKeyProviderConceptImpl(IDynamicKeyProviderConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public boolean getKey(ModelObject contextObject, WString key) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppKeyValue = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        WinDef.BOOLByReference pHasKey = new WinDef.BOOLByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKey(pContextObject, key, ppKeyValue, ppMetadata, pHasKey));
        this.keyValue = ModelObjectImpl.getObjectWithMetadata(ppKeyValue, ppMetadata);
        return pHasKey.getValue().booleanValue();
    }

    @Override
    public void setKey(ModelObject contextObject, WString key, ModelObject keyValue, KeyStore conceptMetadata) {
        Pointer pContextObject = contextObject.getPointer();
        Pointer pKeyValue = keyValue.getPointer();
        Pointer pMetadata = conceptMetadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKey(pContextObject, key, pKeyValue, pMetadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator EnumerateKeys(ModelObject contextObject) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateKeys(pContextObject, ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public ModelObject getKeyValue() {
        return this.keyValue;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

