/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSession;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FridaListProcessesCommand
extends AbstractFridaCommand<Map<String, FridaProcess>> {
    private Map<String, FridaProcess> updatedProcesses;
    private FridaSession session;

    public FridaListProcessesCommand(FridaManagerImpl manager, FridaSession session) {
        super(manager);
        this.session = session;
    }

    @Override
    public Map<String, FridaProcess> complete(FridaPendingCommand<?> pending) {
        Map<String, FridaProcess> allProcesses = this.manager.getKnownProcesses(this.session);
        Set<String> cur = allProcesses.keySet();
        for (String id : this.updatedProcesses.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addProcessIfAbsent(this.session, this.updatedProcesses.get(id));
        }
        String sessionId = FridaClient.getId(this.session);
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedProcesses.containsKey(id)) continue;
            this.manager.removeProcess(sessionId, id, FridaCause.Causes.UNCLAIMED);
        }
        return allProcesses;
    }

    @Override
    public void invoke() {
        FridaProcess p = this.session.getProcess();
        this.updatedProcesses = new HashMap<String, FridaProcess>();
        this.updatedProcesses.put(FridaClient.getId(p), p);
    }
}

