/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaSymbol;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class FridaListModuleSymbolsCommand
extends AbstractFridaCommand<Map<String, FridaSymbol>> {
    protected final FridaModule module;
    private Map<String, FridaSymbol> symbols;

    public FridaListModuleSymbolsCommand(FridaManagerImpl manager, FridaModule module) {
        super(manager);
        this.module = module;
    }

    @Override
    public Map<String, FridaSymbol> complete(FridaPendingCommand<?> pending) {
        return this.symbols;
    }

    @Override
    public void invoke() {
        this.symbols = new HashMap<String, FridaSymbol>();
        this.manager.loadScript(this, "list_module_symbols", "result = Process.findModuleByAddress('" + this.module.getRangeAddress() + "').enumerateSymbols();");
        for (FridaSymbol symbol : this.symbols.values()) {
            this.symbols.put(FridaClient.getId(symbol), symbol);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaSymbol symbol = new FridaSymbol(this.module);
        JsonObject symDetails = element.getAsJsonObject();
        symbol.setAddress(symDetails.get("address").getAsString());
        symbol.setSize(symDetails.get("size").getAsLong());
        symbol.setType(symDetails.get("type").getAsString());
        symbol.setName(symDetails.get("name").getAsString());
        symbol.setGlobal(symDetails.get("isGlobal").getAsBoolean());
        JsonElement sect = symDetails.get("section");
        if (sect != null) {
            JsonObject section = (JsonObject)sect;
            symbol.setSectionId(section.get("id").getAsString());
        }
        this.symbols.put(FridaClient.getId(symbol), symbol);
    }
}

