/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.LibObjcDylib;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;

public class DyldCacheProgramBuilder
extends MachoProgramBuilder {
    private boolean shouldProcessSymbols;

    protected DyldCacheProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldAddChainedFixupsRelocations, MessageLog log, TaskMonitor monitor) {
        super(program, provider, fileBytes, shouldAddChainedFixupsRelocations, log, monitor);
        this.shouldProcessSymbols = shouldProcessSymbols;
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldAddChainedFixupsRelocations, MessageLog log, TaskMonitor monitor) throws Exception {
        DyldCacheProgramBuilder dyldCacheProgramBuilder = new DyldCacheProgramBuilder(program, provider, fileBytes, shouldProcessSymbols, shouldAddChainedFixupsRelocations, log, monitor);
        dyldCacheProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        try (DyldCacheUtils.SplitDyldCache splitDyldCache = new DyldCacheUtils.SplitDyldCache(this.provider, this.shouldProcessSymbols, this.log, this.monitor);){
            ByteProvider bp;
            DyldCacheHeader header;
            int i;
            this.setDyldCacheImageBase(splitDyldCache.getDyldCacheHeader(0));
            boolean localSymbolsPresent = false;
            for (i = 0; i < splitDyldCache.size(); ++i) {
                header = splitDyldCache.getDyldCacheHeader(i);
                bp = splitDyldCache.getProvider(i);
                String name = splitDyldCache.getName(i);
                this.processDyldCacheMemoryBlocks(header, name, bp);
                if (header.getLocalSymbolsInfo() == null) continue;
                localSymbolsPresent = true;
            }
            for (i = 0; i < splitDyldCache.size(); ++i) {
                header = splitDyldCache.getDyldCacheHeader(i);
                bp = splitDyldCache.getProvider(i);
                this.fixPageChains(header);
                this.markupHeaders(header);
                this.markupBranchIslands(header, bp);
                this.createLocalSymbols(header);
                this.processDylibs(splitDyldCache, header, bp, localSymbolsPresent);
            }
        }
    }

    private void setDyldCacheImageBase(DyldCacheHeader dyldCacheHeader) throws Exception {
        this.monitor.setMessage("Setting image base...");
        this.monitor.initialize(1L);
        this.program.setImageBase(this.space.getAddress(dyldCacheHeader.getBaseAddress()), true);
        this.monitor.incrementProgress(1L);
    }

    private void processDyldCacheMemoryBlocks(DyldCacheHeader dyldCacheHeader, String name, ByteProvider bp) throws Exception {
        List<DyldCacheMappingInfo> mappingInfos = dyldCacheHeader.getMappingInfos();
        this.monitor.setMessage("Processing DYLD mapped memory blocks...");
        this.monitor.initialize((long)mappingInfos.size());
        FileBytes fb = MemoryBlockUtils.createFileBytes(this.program, bp, this.monitor);
        long endOfMappedOffset = 0L;
        boolean bookmarkSet = false;
        for (DyldCacheMappingInfo mappingInfo : mappingInfos) {
            long offset = mappingInfo.getFileOffset();
            long size = mappingInfo.getSize();
            MemoryBlock block = MemoryBlockUtils.createInitializedBlock(this.program, false, "DYLD", this.space.getAddress(mappingInfo.getAddress()), fb, offset, size, "", "", mappingInfo.isRead(), mappingInfo.isWrite(), mappingInfo.isExecute(), this.log);
            if (offset + size > endOfMappedOffset) {
                endOfMappedOffset = offset + size;
            }
            if (!bookmarkSet) {
                this.program.getBookmarkManager().setBookmark(block.getStart(), "Info", "Dyld Cache Header", name + " - " + dyldCacheHeader.getUUID());
                bookmarkSet = true;
            }
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        if (endOfMappedOffset < bp.length()) {
            this.monitor.setMessage("Processing DYLD unmapped memory block...");
            MemoryBlock fileBlock = MemoryBlockUtils.createInitializedBlock(this.program, true, "FILE", AddressSpace.OTHER_SPACE.getAddress(endOfMappedOffset), fb, endOfMappedOffset, bp.length() - endOfMappedOffset, "Useful bytes that don't get mapped into memory", "", false, false, false, this.log);
            dyldCacheHeader.setFileBlock(fileBlock);
        }
    }

    private void markupHeaders(DyldCacheHeader dyldCacheHeader) throws Exception {
        this.monitor.setMessage("Marking up DYLD headers...");
        this.monitor.initialize(1L);
        dyldCacheHeader.parseFromMemory(this.program, this.space, this.log, this.monitor);
        dyldCacheHeader.markup(this.program, this.space, this.monitor, this.log);
        this.monitor.incrementProgress(1L);
    }

    private void markupBranchIslands(DyldCacheHeader dyldCacheHeader, ByteProvider bp) throws Exception {
        this.monitor.setMessage("Marking up DYLD branch islands...");
        this.monitor.initialize((long)dyldCacheHeader.getBranchPoolAddresses().size());
        for (Long addr : dyldCacheHeader.getBranchPoolAddresses()) {
            try {
                MachHeader header = new MachHeader(bp, addr - dyldCacheHeader.getBaseAddress());
                header.parse();
                super.markupHeaders(header, this.space.getAddress(addr.longValue()));
            }
            catch (MachException | IOException exception) {
                // empty catch block
            }
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
    }

    private void createLocalSymbols(DyldCacheHeader dyldCacheHeader) throws Exception {
        if (!this.shouldProcessSymbols) {
            return;
        }
        DyldCacheLocalSymbolsInfo localSymbolsInfo = dyldCacheHeader.getLocalSymbolsInfo();
        if (localSymbolsInfo == null) {
            return;
        }
        this.monitor.setMessage("Creating DYLD local symbols...");
        this.monitor.initialize((long)localSymbolsInfo.getNList().size());
        for (NList nlist : localSymbolsInfo.getNList()) {
            if (nlist.getString().isBlank()) continue;
            try {
                this.program.getSymbolTable().createLabel(this.space.getAddress(nlist.getValue()), SymbolUtilities.replaceInvalidChars((String)nlist.getString(), (boolean)true), this.program.getGlobalNamespace(), SourceType.IMPORTED);
            }
            catch (Exception e) {
                this.log.appendMsg(e.getMessage() + " " + nlist.getString());
            }
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
    }

    private void fixPageChains(DyldCacheHeader dyldCacheHeader) throws MemoryAccessException, CancelledException {
        List<DyldCacheSlideInfoCommon> slideInfos = dyldCacheHeader.getSlideInfos();
        for (DyldCacheSlideInfoCommon info : slideInfos) {
            int version = info.getVersion();
            this.log.appendMsg("Fixing page chains version: " + version);
            info.fixPageChains(this.program, dyldCacheHeader, this.shouldAddChainedFixupsRelocations, this.log, this.monitor);
        }
    }

    private void processDylibs(DyldCacheUtils.SplitDyldCache splitDyldCache, DyldCacheHeader dyldCacheHeader, ByteProvider bp, boolean localSymbolsPresent) throws Exception {
        this.monitor.setMessage("Parsing DYLIB's...");
        DyldCacheMachoInfo libobjcInfo = null;
        TreeSet<DyldCacheMachoInfo> infoSet = new TreeSet<DyldCacheMachoInfo>((a, b) -> a.headerAddr.compareTo((Object)b.headerAddr));
        List<DyldCacheImage> mappedImages = dyldCacheHeader.getMappedImages();
        this.monitor.initialize((long)mappedImages.size());
        for (DyldCacheImage dyldCacheImage : mappedImages) {
            DyldCacheMachoInfo info = new DyldCacheMachoInfo(splitDyldCache, bp, dyldCacheImage.getAddress() - dyldCacheHeader.getBaseAddress(), this.space.getAddress(dyldCacheImage.getAddress()), dyldCacheImage.getPath());
            infoSet.add(info);
            if (libobjcInfo == null && info.name.contains("libobjc.")) {
                libobjcInfo = info;
            }
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Creating DYLIB exports...");
        this.monitor.initialize((long)infoSet.size());
        boolean exportsCreated = false;
        for (DyldCacheMachoInfo info : infoSet) {
            info.createExports();
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        if (this.shouldProcessSymbols && !localSymbolsPresent) {
            this.monitor.setMessage("Creating DYLIB symbols...");
            this.monitor.initialize((long)infoSet.size());
            for (DyldCacheMachoInfo info : infoSet) {
                info.createSymbols(exportsCreated);
                this.monitor.checkCancelled();
                this.monitor.incrementProgress(1L);
            }
        }
        this.monitor.setMessage("Marking up DYLIB headers...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.markupHeaders();
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Adding DYLIB's to program tree...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.addToProgramTree();
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Processing DYLIB memory blocks...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.processMemoryBlocks();
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Processing libobjc...");
        DyldCacheMachoInfo dyldCacheMachoInfo = infoSet.stream().filter(e -> e.name.contains("libobjc.")).findAny().orElse(null);
        if (dyldCacheMachoInfo != null) {
            LibObjcDylib libObjcDylib = new LibObjcDylib(dyldCacheMachoInfo.header, this.program, this.space, this.log, this.monitor);
            libObjcDylib.markup();
        }
    }

    private class DyldCacheMachoInfo {
        private Address headerAddr;
        private MachHeader header;
        private String path;
        private String name;

        public DyldCacheMachoInfo(DyldCacheUtils.SplitDyldCache splitDyldCache, ByteProvider provider, long offset, Address headerAddr, String path) throws Exception {
            this.headerAddr = headerAddr;
            this.header = new MachHeader(provider, offset, false);
            this.header.parse(splitDyldCache);
            this.path = path;
            this.name = new File(path).getName();
        }

        public void processMemoryBlocks() throws Exception {
            DyldCacheProgramBuilder.this.processMemoryBlocks(this.header, this.name, true, false);
        }

        public boolean createExports() throws Exception {
            return DyldCacheProgramBuilder.this.processExports(this.header);
        }

        public void createSymbols(boolean processExports) throws Exception {
            DyldCacheProgramBuilder.this.processSymbolTables(this.header, processExports);
        }

        public void markupHeaders() throws Exception {
            DyldCacheProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                DyldCacheProgramBuilder.this.listing.setComment(this.headerAddr, 3, this.path);
            }
        }

        public void addToProgramTree() throws Exception {
            ProgramModule module;
            try {
                module = DyldCacheProgramBuilder.this.listing.getDefaultRootModule().createModule(this.path);
            }
            catch (DuplicateNameException e) {
                DyldCacheProgramBuilder.this.log.appendMsg("Failed to add duplicate module to program tree: " + this.path);
                return;
            }
            for (SegmentCommand segment : this.header.getAllSegments()) {
                if (segment.getVMsize() == 0L || segment.getSegmentName().equals("__LINKEDIT")) continue;
                Address segmentStart = DyldCacheProgramBuilder.this.space.getAddress(segment.getVMaddress());
                Address segmentEnd = segmentStart.add(segment.getVMsize() - 1L);
                if (!DyldCacheProgramBuilder.this.memory.contains(segmentEnd)) {
                    segmentEnd = DyldCacheProgramBuilder.this.memory.getBlock(segmentStart).getEnd();
                }
                ProgramFragment segmentFragment = module.createFragment(String.format("%s - %s", segment.getSegmentName(), this.path));
                segmentFragment.move(segmentStart, segmentEnd);
                for (Section section : segment.getSections()) {
                    if (section.getSize() == 0L) continue;
                    Address sectionStart = DyldCacheProgramBuilder.this.space.getAddress(section.getAddress());
                    Address sectionEnd = sectionStart.add(section.getSize() - 1L);
                    if (!DyldCacheProgramBuilder.this.memory.contains(sectionEnd)) {
                        sectionEnd = DyldCacheProgramBuilder.this.memory.getBlock(sectionStart).getEnd();
                    }
                    ProgramFragment sectionFragment = module.createFragment(String.format("%s %s - %s", section.getSegmentName(), section.getSectionName(), this.path));
                    sectionFragment.move(sectionStart, sectionEnd);
                }
                if (!segmentFragment.isEmpty()) continue;
                module.removeChild(segmentFragment.getName());
            }
        }
    }
}

