/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableFile
extends CliAbstractTable {
    public CliTableFile(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliFileRow row = new CliFileRow(reader.readNextInt(), this.readStringIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
            this.blobs.add(row.hashIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "File Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumFileAttributes.dataType, "Flags", "Bitmask of type FileAttributes");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Hash", "index into Blob heap");
        return rowDt;
    }

    public class CliFileRow
    extends CliAbstractTableRow {
        public int flags;
        public int nameIndex;
        public int hashIndex;

        public CliFileRow(int flags, int nameIndex, int hashIndex) {
            this.flags = flags;
            this.nameIndex = nameIndex;
            this.hashIndex = hashIndex;
        }

        @Override
        public String getRepresentation() {
            String hashRep = "Index " + Integer.toHexString(this.hashIndex);
            return String.format("%s Hash %s Flags %s", CliTableFile.this.metadataStream.getStringsStream().getString(this.nameIndex), hashRep, CliFlags.CliEnumFileAttributes.dataType.getName(this.flags & 0xFFFFFFFF));
        }
    }
}

