/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfSymbolRecord
extends OmfRecord {
    private int baseGroupIndex;
    private int baseSegmentIndex;
    private int baseFrame;
    private boolean isStatic;
    private OmfSymbol[] symbol;

    public OmfSymbolRecord(BinaryReader reader, boolean isStatic) throws IOException {
        this.isStatic = isStatic;
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        boolean hasBigFields = this.hasBigFields();
        this.baseGroupIndex = OmfRecord.readIndex(reader);
        this.baseSegmentIndex = OmfRecord.readIndex(reader);
        if (this.baseSegmentIndex == 0) {
            this.baseFrame = reader.readNextShort() & 0xFFFF;
        }
        ArrayList<OmfSymbol> symbollist = new ArrayList<OmfSymbol>();
        while (reader.getPointerIndex() < max) {
            String name = OmfRecord.readString(reader);
            long offset = (long)OmfRecord.readInt2Or4(reader, hasBigFields) & 0xFFFFFFFFL;
            int type = OmfRecord.readIndex(reader);
            OmfSymbol subrec = new OmfSymbol(name, type, offset, 0, 0);
            symbollist.add(subrec);
        }
        this.readCheckSumByte(reader);
        this.symbol = new OmfSymbol[symbollist.size()];
        symbollist.toArray(this.symbol);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getGroupIndex() {
        return this.baseGroupIndex;
    }

    public int getSegmentIndex() {
        return this.baseSegmentIndex;
    }

    public int numSymbols() {
        return this.symbol.length;
    }

    public OmfSymbol getSymbol(int i) {
        return this.symbol[i];
    }

    public List<OmfSymbol> getSymbols() {
        return List.of(this.symbol);
    }
}

