/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime.chantype")
public class GoChanType
extends GoType {
    @FieldMapping
    @MarkupReference(value="element")
    private long elem;
    @FieldMapping
    private long dir;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoType chanGoType = this.programContext.getChanGoType();
        if (chanGoType == null) {
            return this.programContext.getDTM().getPointer(null);
        }
        DataType chanDT = chanGoType.recoverDataType();
        Pointer ptrChanDt = this.programContext.getDTM().getPointer(chanDT);
        if (this.typ.getSize() != (long)ptrChanDt.getLength()) {
            Msg.warn((Object)this, (Object)"Size mismatch between chan type and recovered type");
        }
        TypedefDataType typedef = new TypedefDataType(this.programContext.getRecoveredTypesCp(), this.getStructureName(), (DataType)ptrChanDt, this.programContext.getDTM());
        return typedef;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType element = this.getElement();
        if (element != null) {
            element.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

