/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfNote;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public class NoteGnuBuildId
extends ElfNote {
    private static final int SHA1_DESC_LEN = 20;
    public static final String SECTION_NAME = ".note.gnu.build-id";

    public static NoteGnuBuildId read(ElfNote note, Program program) throws IOException {
        if (!note.isGnu() || note.getDescription().length != 20) {
            throw new IOException("Invalid .note.gnu.build-id values: %s, %d".formatted(note.getName(), note.getDescription().length));
        }
        return new NoteGnuBuildId(note.getNameLen(), note.getName(), note.getVendorType(), note.getDescription());
    }

    public static NoteGnuBuildId fromProgram(Program program) {
        return ElfNote.readFromProgramHelper(program, SECTION_NAME, NoteGnuBuildId::read);
    }

    protected NoteGnuBuildId(int nameLen, String name, int vendorType, byte[] description) {
        super(nameLen, name, vendorType, description);
    }

    public byte[] getHash() {
        return this.getDescription();
    }

    @Override
    public String getNoteTypeName() {
        return "GNU BuildId";
    }

    @Override
    public StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType result = NoteGnuBuildId.createNoteStructure(null, "GnuBuildId", false, this.getNameLen(), 0, dtm);
        result.add((DataType)new ArrayDataType(StructConverter.BYTE, this.getDescriptionLen(), -1, dtm), "hash", "SHA1");
        return result;
    }
}

