/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import ghidra.app.plugin.debug.DomainFolderChangesDisplayComponentProvider;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.STABLE, packageName="Developer", category="Testing", shortDescription="Show Domain Folder change notifications", description="Displays active project domain folder change notifications", servicesRequired={FrontEndService.class})
public class DomainFolderChangesDisplayPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin,
ProjectListener,
DomainFolderChangeListener {
    private DomainFolderChangesDisplayComponentProvider provider;

    public DomainFolderChangesDisplayPlugin(PluginTool tool) {
        super(tool);
        this.provider = new DomainFolderChangesDisplayComponentProvider(tool, this.getName());
    }

    protected void init() {
        Project activeProject = this.tool.getProjectManager().getActiveProject();
        if (activeProject != null) {
            this.projectOpened(activeProject);
        }
        FrontEndService frontEnd = (FrontEndService)this.tool.getService(FrontEndService.class);
        frontEnd.addProjectListener((ProjectListener)this);
        super.init();
    }

    protected void dispose() {
        FrontEndService frontEnd = (FrontEndService)this.tool.getService(FrontEndService.class);
        frontEnd.addProjectListener((ProjectListener)this);
        Project activeProject = this.tool.getProjectManager().getActiveProject();
        if (activeProject != null) {
            this.projectClosed(activeProject);
        }
    }

    public void projectOpened(Project project) {
        project.getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this);
    }

    public void projectClosed(Project project) {
        project.getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
    }

    public void domainFolderAdded(DomainFolder folder) {
        this.provider.addText("domainFolderAdded: " + folder.getPathname());
    }

    public void domainFileAdded(DomainFile file) {
        this.provider.addText("domainFileAdded: " + file.getPathname());
    }

    public void domainFolderRemoved(DomainFolder parent, String name) {
        this.provider.addText("domainFolderRemoved: parent=" + parent.getPathname() + ", name=" + name);
    }

    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.provider.addText("domainFileRemoved: parent=" + parent.getPathname() + ", name=" + name + ", fileID=" + fileID);
    }

    public void domainFolderRenamed(DomainFolder folder, String oldName) {
        this.provider.addText("domainFolderRenamed: " + folder.getPathname() + ", oldName=" + oldName);
    }

    public void domainFileRenamed(DomainFile file, String oldName) {
        this.provider.addText("domainFileRenamed: " + file.getPathname() + ", oldName=" + oldName);
    }

    public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
        this.provider.addText("domainFolderMoved: " + folder.getPathname() + ", oldParent=" + oldParent.getPathname());
    }

    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.provider.addText("domainFileMoved: " + file.getPathname() + ", oldParent=" + oldParent.getPathname() + ", oldName=" + oldName);
    }

    public void domainFolderSetActive(DomainFolder folder) {
        this.provider.addText("domainFolderSetActive: " + folder.getPathname());
    }

    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        this.provider.addText("domainFileStatusChanged: " + file.getPathname() + ", fileIDset=" + Boolean.toString(fileIDset));
    }

    public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
        this.provider.addText("domainFileObjectReplaced: " + file.getPathname());
    }

    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        this.provider.addText("domainFileObjectOpenedForUpdate: " + file.getPathname());
    }

    public void domainFileObjectClosed(DomainFile file, DomainObject object) {
        this.provider.addText("domainFileObjectClosed: " + file.getPathname());
    }
}

