/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.function.CreateExternalFunctionCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;

public class CreateExternalFunctionAction
extends ProgramContextAction {
    FunctionPlugin plugin;

    public CreateExternalFunctionAction(String name, FunctionPlugin plugin) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{name}, null, "Function", -1, "A_Beginning"));
        this.setKeyBindingData(new KeyBindingData(70, 0));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "ExternalFunctions"));
        this.setEnabled(true);
    }

    private Symbol getExternalCodeSymbol(ListingActionContext listingContext) {
        Program program = listingContext.getProgram();
        ProgramSelection selection = listingContext.getSelection();
        if (selection != null && !selection.isEmpty()) {
            return null;
        }
        ProgramLocation location = listingContext.getLocation();
        if (location instanceof OperandFieldLocation) {
            Symbol s;
            OperandFieldLocation opLoc = (OperandFieldLocation)location;
            ReferenceManager refMgr = program.getReferenceManager();
            Reference ref = refMgr.getPrimaryReferenceFrom(opLoc.getAddress(), opLoc.getOperandIndex());
            if (ref != null && ref.isExternalReference() && (s = program.getSymbolTable().getPrimarySymbol(ref.getToAddress())).getSymbolType() == SymbolType.LABEL) {
                return s;
            }
        }
        return null;
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            return this.getExternalCodeSymbol(listingContext) != null;
        }
        if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            if (symbolContext.getSymbolCount() == 0) {
                return false;
            }
            for (Symbol s : symbolContext.getSymbols()) {
                if (s.isExternal() && s.getSymbolType() == SymbolType.LABEL) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void actionPerformed(ProgramActionContext context) {
        CompoundCmd compoundCmd = null;
        CreateExternalFunctionCmd cmd = null;
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            cmd = new CreateExternalFunctionCmd(this.getExternalCodeSymbol(listingContext));
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            for (Symbol s : symbolContext.getSymbols()) {
                CreateExternalFunctionCmd extFuncCmd = new CreateExternalFunctionCmd(s);
                if (cmd != null) {
                    if (compoundCmd == null) {
                        compoundCmd = new CompoundCmd("Create External Functions");
                        compoundCmd.add((Command)cmd);
                    }
                    compoundCmd.add((Command)extFuncCmd);
                    continue;
                }
                cmd = extFuncCmd;
            }
        }
        if (cmd == null) {
            return;
        }
        if (compoundCmd != null) {
            this.plugin.execute(context.getProgram(), (Command)compoundCmd);
        } else {
            this.plugin.execute(context.getProgram(), cmd);
        }
    }
}

