/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.compositeeditor.ComponentProgramActionContext;
import ghidra.app.plugin.core.compositeeditor.ComponentStandAloneActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorActionManager;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.EditorActionListener;
import ghidra.app.plugin.core.compositeeditor.EditorListener;
import ghidra.app.plugin.core.compositeeditor.EditorProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;

public abstract class CompositeEditorProvider
extends ComponentProviderAdapter
implements EditorProvider,
EditorActionListener {
    protected static final Icon EDITOR_ICON = new GIcon("icon.plugin.composite.editor.provider");
    protected Plugin plugin;
    protected Category category;
    protected CompositeEditorPanel editorPanel;
    protected CompositeEditorModel editorModel;
    protected WeakSet<EditorListener> listeners;
    protected DataTypeManagerService dtmService;
    protected CompositeEditorActionManager actionMgr;

    protected CompositeEditorProvider(Plugin plugin) {
        super(plugin.getTool(), "Composite Editor", plugin.getName());
        this.plugin = plugin;
        this.setIcon(EDITOR_ICON);
        this.setTransient();
        this.listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
        this.initializeServices();
    }

    protected String getProviderSubTitle(DataType dataType) {
        String dtmName;
        DataTypeManager dtm = this.editorModel.getOriginalDataTypeManager();
        if (dtm == null) {
            return dataType.getDisplayName();
        }
        if (dtm instanceof ProgramBasedDataTypeManager) {
            ProgramBasedDataTypeManager programDtm = (ProgramBasedDataTypeManager)dtm;
            dtmName = programDtm.getProgram().getDomainFile().getName();
        } else {
            dtmName = dtm.getName();
        }
        return dataType.getDisplayName() + " (" + dtmName + ")";
    }

    protected void updateTitle() {
        this.setTabText(this.editorModel.originalComposite.getName());
        this.setTitle(this.getName() + " - " + this.getProviderSubTitle((DataType)this.editorModel.originalComposite));
    }

    protected CompositeEditorModel getModel() {
        return this.editorModel;
    }

    public JTable getTable() {
        return this.editorPanel.getTable();
    }

    protected void initializeActions() {
        this.actionMgr = new CompositeEditorActionManager(this);
        this.actionMgr.setEditorActions(this.createActions());
        this.actionMgr.addEditorActionListener(this);
    }

    protected void addActionsToTool() {
        CompositeEditorTableAction[] allActions;
        for (CompositeEditorTableAction allAction : allActions = this.actionMgr.getAllActions()) {
            this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)allAction);
        }
    }

    protected CompositeEditorTableAction[] getActions() {
        return this.actionMgr.getAllActions();
    }

    @Override
    public void actionsAdded(CompositeEditorTableAction[] actions) {
        for (CompositeEditorTableAction action : actions) {
            this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)action);
        }
    }

    @Override
    public void actionsRemoved(CompositeEditorTableAction[] actions) {
        for (CompositeEditorTableAction action : actions) {
            this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)action);
        }
    }

    protected void initializeServices() {
        this.dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (this.dtmService == null) {
            throw new AssertException("DataTypeManagerService was not found!");
        }
    }

    protected String getCompositeName() {
        return this.editorModel.getOriginalDataTypeName();
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public void closeComponent() {
        if (this.editorModel != null && this.editorModel.editingField) {
            this.editorModel.endFieldEditing();
        }
        if (this.saveChanges(true) != 0) {
            super.closeComponent();
            this.dispose();
        }
    }

    public JComponent getComponent() {
        return this.editorPanel;
    }

    public DataTypeManagerService getDtmService() {
        return this.dtmService;
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.editorModel.getOriginalDataTypeManager();
    }

    public ActionContext getActionContext(MouseEvent event) {
        DataTypeManager originalDTM;
        DataTypeComponent componentAt = null;
        int[] selectedComponentRows = this.editorModel.getSelectedComponentRows();
        if (selectedComponentRows.length == 1) {
            componentAt = this.editorModel.getComponent(selectedComponentRows[0]);
        }
        if ((originalDTM = this.editorModel.getOriginalDataTypeManager()) instanceof ProgramBasedDataTypeManager) {
            Program program = ((ProgramBasedDataTypeManager)originalDTM).getProgram();
            if (componentAt != null) {
                return new ComponentProgramActionContext(this, program, componentAt);
            }
            return new ProgramActionContext((ComponentProvider)this, program);
        }
        if (componentAt != null && originalDTM instanceof StandAloneDataTypeManager) {
            return new ComponentStandAloneActionContext(this, componentAt);
        }
        return new ActionContext((ComponentProvider)this, null);
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.getHelpTopic(), this.getHelpName());
    }

    public String getHelpName() {
        return this.getName();
    }

    public String getHelpTopic() {
        return this.getOwner();
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public boolean checkForSave(boolean allowCancel) {
        return this.saveChanges(allowCancel) != 0;
    }

    @Override
    public void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
        for (EditorListener el : this.listeners) {
            el.closed(this);
        }
        this.actionMgr.dispose();
        this.editorPanel.dispose();
        this.editorModel.dispose();
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this;
    }

    @Override
    public DataTypePath getDtPath() {
        return this.editorModel.getOriginalDataTypePath();
    }

    @Override
    public boolean isEditing(DataTypePath path) {
        return this.getDtPath().equals((Object)path);
    }

    @Override
    public boolean needsSave() {
        return this.editorModel.hasChanges();
    }

    @Override
    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        this.editorPanel.domainObjectRestored(domainObject);
    }

    @Override
    public void show() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    protected void setStatusMessage(String msg) {
        this.tool.setStatusInfo(msg);
    }

    protected CompositeEditorTableAction[] createActions() {
        return new CompositeEditorTableAction[0];
    }

    protected boolean applyChanges() {
        try {
            return this.editorModel.apply();
        }
        catch (EmptyCompositeException e) {
            this.setStatusMessage(e.getMessage());
        }
        catch (InvalidDataTypeException e) {
            this.setStatusMessage(e.getMessage());
        }
        return false;
    }

    protected int saveChanges(boolean allowCancel) {
        if (this.editorModel.isValidName() && this.editorModel.hasChanges()) {
            String question = "The " + this.editorModel.getTypeName() + " Editor is closing.\nSave the changes to " + this.getDtPath() + "?";
            String title = "Save " + this.editorModel.getTypeName() + " Editor Changes?";
            int response = allowCancel ? OptionDialog.showYesNoCancelDialog((Component)this.editorPanel, (String)title, (String)question) : OptionDialog.showYesNoDialog((Component)this.editorPanel, (String)title, (String)question);
            if (response == 1 && !this.applyChanges()) {
                return 3;
            }
            return response;
        }
        return 2;
    }

    public String getWindowSubMenuName() {
        return this.getName();
    }

    public boolean isTransient() {
        return true;
    }
}

