/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.NotFoundException;

public class PowerPC64_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 21 && elf.is64Bit();
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 21 || !elf.is64Bit()) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return RelocationResult.SKIPPED;
        }
        int symbolIndex = relocation.getSymbolIndex();
        Language language = elfRelocationContext.getProgram().getLanguage();
        if (!"PowerPC".equals(language.getProcessor().toString()) || language.getLanguageDescription().getSize() != 64) {
            PowerPC64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Long.toString(type), null, (String)"Unsupported language for 64-bit PowerPC relocation", (MessageLog)elfRelocationContext.getLog());
        }
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        int oldValue = memory.getInt(relocationAddress);
        int newValue = 0;
        int byteLength = 4;
        long toc = 0L;
        switch (type) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 64: {
                MessageLog log = elfRelocationContext.getLog();
                Symbol tocBaseSym = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"TOC_BASE", err -> log.appendMsg(err));
                if (tocBaseSym == null) {
                    PowerPC64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"TOC_BASE unknown", (MessageLog)log);
                    return RelocationResult.FAILURE;
                }
                toc = tocBaseSym.getAddress().getOffset();
                break;
            }
        }
        switch (type) {
            case 19: {
                PowerPC64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_PPC64_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 1: {
                newValue = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 2: {
                newValue = (int)(symbolValue + addend >> 2);
                newValue = oldValue & 0xFC000003 | newValue << 2;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 3: {
                newValue = (int)(symbolValue + addend);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 4: {
                newValue = (int)(symbolValue + addend);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 48: {
                newValue = (int)(symbolValue + addend - toc);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 64: {
                newValue = (int)(symbolValue + addend - toc >> 2);
                newValue = oldValue >>> 16 & 3 | newValue << 2;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 5: {
                newValue = (int)(symbolValue + addend);
                newValue = newValue >> 16 & 0xFFFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 49: {
                newValue = (int)(symbolValue + addend - toc);
                newValue = newValue >> 16 & 0xFFFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 6: {
                newValue = (int)(symbolValue + addend);
                newValue = (newValue >> 16) + ((newValue & 0x8000) != 0 ? 1 : 0);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 50: {
                newValue = (int)(symbolValue + addend - toc);
                newValue = (newValue >> 16) + ((newValue & 0x8000) != 0 ? 1 : 0);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                newValue = (int)(symbolValue + addend >> 2);
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x3FFFFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 10: {
                symbolValue = this.fixupOPDSymbolValue(elfRelocationContext, sym);
                newValue = (int)(symbolValue + addend - offset >> 2);
                newValue = newValue << 2 & 0x3FFFFFC;
                newValue = oldValue & 0xFC000003 | newValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 22: {
                long value64 = elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 26: {
                newValue = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newValue = (int)(symbolValue + addend - offset) >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x20FFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 21: {
                Address functionDescriptorAddr = relocationAddress.getNewAddress(symbolValue);
                MemoryBlock block = memory.getBlock(functionDescriptorAddr);
                if (block == null) {
                    throw new MemoryAccessException("Function descriptor not found at: " + functionDescriptorAddr);
                }
                if ("EXTERNAL".equals(block.getName())) {
                    memory.setLong(relocationAddress, symbolValue);
                    byteLength = 8;
                    break;
                }
                byte[] bytes = new byte[24];
                memory.getBytes(functionDescriptorAddr, bytes);
                memory.setBytes(relocationAddress, bytes);
                byteLength = bytes.length;
                break;
            }
            case 24: {
                newValue = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 25: {
                newValue = (int)(symbolValue + addend);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 20: 
            case 38: 
            case 43: {
                long value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                PowerPC64_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                PowerPC64_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 51: {
                memory.setLong(relocationAddress, toc);
                byteLength = 8;
                break;
            }
            default: {
                PowerPC64_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private long fixupOPDSymbolValue(ElfRelocationContext elfRelocationContext, ElfSymbol sym) throws MemoryAccessException {
        Address addr = elfRelocationContext.getSymbolAddress(sym);
        if (addr == null) {
            return 0L;
        }
        Program program = elfRelocationContext.getProgram();
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null || !".opd".equals(block.getName())) {
            return addr.getOffset();
        }
        byte[] bytes = new byte[8];
        block.getBytes(addr, bytes);
        boolean bigEndian = elfRelocationContext.getElfHeader().isBigEndian();
        BigEndianDataConverter dataConverter = bigEndian ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
        return dataConverter.getLong(bytes);
    }
}

