/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.remote;

import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFileAdapter;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.framework.store.remote.RemoteFolderItem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RemoteDatabaseItem
extends RemoteFolderItem
implements DatabaseItem {
    RemoteDatabaseItem(RepositoryAdapter repository, RepositoryItem item) {
        super(repository, item);
    }

    @Override
    public long length() throws IOException {
        return this.repository.getLength(this.parentPath, this.itemName);
    }

    @Override
    int getItemType() {
        return 2;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    public ManagedBufferFileAdapter open(int version, int minChangeDataVer) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, version, minChangeDataVer);
    }

    public ManagedBufferFileAdapter open(int version) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, version, -1);
    }

    public ManagedBufferFileAdapter open() throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, -1, -1);
    }

    public ManagedBufferFileAdapter openForUpdate(long checkoutId) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, checkoutId);
    }

    @Override
    public void updateCheckoutVersion(long checkoutId, int checkoutVersion, String user) throws IOException {
        this.repository.updateCheckoutVersion(this.parentPath, this.itemName, checkoutId, checkoutVersion);
    }

    @Override
    public boolean hasCheckouts() throws IOException {
        return this.repository.hasCheckouts(this.parentPath, this.itemName);
    }

    @Override
    public boolean isCheckinActive() throws IOException {
        return this.repository.isCheckinActive(this.parentPath, this.itemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(File outputFile, int version, TaskMonitor monitor) throws IOException, CancelledException {
        try (ManagedBufferFileAdapter bf = this.repository.openDatabase(this.parentPath, this.itemName, version, -1);){
            File tmpFile = File.createTempFile("ghidra", ".tmp");
            tmpFile.delete();
            LocalBufferFile tmpBf = new LocalBufferFile(tmpFile, bf.getBufferSize());
            try {
                LocalBufferFile.copyFile((BufferFile)bf, (BufferFile)tmpBf, null, (TaskMonitor)monitor);
                tmpBf.close();
                FileInputStream itemIn = new FileInputStream(tmpFile);
                try {
                    ItemSerializer.outputItem(this.getName(), this.getContentType(), 0, tmpFile.length(), itemIn, outputFile, monitor);
                }
                finally {
                    try {
                        ((InputStream)itemIn).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                tmpBf.close();
                tmpFile.delete();
            }
        }
    }
}

