/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.X86_64_ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class X86_64_ElfRelocationContext
extends ElfRelocationContext {
    private AddressRange allocatedGotLimits;
    private Address allocatedGotAddress;
    private Address lastAllocatedGotEntryAddress;
    private Address nextAllocatedGotEntryAddress;
    private Map<Long, Address> gotMap;

    X86_64_ElfRelocationContext(X86_64_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
    }

    public long getSymbolValue(ElfSymbol symbol) {
        Address gotAddr;
        long symbolValue = super.getSymbolValue(symbol);
        if (symbolValue == 0L && "_GLOBAL_OFFSET_TABLE_".equals(symbol.getNameAsString()) && (gotAddr = this.allocateGot()) != null) {
            return gotAddr.getOffset();
        }
        return symbolValue;
    }

    public long getGOTValue() throws NotFoundException {
        try {
            return super.getGOTValue();
        }
        catch (NotFoundException e) {
            Address gotAddr = this.allocateGot();
            if (gotAddr != null) {
                return gotAddr.getOffset();
            }
            throw e;
        }
    }

    private ElfSymbol findGotElfSymbol() {
        for (ElfSymbolTable st : this.getElfHeader().getSymbolTables()) {
            for (ElfSymbol s : st.getSymbols()) {
                if (!"_GLOBAL_OFFSET_TABLE_".equals(s.getNameAsString())) continue;
                return s;
            }
        }
        return null;
    }

    private int computeRequiredGotSize() {
        HashSet<Long> uniqueSymbolValues = new HashSet<Long>();
        for (ElfRelocationTable rt : this.getElfHeader().getRelocationTables()) {
            ElfSymbolTable st = rt.getAssociatedSymbolTable();
            if (st == null) continue;
            for (ElfRelocation r : rt.getRelocations()) {
                ElfSymbol elfSymbol;
                int symbolIndex = r.getSymbolIndex();
                if (!this.requiresGotEntry(r) || symbolIndex == 0 || (elfSymbol = st.getSymbol(symbolIndex)) == null) continue;
                uniqueSymbolValues.add(elfSymbol.getValue());
            }
        }
        return Math.max(8, uniqueSymbolValues.size() * 8);
    }

    private boolean requiresGotEntry(ElfRelocation r) {
        switch (r.getType()) {
            case 9: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    private Address allocateGot() {
        this.allocatedGotAddress = Address.NO_ADDRESS;
        this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
        ElfSymbol gotElfSymbol = this.findGotElfSymbol();
        if (gotElfSymbol == null) {
            this.loadHelper.log("GOT allocatiom failed. _GLOBAL_OFFSET_TABLE_ not defined");
            return null;
        }
        if (this.getSymbolAddress(gotElfSymbol) != null) {
            throw new AssertException("_GLOBAL_OFFSET_TABLE_ already allocated");
        }
        int alignment = this.getLoadAdapter().getLinkageBlockAlignment();
        this.allocatedGotLimits = this.getLoadHelper().allocateLinkageBlock(alignment, this.computeRequiredGotSize(), "%got");
        if (this.allocatedGotLimits != null && this.allocatedGotLimits.getMinAddress().getOffset() < Integer.MAX_VALUE) {
            this.symbolMap.put(gotElfSymbol, this.allocatedGotLimits.getMinAddress());
            this.nextAllocatedGotEntryAddress = this.allocatedGotAddress = this.allocatedGotLimits.getMinAddress();
            this.gotMap = new HashMap<Long, Address>();
            this.loadHelper.log("Created %got block required for GOT relocation processing");
            return this.allocatedGotAddress;
        }
        this.loadHelper.log("Failed to allocate %got block required for relocation processing");
        return null;
    }

    private Address getNextAllocatedGotEntryAddress() {
        Address addr;
        if (this.nextAllocatedGotEntryAddress == null) {
            this.allocateGot();
        }
        if ((addr = this.nextAllocatedGotEntryAddress) == Address.NO_ADDRESS) {
            return Address.NO_ADDRESS;
        }
        try {
            int pointerSize = this.loadHelper.getProgram().getDefaultPointerSize();
            Address lastAddr = this.nextAllocatedGotEntryAddress.addNoWrap((long)(pointerSize - 1));
            if (this.allocatedGotLimits.contains(lastAddr)) {
                this.lastAllocatedGotEntryAddress = lastAddr;
                this.nextAllocatedGotEntryAddress = this.lastAllocatedGotEntryAddress.addNoWrap(1L);
                if (!this.allocatedGotLimits.contains(this.nextAllocatedGotEntryAddress)) {
                    this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
                }
                return addr;
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
        return Address.NO_ADDRESS;
    }

    public Address getGotEntryAddress(long symbolValue) {
        Address addr = null;
        if (this.gotMap != null) {
            addr = this.gotMap.get(symbolValue);
        }
        if (addr == null) {
            addr = this.getNextAllocatedGotEntryAddress();
            this.gotMap.put(symbolValue, addr);
        }
        return addr == Address.NO_ADDRESS ? null : addr;
    }

    private void createGot() {
        if (this.lastAllocatedGotEntryAddress == null) {
            return;
        }
        int size = (int)this.lastAllocatedGotEntryAddress.subtract(this.allocatedGotAddress) + 1;
        try {
            MemoryBlock block = MemoryBlockUtils.createInitializedBlock((Program)this.program, (boolean)false, (String)"%got", (Address)this.allocatedGotAddress, (long)size, (String)"NOTE: This block is artificial and allows ELF Relocations to work correctly", (String)"Elf Loader", (boolean)true, (boolean)false, (boolean)false, (MessageLog)this.loadHelper.getLog());
            BigEndianDataConverter converter = this.program.getMemory().isBigEndian() ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
            for (long symbolValue : this.gotMap.keySet()) {
                Address addr = this.gotMap.get(symbolValue);
                byte[] bytes = this.program.getDefaultPointerSize() == 4 ? converter.getBytes((int)symbolValue) : converter.getBytes(symbolValue);
                block.putBytes(addr, bytes);
                this.loadHelper.createData(addr, (DataType)PointerDataType.dataType);
            }
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public void dispose() {
        this.createGot();
        super.dispose();
    }
}

