/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBRecord;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;

class FileBytesSubMemoryBlock
extends SubMemoryBlock {
    private final FileBytes fileBytes;
    private final long fileBytesOffset;

    FileBytesSubMemoryBlock(MemoryMapDBAdapter adapter, DBRecord record) throws IOException {
        super(adapter, record);
        long fileBytesID = record.getLongValue(4);
        this.fileBytesOffset = record.getLongValue(5);
        this.fileBytes = adapter.getMemoryMap().getLayeredFileBytes(fileBytesID);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        return this.fileBytes.getModifiedByte(this.fileBytesOffset + offsetInSubBlock);
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        return this.fileBytes.getModifiedBytes(this.fileBytesOffset + offsetInSubBlock, b, off, len);
    }

    @Override
    public void putByte(long offsetInMemBlock, byte b) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        this.fileBytes.putByte(this.fileBytesOffset + offsetInSubBlock, b);
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        return this.fileBytes.putBytes(this.fileBytesOffset + offsetInSubBlock, b, off, len);
    }

    @Override
    protected boolean join(SubMemoryBlock block) throws IOException {
        if (!(block instanceof FileBytesSubMemoryBlock)) {
            return false;
        }
        FileBytesSubMemoryBlock other = (FileBytesSubMemoryBlock)block;
        if (this.fileBytes != other.fileBytes) {
            return false;
        }
        if (other.fileBytesOffset != this.fileBytesOffset + this.subBlockLength) {
            return false;
        }
        this.setLength(this.subBlockLength + other.subBlockLength);
        this.adapter.deleteSubBlock(other.record.getKey());
        return true;
    }

    public FileBytes getFileBytes() {
        return this.fileBytes;
    }

    public long getFileBytesOffset() {
        return this.fileBytesOffset;
    }

    @Override
    protected SubMemoryBlock split(long memBlockOffset) throws IOException {
        int offset = (int)(memBlockOffset - this.subBlockOffset);
        long newLength = this.subBlockLength - (long)offset;
        this.subBlockLength = offset;
        this.record.setLongValue(2, this.subBlockLength);
        this.adapter.updateSubBlockRecord(this.record);
        int fileBytesID = this.record.getIntValue(4);
        DBRecord newSubRecord = this.adapter.createSubBlockRecord(0L, 0L, newLength, (byte)4, fileBytesID, this.fileBytesOffset + (long)offset);
        return new FileBytesSubMemoryBlock(this.adapter, newSubRecord);
    }

    @Override
    protected String getDescription() {
        String fileName = this.fileBytes.getFilename();
        String hexString = Long.toHexString(this.fileBytesOffset + this.fileBytes.getFileOffset());
        return "File: " + fileName + ": 0x" + hexString;
    }

    @Override
    protected boolean uses(FileBytes fb) {
        return this.fileBytes.equals(fb);
    }
}

