/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.symbol.PatternlessSymbol;
import ghidra.program.model.address.AddressFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class VarnodeSymbol
extends PatternlessSymbol {
    private VarnodeData fix;

    public VarnodeData getFixedVarnode() {
        return this.fix;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        hand.space = this.fix.space;
        hand.offset_space = null;
        hand.offset_offset = this.fix.offset;
        hand.size = this.fix.size;
    }

    @Override
    public String print(ParserWalker walker) {
        return this.getName();
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) {
        list.add(walker.getParentHandle());
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement el = parser.start(new String[]{"varnode_sym"});
        this.fix = new VarnodeData();
        AddressFactory factory = sleigh.getAddressFactory();
        this.fix.space = factory.getAddressSpace(el.getAttribute("space"));
        this.fix.offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
        this.fix.size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
        parser.end(el);
    }
}

