/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DisplayStringProvider;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortStateEditor;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtils {
    public static <ROW_OBJECT> String getTableCellStringValue(RowObjectTableModel<ROW_OBJECT> model, ROW_OBJECT rowObject, int column) {
        Object value = model.getColumnValueForRow(rowObject, column);
        if (value == null) {
            return null;
        }
        String renderedString = TableUtils.getRenderedColumnValue(model, value, column);
        if (renderedString != null) {
            return renderedString;
        }
        if (value instanceof DisplayStringProvider) {
            return ((DisplayStringProvider)value).toString();
        }
        if (value instanceof JLabel) {
            JLabel label = (JLabel)value;
            String valueString = label.getText();
            return valueString == null ? "" : valueString;
        }
        return value.toString();
    }

    private static <ROW_OBJECT> String getRenderedColumnValue(RowObjectTableModel<ROW_OBJECT> model, Object columnValue, int columnIndex) {
        TableModel unwrappedModel = RowObjectTableModel.unwrap(model);
        if (!(unwrappedModel instanceof DynamicColumnTableModel)) {
            return null;
        }
        DynamicColumnTableModel columnBasedModel = (DynamicColumnTableModel)unwrappedModel;
        GColumnRenderer<Object> renderer = TableUtils.getColumnRenderer(columnBasedModel, columnIndex);
        if (renderer == null) {
            return null;
        }
        GColumnRenderer.ColumnConstraintFilterMode mode = renderer.getColumnConstraintFilterMode();
        if (mode == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY) {
            return null;
        }
        Settings settings = columnBasedModel.getColumnSettings(columnIndex);
        String s = renderer.getFilterString(columnValue, settings);
        return s;
    }

    private static <ROW_OBJECT> GColumnRenderer<Object> getColumnRenderer(DynamicColumnTableModel<ROW_OBJECT> columnBasedModel, int columnIndex) {
        DynamicTableColumn<ROW_OBJECT, ?, ?> column = columnBasedModel.getColumn(columnIndex);
        GColumnRenderer<Object> columnRenderer = column.getColumnRenderer();
        return columnRenderer;
    }

    public static void columnSelected(JTable table, int columnIndex) {
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            editor.flipColumnSortDirection(modelColumnIndex);
        } else {
            editor.clear();
            editor.addSortedColumn(modelColumnIndex);
        }
        sortedModel.setTableSortState(editor.createTableSortState());
        TableUtils.repaintTableHeader(table);
    }

    public static void columnAlternativelySelected(JTable table, int columnIndex) {
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            editor.removeSortedColumn(modelColumnIndex);
        } else {
            editor.addSortedColumn(modelColumnIndex);
        }
        sortedModel.setTableSortState(editor.createTableSortState());
        TableUtils.repaintTableHeader(table);
    }

    private static SortedTableModel getSortedTableModel(JTable table) {
        TableModel model = table.getModel();
        if (!(model instanceof SortedTableModel)) {
            return null;
        }
        return (SortedTableModel)model;
    }

    private static int getColumnModelIndex(JTable table, int columnIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        return columnModel.getColumn(columnIndex).getModelIndex();
    }

    private static void repaintTableHeader(JTable table) {
        JTableHeader tableHeader = table.getTableHeader();
        if (tableHeader != null) {
            tableHeader.paintImmediately(tableHeader.getBounds());
        }
    }
}

