/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.impl.DbgMinimalSymbol;
import agent.dbgeng.model.iface2.DbgModelTargetSymbolContainer;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetModuleImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetSymbolImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SymbolContainer", elements={@TargetElementType(type=DbgModelTargetSymbolImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetSymbolContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetSymbolContainer {
    protected final DbgModelTargetModuleImpl module;

    public DbgModelTargetSymbolContainerImpl(DbgModelTargetModuleImpl module) {
        super(module.getModel(), (TargetObject)module, "Symbols", "SymbolContainer");
        this.module = module;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.module.module.listMinimalSymbols().thenAccept(byName -> {
            List symbols;
            DbgModelTargetSymbolContainerImpl dbgModelTargetSymbolContainerImpl = this;
            synchronized (dbgModelTargetSymbolContainerImpl) {
                symbols = byName.values().stream().map(this::getTargetSymbol).collect(Collectors.toList());
            }
            this.setElements(symbols, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized DbgModelTargetSymbolImpl getTargetSymbol(DbgMinimalSymbol symbol) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(symbol);
        if (modelObject != null) {
            return (DbgModelTargetSymbolImpl)modelObject;
        }
        return new DbgModelTargetSymbolImpl(this, symbol);
    }
}

