/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgCommandErrorEvent;
import agent.dbgeng.manager.evt.DbgRunningEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.util.Msg;

public abstract class AbstractDbgExecToAddressCommand
extends AbstractDbgCommand<Void> {
    private final DebugThreadId id;
    private final String address;

    public AbstractDbgExecToAddressCommand(DbgManagerImpl manager, DebugThreadId id, String address) {
        super(manager);
        this.id = id;
        this.address = address;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return evt instanceof DbgCommandErrorEvent || !pending.findAllOf(DbgRunningEvent.class).isEmpty();
        }
        if (evt instanceof DbgRunningEvent) {
            pending.claim(evt);
            return !pending.findAllOf(AbstractDbgCompletedCommandEvent.class).isEmpty();
        }
        return false;
    }

    protected abstract String generateCommand(String var1);

    @Override
    public void invoke() {
        String cmd = this.generateCommand(this.address);
        String prefix = this.id == null ? "" : "~" + this.id.id() + " ";
        DebugControl control = this.manager.getControl();
        DbgThreadImpl eventThread = this.manager.getEventThread();
        if (eventThread != null && eventThread.getId().equals(this.id)) {
            control.execute(cmd);
        } else if (this.manager.isKernelMode()) {
            Msg.info((Object)this, (Object)"Thread-specific steppign is ignored in kernel-mode");
            control.execute(cmd);
        } else {
            control.execute(prefix + cmd);
        }
    }
}

