/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import generic.Unique;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.plugin.core.debug.stack.SymPcodeExecutor;
import ghidra.app.plugin.core.debug.stack.SymPcodeExecutorState;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.app.plugin.core.debug.stack.UnwindInfo;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GEdgeWeightMetric;
import ghidra.graph.GImplicitDirectedGraph;
import ghidra.graph.algo.DijkstraShortestPathsAlgorithm;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UnwindAnalysis {
    private final Program program;
    private final CodeBlockModel blockModel;

    public UnwindAnalysis(Program program) {
        this.program = program;
        this.blockModel = new BasicBlockModel(program);
    }

    AnalysisForPC start(Address pc, TaskMonitor monitor) throws CancelledException {
        return new AnalysisForPC(pc, monitor);
    }

    public UnwindInfo computeUnwindInfo(Address pc, TaskMonitor monitor) throws CancelledException {
        AnalysisForPC analysis = this.start(pc, monitor);
        return analysis.computeUnwindInfo();
    }

    class AnalysisForPC {
        private final Address pc;
        private final TaskMonitor monitor;
        private final Function function;
        private final BlockGraph graph;
        private final BlockVertex pcBlock;
        private final DijkstraShortestPathsAlgorithm<BlockVertex, BlockEdge> pathFinder;
        private final Set<StackUnwindWarning> warnings = new HashSet<StackUnwindWarning>();

        public AnalysisForPC(Address pc, TaskMonitor monitor) throws CancelledException {
            this.pc = pc;
            this.function = UnwindAnalysis.this.program.getFunctionManager().getFunctionContaining(pc);
            if (this.function == null) {
                throw new UnwindException("No function contains " + pc);
            }
            this.monitor = monitor;
            this.graph = new BlockGraph(monitor);
            this.pathFinder = new DijkstraShortestPathsAlgorithm((GImplicitDirectedGraph)this.graph, GEdgeWeightMetric.unitMetric());
            this.pcBlock = new BlockVertex((CodeBlock)Unique.assertAtMostOne((Object[])UnwindAnalysis.this.blockModel.getCodeBlocksContaining(pc, monitor)));
        }

        public Collection<Deque<BlockEdge>> getEntryPaths() throws CancelledException {
            BlockVertex entryBlock = new BlockVertex((CodeBlock)Unique.assertAtMostOne((Object[])UnwindAnalysis.this.blockModel.getCodeBlocksContaining(this.function.getEntryPoint(), this.monitor)));
            return this.pathFinder.computeOptimalPaths((Object)entryBlock, (Object)this.pcBlock);
        }

        public Collection<BlockVertex> getReturnBlocks() throws CancelledException {
            ArrayList<BlockVertex> returns = new ArrayList<BlockVertex>();
            for (CodeBlock funcBlock : UnwindAnalysis.this.blockModel.getCodeBlocksContaining(this.function.getBody(), this.monitor)) {
                FlowType flowType = funcBlock.getFlowType();
                if (!flowType.isTerminal() || flowType.isCall()) continue;
                returns.add(new BlockVertex(funcBlock));
            }
            return returns;
        }

        public Collection<Deque<BlockEdge>> getExitsPaths() throws CancelledException {
            return this.getReturnBlocks().stream().flatMap(rb -> this.pathFinder.computeOptimalPaths((Object)this.pcBlock, rb).stream()).sorted(Comparator.comparing(d -> d.size())).collect(Collectors.toList());
        }

        public void executeSet(SymPcodeExecutor exec, AddressSetView set) throws CancelledException {
            for (Instruction i : UnwindAnalysis.this.program.getListing().getInstructions(set, true)) {
                this.monitor.checkCancelled();
                exec.execute(PcodeProgram.fromInstruction((Instruction)i, (boolean)true), PcodeUseropLibrary.nil());
            }
        }

        public void executeBlockTo(SymPcodeExecutor exec, CodeBlock block, Address to) throws CancelledException {
            AddressSet set = block.intersectRange(to.getAddressSpace().getMinAddress(), to.previous());
            this.executeSet(exec, (AddressSetView)set);
        }

        public void executeBlock(SymPcodeExecutor exec, CodeBlock block) throws CancelledException {
            this.executeSet(exec, (AddressSetView)block);
        }

        public void executeBlockFrom(SymPcodeExecutor exec, CodeBlock block, Address from) throws CancelledException {
            AddressSet set = block.intersectRange(from, from.getAddressSpace().getMaxAddress());
            this.executeSet(exec, (AddressSetView)set);
        }

        public void executePathTo(SymPcodeExecutor exec, Deque<BlockEdge> to) throws CancelledException {
            for (BlockEdge et : to) {
                this.executeBlock(exec, et.ref.getSourceBlock());
            }
        }

        public void executePathFrom(SymPcodeExecutor exec, Deque<BlockEdge> from) throws CancelledException {
            for (BlockEdge ef : from) {
                this.executeBlock(exec, ef.ref.getDestinationBlock());
            }
        }

        public SymPcodeExecutorState executeToPc(Deque<BlockEdge> to) throws CancelledException {
            SymPcodeExecutorState state = new SymPcodeExecutorState(UnwindAnalysis.this.program);
            SymPcodeExecutor exec = SymPcodeExecutor.forProgram(UnwindAnalysis.this.program, state, PcodeExecutorStatePiece.Reason.EXECUTE_READ, this.warnings, this.monitor);
            this.executePathTo(exec, to);
            this.executeBlockTo(exec, this.pcBlock.block, this.pc);
            return state;
        }

        public SymPcodeExecutorState executeFromPc(SymPcodeExecutorState state, Deque<BlockEdge> from) throws CancelledException {
            SymPcodeExecutor exec = SymPcodeExecutor.forProgram(UnwindAnalysis.this.program, state, PcodeExecutorStatePiece.Reason.EXECUTE_READ, this.warnings, this.monitor);
            this.executeBlockFrom(exec, this.pcBlock.block, this.pc);
            this.executePathFrom(exec, from);
            return state;
        }

        public UnwindInfo computeUnwindInfo() throws CancelledException {
            Collection<Deque<BlockEdge>> entryPaths = this.getEntryPaths();
            if (entryPaths.isEmpty()) {
                throw new UnwindException("Could not find a path from " + this.function + " entry to " + this.pc);
            }
            Collection<Deque<BlockEdge>> exitsPaths = this.getExitsPaths();
            for (Deque<BlockEdge> entryPath : entryPaths) {
                SymPcodeExecutorState entryState = this.executeToPc(entryPath);
                Long depth = entryState.computeStackDepth();
                if (depth == null) continue;
                if (exitsPaths.isEmpty()) {
                    this.warnings.add(new StackUnwindWarning.NoReturnPathStackUnwindWarning(this.pc));
                }
                Map<Register, Address> mapByEntry = entryState.computeMapUsingStack();
                for (Deque<BlockEdge> exitPath : exitsPaths) {
                    SymPcodeExecutorState exitState = this.executeFromPc(entryState.forkRegs(), exitPath);
                    Address addressOfReturn = exitState.computeAddressOfReturn();
                    Long adjust = exitState.computeStackDepth();
                    if (addressOfReturn == null || adjust == null) continue;
                    Map<Register, Address> mapByExit = exitState.computeMapUsingRegisters();
                    mapByExit.entrySet().retainAll(mapByEntry.entrySet());
                    return new UnwindInfo(this.function, depth, adjust, addressOfReturn, mapByExit, new StackUnwindWarningSet(this.warnings));
                }
                this.warnings.add(new StackUnwindWarning.OpaqueReturnPathStackUnwindWarning(this.pc));
                long adjust = SymPcodeExecutor.computeStackChange(this.function, this.warnings);
                return new UnwindInfo(this.function, depth, adjust, null, mapByEntry, new StackUnwindWarningSet(this.warnings));
            }
            throw new UnwindException("Could not analyze any path from " + this.function + " entry to " + this.pc);
        }
    }

    record BlockEdge(CodeBlockReference ref) implements GEdge<BlockVertex>
    {
        public BlockVertex getStart() {
            return new BlockVertex(this.ref.getSourceBlock());
        }

        public BlockVertex getEnd() {
            return new BlockVertex(this.ref.getDestinationBlock());
        }
    }

    record BlockVertex(CodeBlock block) {
    }

    class BlockGraph
    implements GImplicitDirectedGraph<BlockVertex, BlockEdge> {
        final TaskMonitor monitor;

        public BlockGraph(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        List<BlockEdge> toEdgeList(CodeBlockReferenceIterator it) throws CancelledException {
            ArrayList<BlockEdge> result = new ArrayList<BlockEdge>();
            while (it.hasNext()) {
                CodeBlockReference ref = it.next();
                if (ref.getFlowType().isCall()) continue;
                result.add(new BlockEdge(ref));
            }
            return result;
        }

        public Collection<BlockEdge> getInEdges(BlockVertex v) {
            try {
                return this.toEdgeList(UnwindAnalysis.this.blockModel.getSources(v.block, this.monitor));
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Collection<BlockEdge> getOutEdges(BlockVertex v) {
            try {
                return this.toEdgeList(UnwindAnalysis.this.blockModel.getDestinations(v.block, this.monitor));
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
        }

        public GDirectedGraph<BlockVertex, BlockEdge> copy() {
            throw new UnsupportedOperationException();
        }
    }
}

