/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBBreakpointLocation;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.model.iface2.LldbModelTargetBreakpointContainer;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetBreakpointSpec;
import agent.lldb.model.iface2.LldbModelTargetStackFrame;
import agent.lldb.model.impl.LldbModelTargetBreakpointLocationImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.util.datastruct.ListenerMap;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="BreakpointSpec", elements={@TargetElementType(type=LldbModelTargetBreakpointLocationImpl.class)}, attributes={@TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(name="Valid", type=Boolean.class), @TargetAttributeType(name="Enabled", type=Boolean.class), @TargetAttributeType(name="Count", type=Long.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public abstract class LldbModelTargetAbstractXpointSpec
extends LldbModelTargetObjectImpl
implements LldbModelTargetBreakpointSpec {
    protected long number;
    protected boolean enabled;
    protected String expression;
    protected String display;
    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet kinds;
    protected final Map<Integer, LldbModelTargetBreakpointLocation> breaksBySub = new WeakValueHashMap();
    protected final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = new ListenerSet<TargetBreakpointSpec.TargetBreakpointAction>(TargetBreakpointSpec.TargetBreakpointAction.class){

        protected Map<TargetBreakpointSpec.TargetBreakpointAction, ListenerMap.ListenerEntry<? extends TargetBreakpointSpec.TargetBreakpointAction>> createMap() {
            return new LinkedHashMap<TargetBreakpointSpec.TargetBreakpointAction, ListenerMap.ListenerEntry<? extends TargetBreakpointSpec.TargetBreakpointAction>>();
        }
    };

    protected static String keyBreakpoint(Object bpt) {
        return PathUtils.makeKey((String)DebugClient.getId(bpt));
    }

    public LldbModelTargetAbstractXpointSpec(LldbModelTargetBreakpointContainer breakpoints, Object info, String title) {
        super(breakpoints.getModel(), (TargetObject)breakpoints, LldbModelTargetAbstractXpointSpec.keyBreakpoint(info), info, title);
        this.changeAttributes(List.of(), Map.of("_container", breakpoints), "Initialized");
    }

    @Override
    public void setModelObject(Object modelObject) {
        super.setModelObject(modelObject);
        this.getModel().addModelObject(modelObject, (TargetObject)this);
    }

    protected CompletableFuture<Void> init() {
        Object info = this.getModelObject();
        this.updateInfo(info, "Created");
        return AsyncUtils.NIL;
    }

    @Override
    public abstract String getDescription(int var1);

    @Override
    public abstract void updateInfo(Object var1, String var2);

    protected abstract TargetBreakpointSpecContainer.TargetBreakpointKindSet computeKinds(Object var1);

    protected abstract void updateAttributesFromInfo(String var1);

    @Override
    public CompletableFuture<Void> delete() {
        String id = DebugClient.getId(this.getModelObject());
        return this.getModel().gateFuture(this.getManager().deleteBreakpoints(id));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds() {
        return this.kinds;
    }

    @Override
    public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.add((Object)action);
    }

    @Override
    public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.remove((Object)action);
    }

    protected CompletableFuture<Object> getInfo(DebuggerObjectModel.RefreshBehavior refresh) {
        SBTarget session = this.getManager().getCurrentSession();
        String id = DebugClient.getId(this.getModelObject());
        if (!refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            return CompletableFuture.completedFuture(this.getManager().getKnownBreakpoints(session).get(id));
        }
        return this.getManager().listBreakpoints(session).thenApply(__ -> this.getManager().getKnownBreakpoints(session).get(id));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getInfo(refresh).thenAccept(i -> this.updateInfo(i, "Refreshed"));
    }

    @Override
    public CompletableFuture<Void> disable() {
        String id = DebugClient.getId(this.getModelObject());
        return this.getModel().gateFuture(this.getManager().disableBreakpoints(id));
    }

    @Override
    public CompletableFuture<Void> enable() {
        String id = DebugClient.getId(this.getModelObject());
        return this.getModel().gateFuture(this.getManager().enableBreakpoints(id));
    }

    protected void breakpointHit(LldbModelTargetStackFrame frame, LldbModelTargetBreakpointLocation eb) {
        ((TargetBreakpointSpec.TargetBreakpointAction)this.actions.fire).breakpointHit((TargetBreakpointSpec)this, (TargetObject)frame.getParentThread(), (TargetStackFrame)frame, (TargetBreakpointLocation)eb);
    }

    public synchronized LldbModelTargetBreakpointLocation getTargetBreakpointLocation(SBBreakpointLocation loc) {
        return this.breaksBySub.computeIfAbsent(loc.GetID(), i -> new LldbModelTargetBreakpointLocationImpl(this, loc));
    }

    public String getDisplay() {
        return this.display;
    }

    @Override
    public void setEnabled(boolean enabled, String reason) {
        this.enabled = enabled;
    }

    @Override
    public ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions() {
        return new ListenerSet(null);
    }
}

