/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import org.apache.commons.lang3.StringUtils;

public class ClassTypeUtils {
    private static final String INTERNALS = "!internals";

    private ClassTypeUtils() {
    }

    public static CategoryPath getInternalsCategoryPath(CompositeTypeApplier applier) {
        DataType dt = applier.getDataType();
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return ClassTypeUtils.getInternalsCategoryPath(composite);
        }
        return null;
    }

    public static CategoryPath getInternalsCategoryPath(Composite composite) {
        DataTypePath dtp = composite.getDataTypePath();
        return dtp.getCategoryPath().extend(new String[]{dtp.getDataTypeName(), INTERNALS});
    }

    public static DataTypePath getInternalsDataTypePath(CompositeTypeApplier applier, String name) {
        CategoryPath cp = ClassTypeUtils.getInternalsCategoryPath(applier);
        if (cp == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{name})) {
            return null;
        }
        return new DataTypePath(cp, name);
    }

    public static DataTypePath getInternalsDataTypePath(Composite composite, String name) {
        CategoryPath cp = ClassTypeUtils.getInternalsCategoryPath(composite);
        if (cp == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{name})) {
            return null;
        }
        return new DataTypePath(cp, name);
    }
}

