/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDSignedEncodedNumber;
import mdemangler.MDString;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.naming.MDBasicName;
import mdemangler.naming.MDFragmentName;
import mdemangler.object.MDObjectCPP;

public class MDSpecialName
extends MDParsableItem {
    private String name;
    private boolean isConstructor;
    private boolean isDestructor;
    private boolean isTypeCast;
    private boolean isQualified;
    private int rttiNumber = -1;
    private MDString mstring;
    private String castTypeString;

    public MDSpecialName(MDMang dmang, int startIndexOffset) {
        super(dmang, startIndexOffset);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCastTypeString(String castTypeString) {
        this.castTypeString = castTypeString;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDestructor() {
        return this.isDestructor;
    }

    public boolean isTypeCast() {
        return this.isTypeCast;
    }

    public boolean isQualified() {
        return this.isQualified;
    }

    public int getRTTINumber() {
        return this.rttiNumber;
    }

    public boolean isString() {
        return this.mstring != null;
    }

    public MDString getMDString() {
        return this.mstring;
    }

    public byte[] getBytes() {
        return this.mstring.getBytes();
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insertString(builder, this.name);
        if (this.isTypeCast && this.castTypeString != null) {
            this.dmang.appendString(builder, " ");
            this.dmang.appendString(builder, this.castTypeString);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.isProcessingModeActive(MDMang.ProcessingMode.LLVM)) {
            this.parseLLVM();
        } else {
            this.parseDefaultStandard();
        }
    }

    protected void parseDefaultStandard() throws MDException {
        this.isQualified = true;
        block0 : switch (this.dmang.getAndIncrement()) {
            case '0': {
                this.dmang.parseInfoPush(1, "constructor");
                this.isConstructor = true;
                this.name = "";
                this.dmang.parseInfoPop();
                break;
            }
            case '1': {
                this.dmang.parseInfoPush(1, "destructor");
                this.isDestructor = true;
                this.name = "";
                this.dmang.parseInfoPop();
                break;
            }
            case '2': {
                this.dmang.parseInfoPush(1, "operator new");
                this.name = "operator new";
                this.dmang.parseInfoPop();
                break;
            }
            case '3': {
                this.dmang.parseInfoPush(1, "operator delete");
                this.name = "operator delete";
                this.dmang.parseInfoPop();
                break;
            }
            case '4': {
                this.dmang.parseInfoPush(1, "operator=");
                this.name = "operator=";
                this.dmang.parseInfoPop();
                break;
            }
            case '5': {
                this.dmang.parseInfoPush(1, "operator>>");
                this.name = "operator>>";
                this.dmang.parseInfoPop();
                break;
            }
            case '6': {
                this.dmang.parseInfoPush(1, "operator<<");
                this.name = "operator<<";
                this.dmang.parseInfoPop();
                break;
            }
            case '7': {
                this.dmang.parseInfoPush(1, "operator!");
                this.name = "operator!";
                this.dmang.parseInfoPop();
                break;
            }
            case '8': {
                this.dmang.parseInfoPush(1, "operator==");
                this.name = "operator==";
                this.dmang.parseInfoPop();
                break;
            }
            case '9': {
                this.dmang.parseInfoPush(1, "operator!=");
                this.name = "operator!=";
                this.dmang.parseInfoPop();
                break;
            }
            case 'A': {
                this.dmang.parseInfoPush(1, "operator[]");
                this.name = "operator[]";
                this.dmang.parseInfoPop();
                break;
            }
            case 'B': {
                this.dmang.parseInfoPush(1, "operator [type cast]");
                this.name = "operator";
                this.isTypeCast = true;
                this.dmang.parseInfoPop();
                break;
            }
            case 'C': {
                this.dmang.parseInfoPush(1, "operator->");
                this.name = "operator->";
                this.dmang.parseInfoPop();
                break;
            }
            case 'D': {
                this.dmang.parseInfoPush(1, "operator*");
                this.name = "operator*";
                this.dmang.parseInfoPop();
                break;
            }
            case 'E': {
                this.dmang.parseInfoPush(1, "operator++");
                this.name = "operator++";
                this.dmang.parseInfoPop();
                break;
            }
            case 'F': {
                this.dmang.parseInfoPush(1, "operator--");
                this.name = "operator--";
                this.dmang.parseInfoPop();
                break;
            }
            case 'G': {
                this.dmang.parseInfoPush(1, "operator-");
                this.name = "operator-";
                this.dmang.parseInfoPop();
                break;
            }
            case 'H': {
                this.dmang.parseInfoPush(1, "operator+");
                this.name = "operator+";
                this.dmang.parseInfoPop();
                break;
            }
            case 'I': {
                this.dmang.parseInfoPush(1, "operator& (address-of)");
                this.name = "operator&";
                this.dmang.parseInfoPop();
                break;
            }
            case 'J': {
                this.dmang.parseInfoPush(1, "operator->*");
                this.name = "operator->*";
                this.dmang.parseInfoPop();
                break;
            }
            case 'K': {
                this.dmang.parseInfoPush(1, "operator/");
                this.name = "operator/";
                this.dmang.parseInfoPop();
                break;
            }
            case 'L': {
                this.dmang.parseInfoPush(1, "operator%");
                this.name = "operator%";
                this.dmang.parseInfoPop();
                break;
            }
            case 'M': {
                this.dmang.parseInfoPush(1, "operator<");
                this.name = "operator<";
                this.dmang.parseInfoPop();
                break;
            }
            case 'N': {
                this.dmang.parseInfoPush(1, "operator<=");
                this.name = "operator<=";
                this.dmang.parseInfoPop();
                break;
            }
            case 'O': {
                this.dmang.parseInfoPush(1, "operator>");
                this.name = "operator>";
                this.dmang.parseInfoPop();
                break;
            }
            case 'P': {
                this.dmang.parseInfoPush(1, "operator>=");
                this.name = "operator>=";
                this.dmang.parseInfoPop();
                break;
            }
            case 'Q': {
                this.dmang.parseInfoPush(1, "operator,");
                this.name = "operator,";
                this.dmang.parseInfoPop();
                break;
            }
            case 'R': {
                this.dmang.parseInfoPush(1, "operator()");
                this.name = "operator()";
                this.dmang.parseInfoPop();
                break;
            }
            case 'S': {
                this.dmang.parseInfoPush(1, "operator~");
                this.name = "operator~";
                this.dmang.parseInfoPop();
                break;
            }
            case 'T': {
                this.dmang.parseInfoPush(1, "operator^");
                this.name = "operator^";
                this.dmang.parseInfoPop();
                break;
            }
            case 'U': {
                this.dmang.parseInfoPush(1, "operator|");
                this.name = "operator|";
                this.dmang.parseInfoPop();
                break;
            }
            case 'V': {
                this.dmang.parseInfoPush(1, "operator&&");
                this.name = "operator&&";
                this.dmang.parseInfoPop();
                break;
            }
            case 'W': {
                this.dmang.parseInfoPush(1, "operator||");
                this.name = "operator||";
                this.dmang.parseInfoPop();
                break;
            }
            case 'X': {
                this.dmang.parseInfoPush(1, "operator*=");
                this.name = "operator*=";
                this.dmang.parseInfoPop();
                break;
            }
            case 'Y': {
                this.dmang.parseInfoPush(1, "operator+=");
                this.name = "operator+=";
                this.dmang.parseInfoPop();
                break;
            }
            case 'Z': {
                this.dmang.parseInfoPush(1, "operator-=");
                this.name = "operator-=";
                this.dmang.parseInfoPop();
                break;
            }
            case '_': {
                switch (this.dmang.getAndIncrement()) {
                    case '0': {
                        this.dmang.parseInfoPush(2, "operator/=");
                        this.name = "operator/=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '1': {
                        this.dmang.parseInfoPush(2, "operator%=");
                        this.name = "operator%=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '2': {
                        this.dmang.parseInfoPush(2, "operator>>=");
                        this.name = "operator>>=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '3': {
                        this.dmang.parseInfoPush(2, "operator<<=");
                        this.name = "operator<<=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '4': {
                        this.dmang.parseInfoPush(2, "operator&=");
                        this.name = "operator&=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '5': {
                        this.dmang.parseInfoPush(2, "operator|=");
                        this.name = "operator|=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '6': {
                        this.dmang.parseInfoPush(2, "operator^=");
                        this.name = "operator^=";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '7': {
                        this.dmang.parseInfoPush(2, "vftable");
                        this.name = "`vftable'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '8': {
                        this.dmang.parseInfoPush(2, "vbtable");
                        this.name = "`vbtable'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '9': {
                        this.dmang.parseInfoPush(2, "vcall");
                        this.name = "`vcall'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'A': {
                        this.dmang.parseInfoPush(2, "typeof");
                        this.name = "`typeof'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'B': {
                        this.dmang.parseInfoPush(2, "local static guard");
                        this.name = "`local static guard'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'C': {
                        this.dmang.parseInfoPush(2, "string");
                        this.mstring = new MDString(this.dmang);
                        this.mstring.parse();
                        this.name = this.mstring.toString();
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'D': {
                        this.dmang.parseInfoPush(2, "vbase destructor");
                        this.name = "`vbase destructor'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'E': {
                        this.dmang.parseInfoPush(2, "vector deleting destructor");
                        this.name = "`vector deleting destructor'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'F': {
                        this.dmang.parseInfoPush(2, "default constructor closure");
                        this.name = "`default constructor closure'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'G': {
                        this.dmang.parseInfoPush(2, "scalar deleting destructor");
                        this.name = "`scalar deleting destructor'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'H': {
                        this.dmang.parseInfoPush(2, "vector constructor iterator");
                        this.name = "`vector constructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'I': {
                        this.dmang.parseInfoPush(2, "vector destructor iterator");
                        this.name = "`vector destructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'J': {
                        this.dmang.parseInfoPush(2, "vector vbase constructor iterator");
                        this.name = "`vector vbase constructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'K': {
                        this.dmang.parseInfoPush(2, "virtual displacement map");
                        this.name = "`virtual displacement map'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'L': {
                        this.dmang.parseInfoPush(2, "eh vector constructor iterator");
                        this.name = "`eh vector constructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'M': {
                        this.dmang.parseInfoPush(2, "eh vector destructor iterator");
                        this.name = "`eh vector destructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'N': {
                        this.dmang.parseInfoPush(2, "eh vector vbase constructor iterator");
                        this.name = "`eh vector vbase constructor iterator'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'O': {
                        this.dmang.parseInfoPush(2, "copy constructor closure");
                        this.name = "`copy constructor closure'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'P': {
                        this.dmang.parseInfoPush(2, "udt returning");
                        MDSpecialName nestedSpecialName = new MDSpecialName(this.dmang, 0);
                        nestedSpecialName.parse();
                        StringBuilder nestedBuilder = new StringBuilder();
                        nestedSpecialName.insert(nestedBuilder);
                        this.dmang.insertString(nestedBuilder, "`udt returning'");
                        this.name = nestedBuilder.toString();
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'Q': {
                        this.dmang.parseInfoPush(2, "EH");
                        this.name = "";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'R': {
                        this.isQualified = false;
                        switch (this.dmang.getAndIncrement()) {
                            case '0': {
                                this.rttiNumber = 0;
                                this.dmang.parseInfoPush(3, "RTTI Type Descriptor");
                                MDDataType tmpMDType = MDDataTypeParser.parseDataType(this.dmang, false);
                                tmpMDType.parse();
                                StringBuilder RTTIBuilder = new StringBuilder();
                                ((MDType)tmpMDType).insert(RTTIBuilder);
                                this.dmang.appendString(RTTIBuilder, " `RTTI Type Descriptor'");
                                this.name = RTTIBuilder.toString();
                                this.dmang.parseInfoPop();
                                break;
                            }
                            case '1': {
                                this.rttiNumber = 1;
                                this.dmang.parseInfoPush(3, "RTTI Base Class Descriptor at [...]");
                                MDSignedEncodedNumber a = new MDSignedEncodedNumber(this.dmang);
                                a.parse();
                                MDSignedEncodedNumber b = new MDSignedEncodedNumber(this.dmang);
                                b.parse();
                                MDSignedEncodedNumber c = new MDSignedEncodedNumber(this.dmang);
                                c.parse();
                                MDEncodedNumber d = new MDEncodedNumber(this.dmang);
                                d.parse();
                                this.name = "`RTTI Base Class Descriptor at (" + a + "," + b + "," + c + "," + d + ")'";
                                this.dmang.parseInfoPop();
                                break;
                            }
                            case '2': {
                                this.rttiNumber = 2;
                                this.dmang.parseInfoPush(3, "RTTI Base Class Array");
                                this.name = "`RTTI Base Class Array'";
                                this.dmang.parseInfoPop();
                                break;
                            }
                            case '3': {
                                this.rttiNumber = 3;
                                this.dmang.parseInfoPush(3, "RTTI Class Hierarchy Descriptor");
                                this.name = "`RTTI Class Hierarchy Descriptor'";
                                this.dmang.parseInfoPop();
                                break;
                            }
                            case '4': {
                                this.rttiNumber = 4;
                                this.dmang.parseInfoPush(3, "RTTI Complete Object Locator");
                                this.name = "`RTTI Complete Object Locator'";
                                this.dmang.parseInfoPop();
                            }
                        }
                        break block0;
                    }
                    case 'S': {
                        this.dmang.parseInfoPush(2, "local vftable");
                        this.name = "`local vftable'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'T': {
                        this.dmang.parseInfoPush(2, "local vftable constructor closure");
                        this.name = "`local vftable constructor closure'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'U': {
                        this.dmang.parseInfoPush(2, "operator new[]");
                        this.name = "operator new[]";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'V': {
                        this.dmang.parseInfoPush(2, "operator delete[]");
                        this.name = "operator delete[]";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'W': {
                        this.dmang.parseInfoPush(2, "omni callsig");
                        this.name = "`omni callsig'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'X': {
                        this.dmang.parseInfoPush(2, "placement delete closure");
                        this.name = "`placement delete closure'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case 'Y': {
                        this.dmang.parseInfoPush(2, "placement delete[] closure");
                        this.name = "`placement delete[] closure'";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                    case '_': {
                        switch (this.dmang.getAndIncrement()) {
                            case 'A': {
                                this.dmang.parseInfoPush(3, "managed vector constructor iterator");
                                this.name = "`managed vector constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'B': {
                                this.dmang.parseInfoPush(3, "managed vector destructor iterator");
                                this.name = "`managed vector destructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'C': {
                                this.dmang.parseInfoPush(3, "eh vector copy constructor iterator");
                                this.name = "`eh vector copy constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'D': {
                                this.dmang.parseInfoPush(3, "eh vector vbase copy constructor iterator");
                                this.name = "`eh vector vbase copy constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'E': {
                                this.dmang.parseInfoPush(3, "dynamic initializer for [Object]");
                                StringBuilder builder = new StringBuilder();
                                if (this.dmang.peek() == '?') {
                                    MDObjectCPP objectCPP = new MDObjectCPP(this.dmang);
                                    objectCPP.parse();
                                    objectCPP = this.dmang.getEmbeddedObject(objectCPP);
                                    objectCPP.insert(builder);
                                    this.dmang.parseEmbeddedObjectSuffix();
                                } else {
                                    MDBasicName basicName = new MDBasicName(this.dmang);
                                    basicName.parse();
                                    basicName.insert(builder);
                                }
                                this.dmang.appendString(builder, "''");
                                this.dmang.insertString(builder, "`dynamic initializer for '");
                                this.name = builder.toString();
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'F': {
                                this.dmang.parseInfoPush(3, "dynamic atexit destructor operator");
                                StringBuilder builder = new StringBuilder();
                                if (this.dmang.peek() == '?') {
                                    MDObjectCPP objectCPP = new MDObjectCPP(this.dmang);
                                    objectCPP.parse();
                                    objectCPP = this.dmang.getEmbeddedObject(objectCPP);
                                    objectCPP.insert(builder);
                                    this.dmang.parseEmbeddedObjectSuffix();
                                } else {
                                    MDBasicName basicName = new MDBasicName(this.dmang);
                                    basicName.parse();
                                    basicName.insert(builder);
                                }
                                this.dmang.appendString(builder, "''");
                                this.dmang.insertString(builder, "`dynamic atexit destructor for '");
                                this.name = builder.toString();
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'G': {
                                this.dmang.parseInfoPush(3, "vector copy constructor");
                                this.name = "`vector copy constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'H': {
                                this.dmang.parseInfoPush(3, "vector vbase copy constructor");
                                this.name = "`vector vbase copy constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'I': {
                                this.dmang.parseInfoPush(3, "managed vector copy constructor");
                                this.name = "`managed vector copy constructor iterator'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'J': {
                                this.dmang.parseInfoPush(3, "local static thread guard");
                                this.name = "`local static thread guard'";
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                            case 'K': {
                                this.dmang.parseInfoPush(3, "udl");
                                MDFragmentName fragment = new MDFragmentName(this.dmang);
                                fragment.parse();
                                StringBuilder fragBuilder = new StringBuilder();
                                fragment.insert(fragBuilder);
                                this.dmang.insertString(fragBuilder, "operator \"\" ");
                                this.name = fragBuilder.toString();
                                this.dmang.parseInfoPop();
                                break block0;
                            }
                        }
                        this.dmang.parseInfoPush(3, "UNKNOWN OPERATOR TYPE");
                        this.name = "ERROR UNKNOWN OPERATOR TYPE";
                        this.dmang.parseInfoPop();
                        break block0;
                    }
                }
                this.dmang.parseInfoPush(2, "UNKNOWN OPERATOR TYPE");
                this.name = "ERROR UNKNOWN OPERATOR TYPE";
                this.dmang.parseInfoPop();
                break;
            }
            default: {
                this.dmang.parseInfoPush(1, "UNKNOWN OPERATOR TYPE");
                this.name = "ERROR UNKNOWN OPERATOR TYPE";
                this.dmang.parseInfoPop();
            }
        }
    }

    public void parseLLVM() throws MDException {
        if (this.dmang.positionStartsWith("?$TSS")) {
            this.dmang.parseInfoPush(0, "thread safe static guard");
            this.dmang.increment("?$TSS".length());
            String guardNumberString = this.getNumberString();
            this.dmang.parseInfoPop();
            this.name = "`thread safe static guard{" + guardNumberString + "}'";
        } else if (this.dmang.positionStartsWith("?$S1@")) {
            this.dmang.parseInfoPush(0, "nonvisible static guard");
            this.dmang.increment("?$S1@".length());
            this.name = "`nonvisible static guard{1}'";
            this.dmang.parseInfoPop();
        } else if (this.dmang.positionStartsWith("?$RT")) {
            this.dmang.parseInfoPush(0, "reference temporary");
            this.dmang.increment("?$RT".length());
            String manglingNumberString = this.getNumberString();
            this.dmang.parseInfoPop();
            this.name = "`reference temporary{" + manglingNumberString + "}'";
        } else {
            throw new MDException("Could not match NonStandard Special Name");
        }
    }

    private String getNumberString() throws MDException {
        char ch;
        StringBuilder builder = new StringBuilder();
        this.dmang.parseInfoPush(0, "Number");
        while ((ch = this.dmang.peek()) != '@') {
            if (!Character.isDigit(ch)) {
                throw new MDException("Illegal character in Number: " + ch);
            }
            builder.append(ch);
            this.dmang.next();
        }
        this.dmang.next();
        this.dmang.parseInfoPop();
        return builder.toString();
    }
}

