/*
 * Decompiled with CFR 0.152.
 */
package generic.timer;

import generic.timer.GhidraSwingTimer;
import generic.timer.GhidraSwinglessTimer;
import generic.timer.GhidraTimer;
import generic.timer.TimerCallback;
import ghidra.util.SystemUtilities;

public class GhidraTimerFactory {
    public static GhidraTimer getGhidraTimer(int initialDelay, int delay, TimerCallback callback) {
        if (SystemUtilities.isInHeadlessMode()) {
            return new GhidraSwinglessTimer(initialDelay, delay, callback);
        }
        return new GhidraSwingTimer(initialDelay, delay, callback);
    }

    public static void main(String[] args) throws InterruptedException {
        System.setProperty("SystemUtilities.isHeadless", "true");
        final GhidraTimer t = GhidraTimerFactory.getGhidraTimer(500, 500, null);
        t.setDelay(500);
        TimerCallback callback1 = new TimerCallback(){
            int i = 0;

            @Override
            public void timerFired() {
                System.out.println("A: " + this.i);
                if (++this.i == 20) {
                    t.stop();
                }
            }
        };
        t.setTimerCallback(callback1);
        t.start();
        final GhidraTimer t2 = GhidraTimerFactory.getGhidraTimer(250, 1000, null);
        TimerCallback callback2 = new TimerCallback(){
            int i = 0;

            @Override
            public void timerFired() {
                System.out.println("B: " + this.i);
                if (++this.i == 100) {
                    t2.stop();
                }
            }
        };
        t2.setInitialDelay(250);
        t2.setTimerCallback(callback2);
        t2.start();
        Thread.sleep(20000L);
    }
}

