/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBFrame;
import SWIG.SBStream;
import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.manager.cmd.LldbRunToAddressCommand;
import agent.lldb.manager.cmd.LldbStepCommand;
import agent.lldb.model.iface1.LldbModelTargetFocusScope;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.iface2.LldbModelTargetThreadContainer;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackImpl;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Thread", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Stack", type=LldbModelTargetStackImpl.class, required=true, fixed=true), @TargetAttributeType(name="_arch", type=String.class), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetThreadImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetThread {
    public static final TargetSteppable.TargetStepKindSet SUPPORTED_KINDS = TargetSteppable.TargetStepKindSet.of((TargetSteppable.TargetStepKind[])new TargetSteppable.TargetStepKind[]{TargetSteppable.TargetStepKind.FINISH, TargetSteppable.TargetStepKind.LINE, TargetSteppable.TargetStepKind.OVER, TargetSteppable.TargetStepKind.OVER_LINE, TargetSteppable.TargetStepKind.RETURN, TargetSteppable.TargetStepKind.UNTIL, TargetSteppable.TargetStepKind.EXTENDED});
    protected final LldbModelTargetStackImpl stack;
    private LldbModelTargetProcess process;
    private Integer base = 16;

    protected static String indexThread(Integer id) {
        return PathUtils.makeIndex((int)id);
    }

    protected static String indexThread(SBThread thread) {
        return DebugClient.getId(thread);
    }

    protected static String keyThread(SBThread thread) {
        return PathUtils.makeKey((String)LldbModelTargetThreadImpl.indexThread(thread));
    }

    public LldbModelTargetThreadImpl(LldbModelTargetThreadContainer threads, LldbModelTargetProcess process, SBThread thread) {
        super(threads.getModel(), (TargetObject)threads, LldbModelTargetThreadImpl.keyThread(thread), thread, "Thread");
        this.process = process;
        this.stack = new LldbModelTargetStackImpl(this, process);
        this.changeAttributes(List.of(), List.of(), TargetMethod.AnnotatedTargetMethod.collectExports((MethodHandles.Lookup)MethodHandles.lookup(), (AbstractDebuggerObjectModel)threads.getModel(), (TargetObject)this), "Methods");
        this.accessible = false;
        this.changeAttributes(List.of(), List.of(this.stack), Map.of("_accessible", false, "_display", this.getDisplay(), "_state", TargetExecutionStateful.TargetExecutionState.ALIVE, "_tid", thread.GetThreadID().intValue(), "_supported_step_kinds", SUPPORTED_KINDS), "Initialized");
        this.getManager().addStateListener(this);
        this.getManager().addEventsListener(this);
    }

    @Override
    public void setModelObject(Object modelObject) {
        super.setModelObject(modelObject);
        this.getModel().addModelObject(modelObject, (TargetObject)this);
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBThread thread = (SBThread)this.getModelObject();
        thread.GetDescription(stream);
        return stream.GetData();
    }

    public String getDisplay() {
        Object tidstr = DebugClient.getId(this.getThread());
        tidstr = this.base == 16 ? "0x" + (String)tidstr : Long.toString(Long.parseLong((String)tidstr, 16));
        return "[" + (String)tidstr + "]";
    }

    @Override
    public void threadSelected(SBThread eventThread, SBFrame frame, LldbCause cause) {
        if (eventThread.GetThreadID().equals(this.getThread().GetThreadID())) {
            ((LldbModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = DebugClient.convertState(state);
        this.changeAttributes(List.of(), List.of(), Map.of("_state", targetState), reason.desc());
        this.stack.threadStateChangedSpecific(state, reason);
    }

    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        return this.getModel().gateFuture(this.getManager().execute(new LldbStepCommand(this.getManager(), this.getThread(), kind, null)));
    }

    public CompletableFuture<Void> step(Map<String, ?> args) {
        return this.getModel().gateFuture(this.getManager().execute(new LldbStepCommand(this.getManager(), this.getThread(), null, args)));
    }

    @TargetMethod.Export(value="Run to Address")
    public CompletableFuture<Void> runToAddress(@TargetMethod.Param(description="The target address", display="Address", name="address") Address address) {
        return this.getModel().gateFuture(this.getManager().execute(new LldbRunToAddressCommand(this.getManager(), this.getThread(), address.getOffsetAsBigInteger())));
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.getModel().gateFuture(this.getManager().setActiveThread(this.getThread()));
    }

    @Override
    public LldbModelTargetStackImpl getStack() {
        return this.stack;
    }

    @Override
    public SBThread getThread() {
        return (SBThread)this.getModelObject();
    }

    public LldbModelTargetProcess getProcess() {
        return this.process;
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    @Override
    public String getExecutingProcessorType() {
        return null;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }

    @Override
    public void stateChanged(StateType state, LldbCause cause) {
        LldbModelTargetThreadContainer container = (LldbModelTargetThreadContainer)this.getParent();
        LldbModelTargetProcess process = (LldbModelTargetProcess)container.getParent();
        LldbReason.Reasons unknown = LldbReason.Reasons.UNKNOWN;
        process.threadStateChanged(this.getThread(), state, cause, unknown);
        container.threadStateChanged(this.getThread(), state, cause, unknown);
        this.threadStateChangedSpecific(state, unknown);
    }
}

