/*
 * Decompiled with CFR 0.152.
 */
package help;

import generic.jar.ResourceFile;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.framework.Application;
import help.HelpRightArrowIcon;
import help.ImageLocation;
import help.validator.location.DirectoryHelpModuleLocation;
import help.validator.location.HelpModuleLocation;
import help.validator.location.JarHelpModuleLocation;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import resources.IconProvider;
import resources.Icons;

public class HelpBuildUtils {
    private static final String HELP_TOPICS_ROOT_PATH = "help/topics";
    private static final Pattern HREF_PATTERN = Pattern.compile("\"(\\.\\./[^/.]+/[^/.]+\\.html*(#[^\"]+)*)\"", 2);
    private static final Pattern STYLE_CLASS_PATTERN = Pattern.compile("class\\s*=\\s*\"(\\w+)\"", 2);
    public static boolean debug = true;
    private static final String HELP_SHARED_ARROW = "help/shared/arrow.gif";
    private static final Icon SHARED_ARROW_ICON = new HelpRightArrowIcon((Color)GThemeDefaults.Colors.FOREGROUND);
    private static final IconProvider SHARED_ARROW_ICON_PROVIDER = new IconProvider(SHARED_ARROW_ICON, null);
    private static final Path DEFAULT_FS_ROOT;

    private HelpBuildUtils() {
    }

    public static Path getSharedHelpDirectory() {
        ResourceFile appRootDir = Application.getApplicationRootDirectory();
        ResourceFile sharedHelpDir = new ResourceFile(appRootDir, "Framework/Help/src/main/resources/help/shared/");
        return Paths.get(sharedHelpDir.getAbsolutePath(), new String[0]);
    }

    public static HelpModuleLocation toLocation(File file) {
        if (file.isDirectory()) {
            return new DirectoryHelpModuleLocation(file);
        }
        if (file.isFile()) {
            return new JarHelpModuleLocation(file);
        }
        throw new IllegalArgumentException("Don't know how to create a help module location for file: " + file);
    }

    public static Path getRoot(Collection<Path> roots, Path file) {
        for (Path dir : roots) {
            if (!file.startsWith(dir)) continue;
            return dir;
        }
        return null;
    }

    public static Path getHelpTopicDir(Path file) {
        Path helpTopics = file.getFileSystem().getPath("help", "topics");
        int last = file.getNameCount();
        for (int i = 0; i < last; ++i) {
            Path sp = file.subpath(i, last);
            if (!sp.startsWith(helpTopics)) continue;
            return file.subpath(0, i + 3);
        }
        return null;
    }

    public static Path getFile(Path srcFile, String relativePath) {
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        if (relativePath.startsWith("/")) {
            return null;
        }
        if (relativePath.contains(":")) {
            return null;
        }
        if (relativePath.contains("\\")) {
            return null;
        }
        if (relativePath.startsWith("help/shared/")) {
            String updatedRelativePath = relativePath.substring("help/shared/".length());
            Path sharedDir = HelpBuildUtils.getSharedHelpDirectory();
            return sharedDir.resolve(updatedRelativePath);
        }
        Path parent = srcFile.getParent();
        return parent.resolve(relativePath);
    }

    public static Path relativizeWithHelpTopics(Path p) {
        if (p == null) {
            return null;
        }
        Path helpTopics = p.getFileSystem().getPath("help", "topics");
        return HelpBuildUtils.relativize(helpTopics, p);
    }

    public static Path relativize(Path parent, Path child) {
        if (child == null) {
            return null;
        }
        int last = child.getNameCount();
        for (int i = 0; i < last; ++i) {
            Path sp = child.subpath(i, last);
            if (!sp.startsWith(parent)) continue;
            return sp;
        }
        return null;
    }

    public static void cleanupHelpFileLinks(Path helpFile) throws IOException {
        String styleSheetClassFixupContents;
        String fixupHelpProperty = System.getProperty("fix.help.links");
        boolean cleanupHelpFiles = Boolean.parseBoolean(fixupHelpProperty);
        if (!cleanupHelpFiles) {
            return;
        }
        String fileContents = HelpBuildUtils.readFile(helpFile);
        String newContents = null;
        String linkFixupContents = HelpBuildUtils.fixLinksInFile(helpFile, fileContents);
        if (linkFixupContents != null) {
            fileContents = newContents = linkFixupContents;
        }
        if ((styleSheetClassFixupContents = HelpBuildUtils.fixStyleSheetClassNames(helpFile, fileContents)) != null) {
            newContents = styleSheetClassFixupContents;
        }
        if (newContents == null) {
            return;
        }
        HelpBuildUtils.writeFileContents(helpFile, newContents);
    }

    private static String fixStyleSheetClassNames(Path helpFile, String fileContents) {
        int currentPosition = 0;
        StringBuffer newContents = new StringBuffer();
        Matcher matcher = STYLE_CLASS_PATTERN.matcher(fileContents);
        boolean hasMatches = matcher.find();
        if (!hasMatches) {
            return null;
        }
        while (hasMatches) {
            int matchStart = matcher.start();
            String fullMatch = matcher.group(0);
            String beforeMatchString = fileContents.substring(currentPosition, matchStart);
            newContents.append(beforeMatchString);
            currentPosition = matchStart + fullMatch.length();
            String classNameText = matcher.group(1);
            if (!HelpBuildUtils.containsUpperCase(classNameText)) {
                newContents.append(fullMatch);
            } else {
                HelpBuildUtils.debug("Found stylesheet class name text: " + classNameText + " in file: " + helpFile.getFileName());
                String updatedText = "class=\"" + classNameText.toLowerCase() + "\"";
                HelpBuildUtils.debug("\tnew link tag: " + updatedText);
                newContents.append(updatedText);
            }
            hasMatches = matcher.find();
        }
        if (currentPosition < fileContents.length()) {
            newContents.append(fileContents.substring(currentPosition));
        }
        return newContents.toString();
    }

    private static String fixLinksInFile(Path helpFile, String fileContents) {
        String updatedContents = HelpBuildUtils.fixRelativeLink(HREF_PATTERN, helpFile, fileContents);
        return updatedContents;
    }

    private static String fixRelativeLink(Pattern pattern, Path helpFile, String fileContents) {
        int currentPosition = 0;
        StringBuffer newContents = new StringBuffer();
        Matcher matcher = pattern.matcher(fileContents);
        boolean hasMatches = matcher.find();
        if (!hasMatches) {
            return null;
        }
        while (hasMatches) {
            int matchStart = matcher.start();
            String fullMatch = matcher.group(0);
            String beforeMatchString = fileContents.substring(currentPosition, matchStart);
            newContents.append(beforeMatchString);
            currentPosition = matchStart + fullMatch.length();
            String HREFText = matcher.group(1);
            HelpBuildUtils.debug("Found HREF text: " + HREFText + " in file: " + helpFile.getFileName());
            String updatedHREFText = HelpBuildUtils.resolveLink(HREFText);
            HelpBuildUtils.debug("\tnew link text: " + updatedHREFText);
            newContents.append('\"').append(updatedHREFText).append('\"');
            hasMatches = matcher.find();
        }
        if (currentPosition < fileContents.length()) {
            newContents.append(fileContents.substring(currentPosition));
        }
        return newContents.toString();
    }

    private static String resolveLink(String linkTextReference) {
        String helpTopicsPrefix = HELP_TOPICS_ROOT_PATH;
        if (linkTextReference.startsWith(helpTopicsPrefix)) {
            return linkTextReference;
        }
        String[] referenceParts = linkTextReference.split("/");
        if (referenceParts.length != 3) {
            return linkTextReference;
        }
        if (!referenceParts[0].equals("..")) {
            return linkTextReference;
        }
        return "help/topics/" + referenceParts[1] + "/" + referenceParts[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(Path helpFile) throws IOException {
        InputStreamReader isr = new InputStreamReader(Files.newInputStream(helpFile, new OpenOption[0]));
        try (BufferedReader reader = new BufferedReader(isr);){
            StringBuffer buffy = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffy.append(line).append('\n');
            }
            String string = buffy.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileContents(Path helpFile, String updatedContents) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(helpFile, new OpenOption[0]));
        try (BufferedWriter writer = new BufferedWriter(osw);){
            writer.write(updatedContents);
        }
    }

    public static void debug(String text) {
        if (debug) {
            System.err.println("[" + HelpBuildUtils.class.getSimpleName() + "] " + text);
        }
    }

    private static boolean containsUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!Character.isUpperCase(charAt)) continue;
            return true;
        }
        return false;
    }

    private static Path toFSGivenRoot(Path root, Path path) {
        if (path.getNameCount() == 0) {
            if (path.isAbsolute()) {
                return root;
            }
            return root.relativize(root);
        }
        String first = path.getName(0).toString();
        String[] names = new String[path.getNameCount() - 1];
        for (int i = 0; i < names.length; ++i) {
            names[i] = path.getName(i + 1).toString();
        }
        Path temp = root.getFileSystem().getPath(first, names);
        if (path.isAbsolute()) {
            return root.resolve(temp);
        }
        return temp;
    }

    public static Path toDefaultFS(Path path) {
        return HelpBuildUtils.toFSGivenRoot(DEFAULT_FS_ROOT, path);
    }

    public static Path toFS(Path targetFS, Path path) {
        return HelpBuildUtils.toFSGivenRoot(targetFS.toAbsolutePath().getRoot(), path);
    }

    public static Path createReferencePath(URI fileURI) {
        Path res = fileURI.getScheme() != null ? Paths.get(fileURI) : Paths.get(fileURI.getPath(), new String[0]);
        return res;
    }

    public static boolean isRemote(String uriString) {
        try {
            URI uri = new URI(uriString);
            return HelpBuildUtils.isRemote(uri);
        }
        catch (URISyntaxException e) {
            HelpBuildUtils.debug("Invalid URI: " + uriString);
            return false;
        }
    }

    public static boolean isRemote(Path path) {
        if (path == null) {
            return false;
        }
        URI uri = path.toUri();
        return HelpBuildUtils.isRemote(uri);
    }

    public static boolean isRemote(URI uri) {
        if (HelpBuildUtils.isFilesystemPath(uri)) {
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        switch (scheme) {
            case "file": {
                return false;
            }
            case "jar": {
                return false;
            }
        }
        return true;
    }

    private static boolean isFilesystemPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return true;
        }
        return scheme.equals("file");
    }

    private static URI resolve(Path sourceFile, String ref) throws URISyntaxException {
        URI resolved = ref.startsWith("help/") ? new URI(ref) : sourceFile.toUri().resolve(ref);
        return resolved;
    }

    private static Path toPath(URI uri) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            try {
                FileSystems.newFileSystem(uri, Collections.emptyMap());
                return Paths.get(uri);
            }
            catch (IOException e1) {
                HelpBuildUtils.debug("Exception loading filesystem for uri: " + uri + "\n\t" + e1.getMessage());
                return null;
            }
        }
    }

    public static IconProvider getRuntimeIcon(String ref) {
        if (Icons.isIconsReference((String)ref)) {
            IconProvider iconProvider = Icons.getIconForIconsReference((String)ref);
            if (iconProvider == null) {
                return new IconProvider(null, null);
            }
            return iconProvider;
        }
        if (Gui.hasIcon((String)ref)) {
            GIcon gIcon = new GIcon(ref);
            return new IconProvider((Icon)gIcon, gIcon.getUrl());
        }
        String srcString = ref.toString().trim();
        if (srcString.equals(HELP_SHARED_ARROW)) {
            return SHARED_ARROW_ICON_PROVIDER;
        }
        return null;
    }

    public static ImageLocation locateImageReference(Path sourceFile, String ref) throws URISyntaxException {
        IconProvider runtimeIconProvider = HelpBuildUtils.getRuntimeIcon(ref);
        if (runtimeIconProvider != null) {
            if (runtimeIconProvider.isInvalid()) {
                return ImageLocation.createInvalidRuntimeLocation(sourceFile, ref);
            }
            URL url = runtimeIconProvider.getUrl();
            URI resolved = null;
            Path path = null;
            if (url != null) {
                resolved = url.toURI();
                path = HelpBuildUtils.toPath(resolved);
            }
            return ImageLocation.createRuntimeLocation(sourceFile, ref, resolved, path);
        }
        URI resolved = HelpBuildUtils.resolve(sourceFile, ref);
        if (HelpBuildUtils.isRemote(resolved)) {
            return ImageLocation.createRemoteLocation(sourceFile, ref, resolved);
        }
        Path path = HelpBuildUtils.createPathFromURI(sourceFile, resolved);
        return ImageLocation.createLocalLocation(sourceFile, ref, resolved, path);
    }

    public static Path locateReference(Path sourceFile, String ref) throws URISyntaxException {
        URI resolved = HelpBuildUtils.resolve(sourceFile, ref);
        if (HelpBuildUtils.isRemote(resolved)) {
            return null;
        }
        Path refPath = HelpBuildUtils.createPathFromURI(sourceFile, resolved);
        return refPath;
    }

    private static Path createPathFromURI(Path sourceFile, URI resolved) throws URISyntaxException {
        String scheme = resolved.getScheme();
        if (scheme == null) {
            return Paths.get(resolved.getRawPath(), new String[0]);
        }
        if (scheme.startsWith("file")) {
            URI uri = new URI("file://" + resolved.getRawPath());
            return Paths.get(uri);
        }
        return Paths.get(resolved);
    }

    static {
        try {
            DEFAULT_FS_ROOT = Paths.get(".", new String[0]).toRealPath(new LinkOption[0]).getRoot();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error finding root directory of local filesystem", e);
        }
    }

    public static class HelpFilesFilter
    implements FileFilter {
        private final String[] fileExtensions;

        public HelpFilesFilter(String ... extensions) {
            this.fileExtensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            if (file.isDirectory()) {
                return !".svn".equals(name) && !"bin".equals(name) && !"api".equals(name);
            }
            for (String extension : this.fileExtensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Stringizer<T> {
        public String stringize(T var1);
    }
}

