/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.BuiltinDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class BuiltinDBAdapterV0
extends BuiltinDBAdapter {
    private static final int VERSION = 0;
    static final String BUILT_IN_TABLE_NAME = "Built-in datatypes";
    static final int V0_BUILT_IN_NAME_COL = 0;
    static final int V0_BUILT_IN_CLASSNAME_COL = 1;
    static final int V0_BUILT_IN_CAT_COL = 2;
    static final Schema V0_SCHEMA = new Schema(0, "Data Type ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE}, new String[]{"Name", "Class Name", "Category ID"});
    private Table table;

    public BuiltinDBAdapterV0(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + BUILT_IN_TABLE_NAME;
        if (create) {
            this.table = handle.createTable(tableName, V0_SCHEMA, new int[]{2});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    @Override
    public DBRecord getRecord(long dataTypeID) throws IOException {
        return this.table.getRecord(dataTypeID);
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    public void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public DBRecord createRecord(String name, String className, long categoryID) throws IOException {
        long tableKey = this.table.getKey();
        if (tableKey <= 100L) {
            tableKey = 100L;
        }
        long key = DataTypeManagerDB.createKey(0, tableKey);
        DBRecord record = V0_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, className);
        record.setLongValue(2, categoryID);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }
}

