/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.URLLinkObject;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;
import ghidra.program.database.ProgramContentHandler;
import ghidra.program.database.ProgramDB;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;

public class ProgramLinkContentHandler
extends LinkHandler<ProgramDB> {
    public static final String PROGRAM_LINK_CONTENT_TYPE = "ProgramLink";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof URLLinkObject)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((DomainObjectAdapterDB)((URLLinkObject)obj), PROGRAM_LINK_CONTENT_TYPE, fs, path, name, monitor);
    }

    public String getContentType() {
        return PROGRAM_LINK_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return PROGRAM_LINK_CONTENT_TYPE;
    }

    public Class<ProgramDB> getDomainObjectClass() {
        return ProgramContentHandler.PROGRAM_DOMAIN_OBJECT_CLASS;
    }

    public Icon getIcon() {
        return ProgramContentHandler.PROGRAM_ICON;
    }

    public String getDefaultToolName() {
        return "CodeBrowser";
    }
}

