/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ContextSymbol
extends ValueSymbol {
    private VarnodeSymbol vn;
    private int low;
    private int high;
    private boolean flow = true;

    public VarnodeSymbol getVarnode() {
        return this.vn;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public int getInternalLow() {
        return ((ContextField)this.patval).getStartBit();
    }

    public int getInternalHigh() {
        return ((ContextField)this.patval).getEndBit();
    }

    public boolean followsFlow() {
        return this.flow;
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement el = parser.start(new String[]{"context_sym"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("varnode"));
        SymbolTable symtab = sleigh.getSymbolTable();
        this.vn = (VarnodeSymbol)symtab.findSymbol(id);
        this.low = SpecXmlUtils.decodeInt((String)el.getAttribute("low"));
        if (el.hasAttribute("flow")) {
            this.flow = SpecXmlUtils.decodeBoolean((String)el.getAttribute("flow"));
        }
        this.high = SpecXmlUtils.decodeInt((String)el.getAttribute("high"));
        this.patval = (PatternValue)PatternExpression.restoreExpression(parser, sleigh);
        parser.end(el);
    }
}

