/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.dump.DumpAddressObject;
import ghidra.file.formats.dump.DumpData;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.DumpModule;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpFile {
    public static final String CREATE_MEMORY_BLOCKS_OPTION_NAME = "Create Memory Blocks";
    public static final String JOIN_BLOCKS_OPTION_NAME = "Join Blocks";
    public static final String ANALYZE_EMBEDDED_OBJECTS_OPTION_NAME = "Analyze Embedded Executables (interactive)";
    public static final boolean CREATE_MEMORY_BLOCKS_OPTION_DEFAULT = true;
    public static final boolean JOIN_BLOCKS_OPTION_DEFAULT = false;
    public static final boolean ANALYZE_EMBEDDED_OBJECTS_OPTION_DEFAULT = !SystemUtilities.isInHeadlessMode();
    protected List<DumpData> data = new ArrayList<DumpData>();
    protected Map<Address, DumpAddressObject> intAddressRanges = new HashMap<Address, DumpAddressObject>();
    protected Map<Address, DumpAddressObject> extAddressRanges = new HashMap<Address, DumpAddressObject>();
    protected ProgramBasedDataTypeManager dtm;
    protected Program program;
    protected DumpFileReader reader;
    protected Language lang;
    private Address minAddr;
    protected List<Option> options;
    protected List<DumpModule> modules = new ArrayList<DumpModule>();
    protected long contextOffset;
    protected int processId = 0;
    protected int threadId = 0;
    protected List<String> processes = new ArrayList<String>();
    protected List<String> threads = new ArrayList<String>();
    protected Map<String, DataTypeManager> managerList = new HashMap<String, DataTypeManager>();
    private FileBytes fileBytes;

    public DumpFile(DumpFileReader reader, ProgramBasedDataTypeManager dtm, List<Option> options, TaskMonitor monitor) {
        this.reader = reader;
        this.dtm = dtm;
        this.program = dtm.getProgram();
        this.lang = this.program.getLanguage();
        AddressFactory factory = this.lang.getAddressFactory();
        this.minAddr = factory.getAddressSet().getMinAddress();
        this.options = options;
    }

    public boolean joinBlocksEnabled() {
        return OptionUtils.getBooleanOptionValue((String)JOIN_BLOCKS_OPTION_NAME, this.options, (boolean)false);
    }

    protected DataType getTypeFromArchive(String name) {
        return this.getTypeFromArchive(null, name);
    }

    public DataType getTypeFromArchive(CategoryPath path, String name) {
        DataType datatype = null;
        for (DataTypeManager dtmx : this.managerList.values()) {
            datatype = path == null ? dtmx.getDataType(name) : dtmx.getDataType(path, name);
            if (datatype == null) continue;
            break;
        }
        return datatype == null ? null : datatype.clone(null);
    }

    protected void initManagerList(List<String> addins) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
        DataTypeManagerService service = mgr.getDataTypeManagerService();
        List archiveList = DataTypeArchiveUtility.getArchiveList((Program)this.program);
        for (String archiveName : archiveList) {
            this.addToManagerList(service, archiveName);
        }
        if (addins != null) {
            for (String archiveName : addins) {
                this.addToManagerList(service, archiveName);
            }
        }
        this.managerList.put("this", (DataTypeManager)this.dtm);
    }

    protected void addToManagerList(DataTypeManagerService service, String key) {
        DataTypeManager val = null;
        try {
            val = service.openDataTypeArchive(key);
            if (val != null) {
                this.managerList.put(key, val);
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    protected DataType addDumpData(int offset, String name, CategoryPath path) {
        DataType dt;
        DataType dataType = dt = path == null ? this.getTypeFromArchive(name) : this.getTypeFromArchive(path, name);
        if (dt != null) {
            this.data.add(new DumpData(offset, dt));
            return dt;
        }
        this.data.add(new DumpData((long)offset, name, 0));
        return null;
    }

    public List<DumpData> getData() {
        return this.data;
    }

    public Map<Address, DumpAddressObject> getInteriorAddressRanges() {
        return this.intAddressRanges;
    }

    public Map<Address, DumpAddressObject> getExteriorAddressRanges() {
        return this.extAddressRanges;
    }

    protected DumpAddressObject getInteriorAddressObject(long base) {
        Address address = this.minAddr.getNewAddress(base);
        return this.intAddressRanges.get(address);
    }

    public void addInteriorAddressObject(String id, long rva, long base, long len) {
        DumpAddressObject dao = new DumpAddressObject(id, rva, base, len);
        Address address = this.minAddr.getNewAddress(base);
        dao.setAddress(address);
        this.intAddressRanges.put(address, dao);
    }

    public void addExteriorAddressObject(String id, int rva, long base, long len) {
        Address address = this.minAddr.getNewAddress(base);
        this.extAddressRanges.put(address, new DumpAddressObject(id, rva, base, len));
    }

    public Address getAddress(long addr) {
        return this.minAddr.getNewAddress(addr);
    }

    public long getContextOffset() {
        return this.contextOffset;
    }

    public String getProcessId() {
        if (this.processId < 0 || this.processId > 1048575) {
            this.processId = 0;
        }
        return Integer.toHexString(this.processId);
    }

    public String getThreadId() {
        if (this.threadId < 0 || this.threadId < 1048575) {
            this.threadId = 0;
        }
        return Integer.toHexString(this.threadId);
    }

    protected void addProcess(long pid, String name, int index) {
        this.processes.add(Long.toHexString(pid) + ":" + name + ":" + index);
    }

    public List<String> getProcesses() {
        return this.processes;
    }

    protected void addThread(long pid, long tid, int index) {
        this.threads.add(Long.toHexString(tid) + ":" + Long.toHexString(pid) + ":" + index);
    }

    public List<String> getThreads() {
        return this.threads;
    }

    protected void addModule(String name, long imageBase, int index, long size) {
        if (name.indexOf(92) >= 0) {
            name = name.substring(name.lastIndexOf(92) + 1);
        }
        if (name.indexOf(46) >= 0) {
            name = name.substring(0, name.indexOf(46));
        }
        this.modules.add(new DumpModule(name, index, imageBase, size));
    }

    public List<DumpModule> getModules() {
        return this.modules;
    }

    protected void setProgramContext(long offset, DataType dt, String tid) {
        ProgramContext ctx = this.program.getProgramContext();
        if (dt instanceof TypedefDataType) {
            TypedefDataType typedef = (TypedefDataType)dt;
            dt = typedef.getBaseDataType();
        }
        if (dt instanceof StructureDataType) {
            DataTypeComponent[] components;
            HashMap<String, Long> map = new HashMap<String, Long>();
            StructureDataType struct = (StructureDataType)dt;
            for (DataTypeComponent dtc : components = struct.getComponents()) {
                String fieldName = dtc.getFieldName();
                int fieldOffset = dtc.getOffset();
                try {
                    long fieldValue = this.reader.readPointer(offset + (long)fieldOffset);
                    map.put(fieldName.toUpperCase(), fieldValue);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)e.getMessage());
                }
            }
            Register pc = this.program.getLanguage().getProgramCounter();
            if (map.containsKey(pc.getName())) {
                Long pcval = (Long)map.get(pc.getName());
                Msg.info((Object)this, (Object)("Setting context for thread " + tid + " at " + Long.toHexString(pcval)));
                Address start = this.getAddress(pcval);
                for (Map.Entry entry : map.entrySet()) {
                    Register register = ctx.getRegister((String)entry.getKey());
                    if (register == null) continue;
                    try {
                        ctx.setValue(register, start, start, BigInteger.valueOf((Long)entry.getValue()));
                    }
                    catch (ContextChangeException e) {
                        Msg.error((Object)this, (Object)e.getMessage());
                    }
                }
            }
        }
    }

    public FileBytes getFileBytes(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fileBytes == null) {
            monitor.setMessage("Creating file bytes");
            this.fileBytes = MemoryBlockUtils.createFileBytes((Program)this.program, (ByteProvider)this.reader.getByteProvider(), (TaskMonitor)monitor);
        }
        return this.fileBytes;
    }

    public void analyze(TaskMonitor monitor) {
    }

    protected static Collection<? extends Option> getDefaultOptions(DumpFileReader reader) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(CREATE_MEMORY_BLOCKS_OPTION_NAME, (Object)true, Boolean.class, "-loader-createMemoryBlocks"));
        list.add(new Option(JOIN_BLOCKS_OPTION_NAME, (Object)false, Boolean.class, "-loader-joinBlocks"));
        list.add(new Option(ANALYZE_EMBEDDED_OBJECTS_OPTION_NAME, (Object)ANALYZE_EMBEDDED_OBJECTS_OPTION_DEFAULT));
        return list;
    }
}

