/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Nougat;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Oreo;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Pie;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Q;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_R;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_S_T;
import java.io.IOException;

public final class TypeLookupTableFactory {
    public static final TypeLookupTable getTypeLookupTable(BinaryReader reader, String oatVersion) throws IOException {
        switch (oatVersion) {
            case "079": 
            case "088": {
                return new TypeLookupTable_Nougat(reader);
            }
            case "124": 
            case "131": 
            case "126": {
                return new TypeLookupTable_Oreo(reader);
            }
            case "138": {
                return new TypeLookupTable_Pie(reader);
            }
            case "170": {
                return new TypeLookupTable_Q(reader);
            }
            case "183": {
                return new TypeLookupTable_R(reader);
            }
            case "195": 
            case "199": 
            case "220": 
            case "223": 
            case "225": {
                return new TypeLookupTable_S_T(reader);
            }
        }
        throw new IOException(new UnsupportedOatVersionException("Unsupported TypeLookupTable for OAT version " + oatVersion));
    }
}

