/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootldr;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderConstants;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderHeader;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderImageInfo;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class AndroidBootLoaderAnalyzer
extends AbstractAnalyzer {
    public AndroidBootLoaderAnalyzer() {
        super("Android Boot Loader", "Annotates the Android Boot Loader header components", AnalyzerType.BYTE_ANALYZER);
    }

    public boolean getDefaultEnablement(Program program) {
        return AndroidBootLoaderConstants.isBootLoader(program);
    }

    public boolean canAnalyze(Program program) {
        return AndroidBootLoaderConstants.isBootLoader(program);
    }

    public void registerOptions(Options options, Program program) {
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSpace addressSpace = program.getAddressFactory().getDefaultAddressSpace();
        Address headerAddress = program.getMinAddress();
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        try {
            AndroidBootLoaderHeader header = new AndroidBootLoaderHeader(reader);
            DataType headerDataType = header.toDataType();
            Data headerData = program.getListing().createData(headerAddress, headerDataType);
            if (headerData == null) {
                log.appendMsg("Unable to apply header data, stopping.");
                return false;
            }
            SymbolTable symbolTable = program.getSymbolTable();
            Symbol headerSymbol = symbolTable.getPrimarySymbol(headerAddress);
            if (headerSymbol == null) {
                symbolTable.createLabel(headerAddress, header.getMagic(), SourceType.ANALYSIS);
            } else {
                headerSymbol.setName(header.getMagic(), SourceType.ANALYSIS);
            }
            int runningOffset = header.getStartOffset();
            for (AndroidBootLoaderImageInfo imageInfo : header.getImageInfoList()) {
                Address address = addressSpace.getAddress((long)runningOffset);
                symbolTable.createLabel(address, imageInfo.getName(), SourceType.ANALYSIS);
                program.getBookmarkManager().setBookmark(address, "Analysis", "boot", imageInfo.getName());
                runningOffset += imageInfo.getSize();
            }
            return true;
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return false;
        }
    }
}

