/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Complex16DataType;
import ghidra.program.model.data.Complex32DataType;
import ghidra.program.model.data.Complex8DataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedCharDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.util.exception.AssertException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PdbPrimitiveTypeApplicator {
    private static final DataType NO_TYPE_DATATYPE = new TypedefDataType("<NoType>", (DataType)Undefined1DataType.dataType);
    private DataTypeManager dataTypeManager;
    private DataType voidGhidraPrimitive = null;
    private DataType charGhidraPrimitive = null;
    private DataType signedCharGhidraPrimitive = null;
    private DataType unsignedCharGhidraPrimitive = null;
    private Map<Integer, DataType> integralGhidraPrimitives = new HashMap<Integer, DataType>();
    private Map<Integer, DataType> unsignedIntegralGhidraPrimitives = new HashMap<Integer, DataType>();
    private Map<Integer, DataType> floatGhidraPrimitives = new HashMap<Integer, DataType>();
    private Map<Integer, DataType> complexGhidraPrimitives = new HashMap<Integer, DataType>();
    private Map<String, DataType> otherPrimitives = new HashMap<String, DataType>();

    public PdbPrimitiveTypeApplicator(DataTypeManager dataTypeManager) {
        Objects.requireNonNull(dataTypeManager, "dataTypeManager cannot be null");
        this.dataTypeManager = dataTypeManager;
    }

    private DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    DataType resolve(DataType dataType) {
        return this.getDataTypeManager().resolve(dataType, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
    }

    DataType getNoType(PrimitiveMsType type) {
        return NO_TYPE_DATATYPE;
    }

    DataType getVoidType() {
        if (this.voidGhidraPrimitive == null) {
            this.voidGhidraPrimitive = this.resolve((DataType)VoidDataType.dataType);
        }
        return this.voidGhidraPrimitive;
    }

    DataType getCharType() {
        if (this.charGhidraPrimitive == null) {
            CharDataType dataType = new CharDataType(this.getDataTypeManager());
            this.charGhidraPrimitive = this.resolve((DataType)dataType);
        }
        return this.charGhidraPrimitive;
    }

    DataType getSignedCharType() {
        if (this.signedCharGhidraPrimitive == null) {
            SignedCharDataType dataType = new SignedCharDataType(this.getDataTypeManager());
            this.signedCharGhidraPrimitive = this.resolve((DataType)dataType);
        }
        return this.signedCharGhidraPrimitive;
    }

    DataType getUnsignedCharType() {
        if (this.unsignedCharGhidraPrimitive == null) {
            UnsignedCharDataType dataType = new UnsignedCharDataType(this.getDataTypeManager());
            this.unsignedCharGhidraPrimitive = this.resolve((DataType)dataType);
        }
        return this.unsignedCharGhidraPrimitive;
    }

    DataType getUnicode16Type() {
        return new WideChar16DataType(this.getDataTypeManager());
    }

    DataType getUnicode32Type() {
        return new WideChar32DataType(this.getDataTypeManager());
    }

    WideCharDataType getWideCharType() {
        return new WideCharDataType(this.getDataTypeManager());
    }

    DataType get8BitIntegerType() {
        String name = "int8";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 1 ? IntegerDataType.dataType : this.createTypedef(name, this.getIntegralType(1));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get8BitUnsignedIntegerType() {
        String name = "uint8";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 1 ? UnsignedIntegerDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(1));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get16BitIntegerType() {
        String name = "int16";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 2 ? IntegerDataType.dataType : this.createTypedef(name, this.getIntegralType(2));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get16BitUnsignedIntegerType() {
        String name = "uint16";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 2 ? UnsignedIntegerDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(2));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get16BitShortType() {
        String name = "short16";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getShortSize() == 2 ? ShortDataType.dataType : this.createTypedef(name, this.getIntegralType(2));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get16BitUnsignedShortType() {
        String name = "ushort16";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getShortSize() == 2 ? UnsignedShortDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(2));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get32BitIntegerType() {
        String name = "int32";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 4 ? IntegerDataType.dataType : this.createTypedef(name, this.getIntegralType(4));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get32BitUnsignedIntegerType() {
        String name = "uint32";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 4 ? UnsignedIntegerDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(4));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get32BitLongType() {
        String name = "long32";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 4 ? LongDataType.dataType : this.createTypedef(name, this.getIntegralType(4));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get32BitUnsignedLongType() {
        String name = "ulong32";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 4 ? UnsignedLongDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(4));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get64BitLongType() {
        String name = "long64";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 8 ? LongDataType.dataType : this.createTypedef(name, this.getIntegralType(8));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get64BitUnsignedLongType() {
        String name = "ulong64";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 8 ? UnsignedLongDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(8));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get64BitIntegerType() {
        String name = "int64";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 8 ? IntegerDataType.dataType : this.createTypedef(name, this.getIntegralType(8));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get64BitUnsignedIntegerType() {
        String name = "uint64";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 8 ? UnsignedIntegerDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(8));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get128BitLongType() {
        String name = "ulong128";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 16 ? LongDataType.dataType : this.createTypedef(name, this.getIntegralType(16));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get128BitUnsignedLongType() {
        String name = "ulong128";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getLongSize() == 16 ? UnsignedLongDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(16));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get128BitIntegerType() {
        String name = "int128";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 16 ? IntegerDataType.dataType : this.createTypedef(name, this.getIntegralType(16));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get128BitUnsignedIntegerType() {
        String name = "uint128";
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        Object type = this.getDataTypeManager().getDataOrganization().getIntegerSize() == 16 ? UnsignedIntegerDataType.dataType : this.createTypedef(name, this.getUnsignedIntegralType(16));
        DataType resolved = this.resolve((DataType)type);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    private DataType createTypedef(String name, DataType dataType) {
        TypedefDataType typedefDataType = new TypedefDataType(name, dataType);
        return this.resolve((DataType)typedefDataType);
    }

    DataType createTypedefNamedSizedType(String name, int size) {
        TypedefDataType dataType = new TypedefDataType(name, Undefined.getUndefinedDataType((int)size));
        return this.resolve((DataType)dataType);
    }

    DataType createTypedefNamedSizedType(PrimitiveMsType type) {
        return this.createTypedefNamedSizedType(type.getName(), type.getTypeSize());
    }

    DataType createUnmappedPdbType(PrimitiveMsType type) {
        String name = String.format("UnmappedPdbType%04X", type.getNumber());
        return this.createTypedefNamedSizedType(name, 1);
    }

    private DataType getIntegralType(int size) {
        DataType dataType = this.integralGhidraPrimitives.get(size);
        if (dataType != null) {
            return dataType;
        }
        DataType resolved = this.resolve(AbstractIntegerDataType.getSignedDataType((int)size, (DataTypeManager)this.getDataTypeManager()));
        this.integralGhidraPrimitives.put(size, resolved);
        return resolved;
    }

    private DataType getUnsignedIntegralType(int size) {
        DataType dataType = this.unsignedIntegralGhidraPrimitives.get(size);
        if (dataType != null) {
            return dataType;
        }
        DataType resolved = this.resolve(AbstractIntegerDataType.getUnsignedDataType((int)size, (DataTypeManager)this.getDataTypeManager()));
        this.unsignedIntegralGhidraPrimitives.put(size, resolved);
        return resolved;
    }

    DataType get16BitRealType() {
        return this.getRealType(2, "float16");
    }

    DataType get32BitRealType() {
        return this.getRealType(4, "float32");
    }

    DataType get32BitPartialPrecisionRealType() {
        return this.createTypedefNamedSizedType("T_REAL32PP", 4);
    }

    DataType get48BitRealType() {
        return this.getRealType(6, "float48");
    }

    DataType get64BitRealType() {
        return this.getRealType(8, "float64");
    }

    DataType get80BitRealType() {
        return this.getRealType(10, "float80");
    }

    DataType get128BitRealType() {
        return this.getRealType(16, "float128");
    }

    private DataType getRealType(int rawSize, String name) {
        DataType resolved;
        DataType dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        dataType = this.floatGhidraPrimitives.get(rawSize);
        if (dataType == null) {
            resolved = this.resolve(AbstractFloatDataType.getFloatDataType((int)rawSize, (DataTypeManager)this.getDataTypeManager()));
            this.floatGhidraPrimitives.put(rawSize, resolved);
            if (resolved instanceof Undefined) {
                DataType type = this.createTypedef(name, resolved);
                resolved = this.resolve(type);
            }
        } else {
            resolved = dataType;
        }
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    DataType get16BitComplexType() {
        return this.getComplexType(16);
    }

    DataType get32BitComplexType() {
        return this.getComplexType(4);
    }

    DataType get32BitPartialPrecisionComplexType() {
        return this.createTypedefNamedSizedType("T_CPLX32PP", 8);
    }

    DataType get48BitComplexType() {
        return this.getComplexType(48);
    }

    DataType get64BitComplexType() {
        return this.getComplexType(8);
    }

    DataType get80BitComplexType() {
        return this.getComplexType(10);
    }

    DataType get128BitComplexType() {
        return this.getComplexType(128);
    }

    private DataType getComplexType(int size) {
        DataType dataType = this.complexGhidraPrimitives.get(size);
        if (dataType != null) {
            return dataType;
        }
        switch (size) {
            case 32: {
                dataType = new Complex8DataType(this.getDataTypeManager());
                break;
            }
            case 64: {
                dataType = new Complex16DataType(this.getDataTypeManager());
                break;
            }
            case 80: {
                dataType = this.createTypedefNamedSizedType("T_CPLX80", 20);
                break;
            }
            case 128: {
                dataType = new Complex32DataType(this.getDataTypeManager());
                break;
            }
            default: {
                String message = "Programming error: Complex size not supported" + size;
                PdbLog.message(message);
                throw new AssertException(message);
            }
        }
        DataType resolved = this.resolve(dataType);
        this.complexGhidraPrimitives.put(size, resolved);
        return resolved;
    }

    DataType get8BitBooleanType() {
        return this.getBooleanType(1, "T_BOOL08");
    }

    DataType get16BitBooleanType() {
        return this.getBooleanType(2, "T_BOOL16");
    }

    DataType get32BitBooleanType() {
        return this.getBooleanType(4, "T_BOOL32");
    }

    DataType get64BitBooleanType() {
        return this.getBooleanType(8, "T_BOOL64");
    }

    DataType get128BitBooleanType() {
        return this.getBooleanType(16, "T_BOOL128");
    }

    private DataType getBooleanType(int size, String name) {
        Object dataType = this.otherPrimitives.get(name);
        if (dataType != null) {
            return dataType;
        }
        dataType = size == this.getBooleanSize() ? new BooleanDataType(this.getDataTypeManager()) : this.getIntegralType(size);
        DataType resolved = this.resolve((DataType)dataType);
        this.otherPrimitives.put(name, resolved);
        return resolved;
    }

    private int getBooleanSize() {
        return 1;
    }

    private Pointer getPointerType(int ptrSize, DataType baseType) {
        if (this.getDataTypeManager().getDataOrganization().getPointerSize() == ptrSize) {
            return this.getDataTypeManager().getPointer(baseType);
        }
        return this.getDataTypeManager().getPointer(baseType, ptrSize);
    }

    Pointer get16NearPointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get1616FarPointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get1616HugePointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get32PointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get1632PointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get64PointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }

    Pointer get128PointerType(PrimitiveMsType type, DataType baseType) {
        return this.getPointerType(type.getTypeSize(), baseType);
    }
}

