/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLabelMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.regex.Matcher;

public class LabelSymbolApplier
extends MsSymbolApplier {
    private AbstractLabelMsSymbol symbol;
    private Function function = null;

    public LabelSymbolApplier(DefaultPdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractLabelMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractLabelMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        String label = this.symbol.getName();
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, label)) {
            return;
        }
        if (this.hasFunctionIndication()) {
            this.applyFunction(symbolAddress, label, this.applicator.getCancelOnlyWrappingMonitor());
        } else {
            this.applicator.createSymbol(symbolAddress, label, true);
        }
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
        FunctionSymbolApplier functionSymbolApplier;
        Function f;
        String label = this.getLabel();
        if (label == null) {
            return;
        }
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, label)) {
            return;
        }
        if (applyToApplier instanceof FunctionSymbolApplier && (f = (functionSymbolApplier = (FunctionSymbolApplier)applyToApplier).getFunction()) != null && !f.getName().equals(label)) {
            label = NamespaceUtils.getNamespaceQualifiedName((Namespace)f, (String)label, (boolean)true);
        }
        this.applicator.createSymbol(symbolAddress, label, false);
    }

    private boolean hasFunctionIndication() {
        return this.symbol.getFlags().hasFunctionIndication();
    }

    private boolean isNonReturning() {
        return this.symbol.getFlags().doesNotReturn();
    }

    private boolean hasCustomCallingConvention() {
        return this.symbol.getFlags().hasCustomCallingConvention();
    }

    private boolean applyFunction(Address address, String name, TaskMonitor monitor) {
        this.applicator.createSymbol(address, name, true);
        this.function = this.createFunction(address, monitor);
        if (this.function == null) {
            return false;
        }
        if (!this.function.isThunk() && this.function.getSignatureSource().isLowerPriorityThan(SourceType.IMPORTED)) {
            this.function.setNoReturn(this.isNonReturning());
            if (this.hasCustomCallingConvention()) {
                try {
                    this.function.setCallingConvention("unknown");
                }
                catch (InvalidInputException e) {
                    Msg.warn((Object)this, (Object)("PDB: Could not set \"unknown\" calling convention for label: " + name));
                }
            }
        }
        return true;
    }

    private Function createFunction(Address address, TaskMonitor monitor) {
        Function myFunction = this.applicator.getProgram().getListing().getFunctionAt(address);
        if (myFunction != null) {
            return myFunction;
        }
        Instruction instr = this.applicator.getProgram().getListing().getInstructionAt(address);
        if (instr == null) {
            DisassembleCommand cmd = new DisassembleCommand(address, null, true);
            cmd.applyTo((DomainObject)this.applicator.getProgram(), monitor);
        }
        myFunction = this.createFunctionCommand(address, monitor);
        return myFunction;
    }

    private Function createFunctionCommand(Address address, TaskMonitor monitor) {
        CreateFunctionCmd funCmd = new CreateFunctionCmd(address);
        if (!funCmd.applyTo((DomainObject)this.applicator.getProgram(), monitor)) {
            this.applicator.appendLogMsg("Failed to apply function at address " + address.toString() + "; attempting to use possible existing function");
            return this.applicator.getProgram().getListing().getFunctionAt(address);
        }
        return funCmd.getFunction();
    }

    private String getLabel() {
        if (!this.applicator.getPdbApplicatorOptions().applyInstructionLabels()) {
            return null;
        }
        String label = this.symbol.getName();
        Matcher m = this.applicator.getPdbApplicatorOptions().excludeInstructionLabelsPattern().matcher(label);
        if (m.find()) {
            return null;
        }
        return label;
    }
}

