/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class C13InlineeLines
extends C13Section {
    private static final int InlineeSourceLineSignature = 0;
    private static final int ExtendedInlineeSourceLineSignature = 1;
    private int signature;
    private List<InlineeSourceLine> inlineeLines = new ArrayList<InlineeSourceLine>();

    static C13InlineeLines parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new C13InlineeLines(reader, ignore, monitor);
    }

    private static List<InlineeSourceLine> parseInlineeLines(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        ArrayList<InlineeSourceLine> lines = new ArrayList<InlineeSourceLine>();
        while (reader.numRemaining() >= InlineeSourceLine.getBaseRecordSize()) {
            monitor.checkCancelled();
            InlineeSourceLine line = new InlineeSourceLine(reader);
            lines.add(line);
        }
        return lines;
    }

    private static List<InlineeSourceLine> parseExtendedInlineeLines(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        ArrayList<InlineeSourceLine> lines = new ArrayList<InlineeSourceLine>();
        while (reader.numRemaining() >= ExtendedInlineeSourceLine.getBaseRecordSize()) {
            monitor.checkCancelled();
            ExtendedInlineeSourceLine line = new ExtendedInlineeSourceLine(reader, monitor);
            lines.add(line);
        }
        return lines;
    }

    protected C13InlineeLines(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        super(ignore);
        this.signature = reader.parseInt();
        switch (this.signature) {
            case 0: {
                this.inlineeLines = C13InlineeLines.parseInlineeLines(reader, monitor);
                break;
            }
            case 1: {
                this.inlineeLines = C13InlineeLines.parseExtendedInlineeLines(reader, monitor);
                break;
            }
            default: {
                this.inlineeLines = new ArrayList<InlineeSourceLine>();
            }
        }
        if (reader.hasMore()) {
            Msg.debug(C13InlineeLines.class, (Object)String.format("Extra inlinee bytes remain for signature: 0x%03x", this.signature));
        }
    }

    List<InlineeSourceLine> getInlineeLines() {
        return this.inlineeLines;
    }

    public String toString() {
        return String.format("%s: num inlinee lines = %d", this.getClass().getSimpleName(), this.inlineeLines.size());
    }

    @Override
    void dump(Writer writer) throws IOException {
        writer.write("C13InlineeLines---------------------------------------------\n");
        writer.write(String.format("Signature: 0x%03x\n", this.signature));
        for (InlineeSourceLine line : this.inlineeLines) {
            writer.write(line.toString());
            writer.write(10);
        }
        writer.write("End C13InlineeLines-----------------------------------------\n");
    }

    static class InlineeSourceLine {
        protected long inlinee;
        protected int fileId;
        protected int sourceLineNum;

        private static int getBaseRecordSize() {
            return 12;
        }

        InlineeSourceLine(PdbByteReader reader) throws PdbException {
            this.inlinee = reader.parseUnsignedIntVal();
            this.fileId = reader.parseInt();
            this.sourceLineNum = reader.parseInt();
        }

        long getInlinee() {
            return this.inlinee;
        }

        long getFileId() {
            return this.fileId;
        }

        long getSourceLineNum() {
            return this.sourceLineNum;
        }

        public String toString() {
            return String.format("0x%09x, 0x%06x, %d", this.inlinee, this.fileId, this.sourceLineNum);
        }
    }

    static class ExtendedInlineeSourceLine
    extends InlineeSourceLine {
        private List<Integer> extraFileIds = new ArrayList<Integer>();

        private static int getBaseRecordSize() {
            return 16;
        }

        ExtendedInlineeSourceLine(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
            super(reader);
            long numExtraFiles = reader.parseUnsignedIntVal();
            for (long i = 0L; i < numExtraFiles; ++i) {
                monitor.checkCancelled();
                this.extraFileIds.add(reader.parseInt());
            }
        }

        int getNumExtraFileIds() {
            return this.extraFileIds.size();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("0x%09x, 0x%06x, %d", this.inlinee, this.fileId, this.sourceLineNum));
            for (Integer id : this.extraFileIds) {
                builder.append(String.format(" 0x%06x", id));
            }
            return builder.toString();
        }
    }
}

