/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolHashRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractSymbolInformation {
    public static final int HEADER_SIGNATURE = -1;
    public static final int GSI70 = -248575718;
    protected AbstractPdb pdb;
    protected int numHashRecords;
    protected int numExtraBytes;
    protected int hashRecordsBitMapLength;
    protected int headerSignature;
    protected int versionNumber;
    protected int hashRecordsLength;
    protected int bucketsLength;
    protected List<Integer> hashBucketOffsets = new ArrayList<Integer>();
    protected Set<SymbolHashRecord> hashRecords = new TreeSet<SymbolHashRecord>();
    protected List<Long> modifiedHashRecordSymbolOffsets = new ArrayList<Long>();
    protected List<AbstractMsSymbol> symbols = new ArrayList<AbstractMsSymbol>();

    public AbstractSymbolInformation(AbstractPdb pdbIn) {
        this.pdb = pdbIn;
    }

    public List<AbstractMsSymbol> getSymbols() {
        return this.symbols;
    }

    public List<Long> getModifiedHashRecordSymbolOffsets() {
        return this.modifiedHashRecordSymbolOffsets;
    }

    void deserialize(int streamNumber) throws IOException, PdbException, CancelledException {
        if (this.pdb.hasMinimalDebugInfo()) {
            this.hashRecordsBitMapLength = 32768;
            this.numExtraBytes = 0;
            this.numHashRecords = 262143;
        } else {
            this.hashRecordsBitMapLength = 512;
            this.numExtraBytes = 4;
            this.numHashRecords = 4096;
        }
    }

    void dump(Writer writer) throws IOException, CancelledException {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractSymbolInformation-----------------------------------\n");
        this.dumpHashHeader(builder);
        this.dumpHashBasics(builder);
        this.dumpHashRecords(builder);
        builder.append("\nEnd AbstractSymbolInformation-------------------------------\n");
        writer.write(builder.toString());
    }

    protected void dumpHashBasics(StringBuilder builder) {
        builder.append("HashBasics--------------------------------------------------\n");
        builder.append("hashRecordsBitMapLength: ");
        builder.append(this.hashRecordsBitMapLength);
        builder.append("\nnumExtraBytes: ");
        builder.append(this.numExtraBytes);
        builder.append("\nnumHashRecords: ");
        builder.append(this.numHashRecords);
        builder.append("\nEnd HashBasics----------------------------------------------\n");
    }

    protected void dumpHashHeader(StringBuilder builder) {
        builder.append("HashHeader--------------------------------------------------\n");
        builder.append("headerSignature: ");
        builder.append(this.headerSignature);
        builder.append("\nversionNumber: ");
        builder.append(this.versionNumber);
        builder.append("\nlengthHashRecords: ");
        builder.append(this.hashRecordsLength);
        builder.append("\nlengthBuckets: ");
        builder.append(this.bucketsLength);
        builder.append("\nEnd HashHeader----------------------------------------------\n");
    }

    protected void generateSymbolsList() throws PdbException, CancelledException {
        this.symbols = new ArrayList<AbstractMsSymbol>();
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        Map<Long, AbstractMsSymbol> symbolsByOffset = debugInfo.getSymbolsByOffset();
        for (SymbolHashRecord record : this.hashRecords) {
            this.pdb.checkCancelled();
            long offset = record.getOffset() - 2L;
            AbstractMsSymbol symbol = symbolsByOffset.get(offset);
            this.modifiedHashRecordSymbolOffsets.add(offset);
            if (symbol == null) {
                throw new PdbException("PDB corrupted");
            }
            this.symbols.add(symbol);
        }
    }

    protected void dumpHashRecords(StringBuilder builder) throws CancelledException {
        builder.append("HashRecords-------------------------------------------------\n");
        builder.append("numHashRecords: " + this.hashRecords.size() + "\n");
        for (SymbolHashRecord record : this.hashRecords) {
            this.pdb.checkCancelled();
            builder.append(String.format("0X%08X  0X%04X\n", record.getOffset(), record.getReferenceCount()));
        }
        builder.append("\nEnd HashRecords---------------------------------------------\n");
    }

    protected void deserializeHashTable(PdbByteReader reader) throws PdbException, CancelledException {
        block4: {
            block3: {
                this.deserializeHashHeader(reader);
                if (this.headerSignature != -1) break block3;
                switch (this.versionNumber) {
                    case -248575718: {
                        this.deserializeGsi70HashTable(reader);
                        break block4;
                    }
                    default: {
                        throw new PdbException("Unknown GSI Version Number");
                    }
                }
            }
            reader.reset();
            this.deserializeGsiPre70HashTable(reader);
        }
    }

    private void deserializeHashHeader(PdbByteReader reader) throws PdbException {
        this.headerSignature = reader.parseInt();
        this.versionNumber = reader.parseInt();
        this.hashRecordsLength = reader.parseInt();
        this.bucketsLength = reader.parseInt();
    }

    private void deserializeGsiPre70HashTable(PdbByteReader reader) throws PdbException, CancelledException {
        int numBucketsBytes = 4 * (this.numHashRecords + 1);
        if (reader.numRemaining() < numBucketsBytes) {
            throw new PdbException("Not enough data for GSI");
        }
        int numRecordsBytes = reader.numRemaining() - numBucketsBytes;
        PdbByteReader hashRecordsReader = reader.getSubPdbByteReader(numRecordsBytes);
        PdbByteReader bucketsReader = reader.getSubPdbByteReader(numBucketsBytes);
        if (reader.hasMore()) {
            throw new PdbException("Unexpected extra information at and of GSI stream");
        }
        this.hashBucketOffsets = new ArrayList<Integer>();
        while (bucketsReader.hasMore()) {
            this.pdb.checkCancelled();
            this.hashBucketOffsets.add(bucketsReader.parseInt());
        }
        this.deserializeHashRecords(hashRecordsReader);
    }

    private void deserializeGsi70HashTable(PdbByteReader reader) throws PdbException, CancelledException {
        if (reader.numRemaining() != this.hashRecordsLength + this.bucketsLength) {
            throw new PdbException("Data count mismatch in GSI stream");
        }
        if (this.hashRecordsLength == 0 || this.bucketsLength == 0) {
            return;
        }
        PdbByteReader hashRecordsReader = reader.getSubPdbByteReader(this.hashRecordsLength);
        PdbByteReader bucketsReader = reader.getSubPdbByteReader(this.bucketsLength);
        this.deserializedCompressedHashBuckets(bucketsReader);
        this.deserializeHashRecords(hashRecordsReader);
    }

    private void deserializedCompressedHashBuckets(PdbByteReader reader) throws PdbException, CancelledException {
        PdbByteReader bitEncoderReader = reader.getSubPdbByteReader(this.hashRecordsBitMapLength);
        reader.getSubPdbByteReader(this.numExtraBytes);
        while (bitEncoderReader.hasMore() && reader.hasMore()) {
            this.pdb.checkCancelled();
            long val = bitEncoderReader.parseUnsignedIntVal();
            for (int bit = 0; bit < 32 && reader.hasMore(); ++bit) {
                this.pdb.checkCancelled();
                if ((val & 1L) == 1L) {
                    this.hashBucketOffsets.add(reader.parseInt());
                } else {
                    this.hashBucketOffsets.add(-1);
                }
                val >>= 1;
            }
        }
        if (reader.hasMore()) {
            throw new PdbException("Compressed GSI Hash Buckets corrupt");
        }
        while (bitEncoderReader.hasMore()) {
            this.pdb.checkCancelled();
            if (bitEncoderReader.parseUnsignedIntVal() == 0L) continue;
            throw new PdbException("Compressed GSI Hash Buckets corrupt");
        }
    }

    private void deserializeHashRecords(PdbByteReader reader) throws PdbException, CancelledException {
        this.hashRecords = new TreeSet<SymbolHashRecord>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            SymbolHashRecord record = new SymbolHashRecord();
            record.parse(reader);
            this.hashRecords.add(record);
        }
    }
}

