/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.button.BrowseButton;
import docking.widgets.label.GDLabel;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.feature.vt.gui.wizard.VTWizardUtils;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class NewSessionPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private static final int MAX_LENGTH_FOR_VT_SESSION_NAME = 20;
    private static final Icon SWAP_ICON = new GIcon("icon.version.tracking.new.session.swap");
    private static final Icon INFO_ICON = new GIcon("icon.version.tracking.new.session.info");
    private JTextField sourceField;
    private JTextField destinationField;
    private JButton sourceBrowseButton;
    private JButton destinationBrowseButton;
    private JButton swapProgramsButton;
    private JTextField sessionNameField;
    private JTextField folderNameField;
    private DomainFolder folder;
    private PluginTool tool;
    private Map<DomainFile, ProgramInfo> allProgramInfos = new HashMap<DomainFile, ProgramInfo>();
    private ProgramInfo sourceProgramInfo;
    private ProgramInfo destinationProgramInfo;

    NewSessionPanel(PluginTool tool) {
        this.tool = tool;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GDLabel folderLabel = new GDLabel("Project folder ");
        folderLabel.setHorizontalAlignment(4);
        folderLabel.setToolTipText("The folder to store the new Version Tracking Session");
        this.folderNameField = new JTextField();
        Gui.registerFont((Component)this.folderNameField, (String)"font.monospaced");
        this.folderNameField.setEditable(false);
        BrowseButton browseFolderButton = new BrowseButton();
        browseFolderButton.addActionListener(e -> this.browseDataTreeFolders());
        GDLabel newSessionLabel = new GDLabel("New Session Name: ");
        newSessionLabel.setToolTipText("The name for the new Version Tracking Session");
        newSessionLabel.setHorizontalAlignment(4);
        this.sessionNameField = new JTextField(25);
        this.sessionNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewSessionPanel.this.notifyListenersOfValidityChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewSessionPanel.this.notifyListenersOfValidityChanged();
            }
        });
        GDLabel sourceLabel = new GDLabel("Source Program: ");
        sourceLabel.setIcon(INFO_ICON);
        sourceLabel.setToolTipText("Analyzed program with markup to transfer");
        sourceLabel.setHorizontalAlignment(4);
        GDLabel destinationLabel = new GDLabel("Destination Program: ");
        destinationLabel.setIcon(INFO_ICON);
        destinationLabel.setToolTipText("New program that receives the transferred markup");
        destinationLabel.setHorizontalAlignment(4);
        this.sourceField = new JTextField(25);
        this.sourceField.setEditable(false);
        this.destinationField = new JTextField(25);
        this.destinationField.setEditable(false);
        this.sourceBrowseButton = this.createSourceBrowseButton();
        this.destinationBrowseButton = this.createDestinationBrowseButton();
        this.swapProgramsButton = new JButton(SWAP_ICON);
        this.swapProgramsButton.setText("swap");
        this.swapProgramsButton.setName("SWAP_BUTTON");
        this.swapProgramsButton.addActionListener(arg0 -> this.swapPrograms());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)folderLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.folderNameField, gbc);
        ++gbc.gridx;
        mainPanel.add(Box.createHorizontalStrut(5), gbc);
        ++gbc.gridx;
        mainPanel.add((Component)browseFolderButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(10), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)newSessionLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.sessionNameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        mainPanel.add((Component)sourceLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.sourceField, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.sourceBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.gridwidth = 4;
        mainPanel.add((Component)this.swapProgramsButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)destinationLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.destinationField, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.destinationBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(60), gbc);
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "North");
    }

    private void initializePrograms(WizardState<VTWizardStateKey> state) {
        DomainFile source = (DomainFile)state.get((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE);
        DomainFile destintation = (DomainFile)state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE);
        if (source != null) {
            this.setSourceProgram(source);
        }
        if (destintation != null) {
            this.setDestinationProgram(destintation);
        }
    }

    private void browseDataTreeFolders() {
        DataTreeDialog dataTreeDialog = new DataTreeDialog((Component)((Object)this), "Choose a project folder", 2);
        dataTreeDialog.addOkActionListener(e -> {
            dataTreeDialog.close();
            this.setFolder(dataTreeDialog.getDomainFolder());
        });
        dataTreeDialog.showComponent();
    }

    void setFolder(DomainFolder folder) {
        this.folder = folder;
        if (folder != null) {
            this.folderNameField.setText(folder.toString());
        } else {
            this.folderNameField.setText("< Choose a folder >");
        }
        this.notifyListenersOfValidityChanged();
    }

    private void setSourceProgram(DomainFile programFile) {
        String path;
        this.notifyListenersOfStatusMessage(" ");
        if (programFile == null) {
            this.sourceProgramInfo = null;
            path = "";
        } else {
            this.sourceProgramInfo = this.allProgramInfos.computeIfAbsent(programFile, file -> new ProgramInfo((DomainFile)file));
            path = programFile.getPathname();
        }
        this.sourceField.setText(path);
        this.updateSessionNameIfBlank();
        this.notifyListenersOfValidityChanged();
    }

    private void updateSessionNameIfBlank() {
        if (!StringUtils.isBlank((CharSequence)this.sessionNameField.getText())) {
            return;
        }
        if (this.sourceProgramInfo == null || this.destinationProgramInfo == null) {
            return;
        }
        String sourceName = this.sourceProgramInfo.getName();
        String destinationName = this.destinationProgramInfo.getName();
        if (sourceName.length() > 20) {
            sourceName = sourceName.substring(0, 20);
        }
        if (destinationName.length() > 20) {
            destinationName = destinationName.substring(0, 20);
        }
        String defaultSessionName = "VT__" + sourceName + "__" + destinationName;
        this.sessionNameField.setText(defaultSessionName);
    }

    private void setDestinationProgram(DomainFile programFile) {
        String path;
        this.notifyListenersOfStatusMessage(" ");
        if (programFile == null) {
            this.destinationProgramInfo = null;
            path = "";
        } else {
            this.destinationProgramInfo = this.allProgramInfos.computeIfAbsent(programFile, file -> new ProgramInfo((DomainFile)file));
            path = programFile.getPathname();
        }
        this.destinationField.setText(path);
        this.updateSessionNameIfBlank();
        this.notifyListenersOfValidityChanged();
    }

    private void swapPrograms() {
        this.notifyListenersOfStatusMessage(" ");
        ProgramInfo temp = this.destinationProgramInfo;
        this.destinationProgramInfo = this.sourceProgramInfo;
        this.sourceProgramInfo = temp;
        if (this.sourceProgramInfo != null) {
            this.sourceField.setText(this.sourceProgramInfo.getPathname());
        } else {
            this.sourceField.setText("");
        }
        if (this.destinationProgramInfo != null) {
            this.destinationField.setText(this.destinationProgramInfo.getPathname());
        } else {
            this.destinationField.setText("");
        }
        this.notifyListenersOfValidityChanged();
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "New_Session_Panel");
    }

    private void releaseConsumers() {
        for (ProgramInfo info : this.allProgramInfos.values()) {
            info.release(this.tool);
        }
        this.allProgramInfos.clear();
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        this.initializePrograms(state);
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        return WizardPanelDisplayability.MUST_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE, (Object)this.sourceProgramInfo.getFile());
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE, (Object)this.destinationProgramInfo.getFile());
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM, (Object)this.sourceProgramInfo.getProgram());
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM, (Object)this.destinationProgramInfo.getProgram());
        state.put((Object)VTWizardStateKey.SESSION_NAME, (Object)this.sessionNameField.getText());
        state.put((Object)VTWizardStateKey.NEW_SESSION_FOLDER, (Object)this.folder);
    }

    private void openProgram(ProgramInfo programInfo) {
        if (programInfo.hasProgram()) {
            return;
        }
        OpenProgramTask openProgramTask = new OpenProgramTask(programInfo.getFile(), (Object)this.tool);
        new TaskLauncher((Task)openProgramTask, (Component)this.tool.getActiveWindow());
        OpenProgramTask.OpenProgramRequest openProgram = openProgramTask.getOpenProgram();
        programInfo.setProgram(openProgram != null ? openProgram.getProgram() : null);
    }

    public String getTitle() {
        return "New Version Tracking Session";
    }

    public void initialize() {
        this.sourceProgramInfo = null;
        this.destinationProgramInfo = null;
        this.sessionNameField.setText("");
        this.sourceField.setText("");
        this.destinationField.setText("");
        this.setFolder(this.tool.getProject().getProjectData().getRootFolder());
    }

    public boolean isValidInformation() {
        if (this.folder == null) {
            this.notifyListenersOfStatusMessage("Choose a project folder to continue!");
            return false;
        }
        if (this.sourceProgramInfo == null || this.destinationProgramInfo == null) {
            return false;
        }
        if (this.sourceProgramInfo.hasSameFile(this.destinationProgramInfo)) {
            this.notifyListenersOfStatusMessage("Source and Destination Programs must be different");
            this.releaseConsumers();
            return false;
        }
        String name = this.sessionNameField.getText().trim();
        if (StringUtils.isBlank((CharSequence)name)) {
            this.notifyListenersOfStatusMessage("Please enter a name for this session");
            return false;
        }
        try {
            this.tool.getProject().getProjectData().testValidName(name, false);
        }
        catch (InvalidNameException e) {
            this.notifyListenersOfStatusMessage("'" + name + "' contains invalid characters");
            return false;
        }
        DomainFile file = this.folder.getFile(name);
        if (file != null) {
            this.notifyListenersOfStatusMessage("'" + file.getPathname() + "' is the name of an existing domain file");
            return false;
        }
        this.openProgram(this.sourceProgramInfo);
        if (!this.sourceProgramInfo.hasProgram()) {
            this.notifyListenersOfStatusMessage("Can't open source program " + this.sourceProgramInfo.getName());
            return false;
        }
        this.openProgram(this.destinationProgramInfo);
        if (!this.destinationProgramInfo.hasProgram()) {
            this.notifyListenersOfStatusMessage("Can't open destination program " + this.destinationProgramInfo.getName());
            return false;
        }
        this.notifyListenersOfStatusMessage(" ");
        return true;
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }

    private JButton createSourceBrowseButton() {
        BrowseButton button = new BrowseButton();
        button.setName("SOURCE_BUTTON");
        button.addActionListener(e -> {
            DomainFile programFile = VTWizardUtils.chooseDomainFile((Component)((Object)this), "a source program", VTWizardUtils.PROGRAM_FILTER, null);
            if (programFile != null) {
                this.setSourceProgram(programFile);
            }
        });
        return button;
    }

    private JButton createDestinationBrowseButton() {
        BrowseButton button = new BrowseButton();
        button.setName("DESTINATION_BUTTON");
        button.addActionListener(e -> {
            DomainFile programFile = VTWizardUtils.chooseDomainFile((Component)((Object)this), "a destination program", VTWizardUtils.PROGRAM_FILTER, null);
            if (programFile != null) {
                this.setDestinationProgram(programFile);
            }
        });
        return button;
    }

    public void dispose() {
        this.releaseConsumers();
    }

    private class ProgramInfo {
        private Program program;
        private DomainFile file;

        public ProgramInfo(DomainFile file) {
            this.file = Objects.requireNonNull(file);
        }

        void setProgram(Program program) {
            this.program = program;
        }

        Program getProgram() {
            return this.program;
        }

        DomainFile getFile() {
            return this.file;
        }

        String getPathname() {
            return this.file.getPathname();
        }

        String getName() {
            return this.file.getName();
        }

        void release(Object consumer) {
            if (this.program == null) {
                return;
            }
            if (this.program.getConsumerList().contains(consumer)) {
                this.program.release(consumer);
            }
            this.program = null;
        }

        boolean hasSameFile(ProgramInfo other) {
            return this.file.getPathname().equals(other.getPathname());
        }

        boolean hasProgram() {
            return this.program != null;
        }
    }
}

