/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.task.RemoveMatchTask;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;

public class RemoveMatchAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_UnEdit";
    private static final Icon ICON = new GIcon("icon.version.tracking.action.match.remove");
    private final VTController controller;

    public RemoveMatchAction(VTController controller) {
        super("Remove", VTPlugin.OWNER);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Remove Match"}, ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Remove_Match"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        VTSession session = this.controller.getSession();
        RemoveMatchTask task = new RemoveMatchTask(session, matches);
        this.controller.runVTTask(task);
        this.controller.refresh();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        if (matches.size() == 0) {
            return false;
        }
        return this.isRemovableMatch(matches.get(0));
    }

    private boolean isRemovableMatch(VTMatch vtMatch) {
        return vtMatch.getMatchSet().hasRemovableMatches();
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

