/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.Match;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class SequenceSearchState
implements Comparable<SequenceSearchState> {
    private static final int PATTERN_ENDED = Integer.MAX_VALUE;
    private SequenceSearchState parent;
    private ArrayList<DittedBitSequence> possible;
    private ArrayList<DittedBitSequence> success;
    private SequenceSearchState[] trans;

    public SequenceSearchState(SequenceSearchState parent) {
        this.parent = parent;
        this.possible = new ArrayList();
        this.success = null;
        this.trans = null;
    }

    public int getMaxSequenceSize() {
        int max = 0;
        for (DittedBitSequence element : this.possible) {
            int val = element.getSize();
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public void addSequence(DittedBitSequence pat, int pos) {
        this.possible.add(pat);
        if (pos == pat.getSize()) {
            if (this.success == null) {
                this.success = new ArrayList();
            }
            this.success.add(pat);
        }
    }

    public void sortSequences() {
        Comparator<DittedBitSequence> comp = new Comparator<DittedBitSequence>(){

            @Override
            public int compare(DittedBitSequence o1, DittedBitSequence o2) {
                return o1.getIndex() - o2.getIndex();
            }
        };
        Collections.sort(this.possible, comp);
        if (this.success != null) {
            Collections.sort(this.success, comp);
        }
    }

    @Override
    public int compareTo(SequenceSearchState o) {
        int i = 0;
        while (true) {
            int indthem;
            if (this.possible.size() <= i) {
                if (o.possible.size() <= i) {
                    return 0;
                }
                return -1;
            }
            if (o.possible.size() <= i) {
                return 1;
            }
            int indus = this.possible.get(i).getIndex();
            if (indus != (indthem = o.possible.get(i).getIndex())) {
                return indus < indthem ? -1 : 1;
            }
            ++i;
        }
    }

    private void buildSingleTransition(ArrayList<SequenceSearchState> all, int pos, int val) {
        SequenceSearchState newstate = null;
        for (DittedBitSequence curpat : this.possible) {
            if (!curpat.isMatch(pos, val)) continue;
            if (newstate == null) {
                newstate = new SequenceSearchState(this);
            }
            newstate.addSequence(curpat, pos + 1);
        }
        this.trans[val] = newstate;
        if (newstate != null) {
            newstate.sortSequences();
            all.add(newstate);
        }
    }

    private void exportSuccess(ArrayList<Match> match, int offset) {
        for (DittedBitSequence succes : this.success) {
            Match newmatch = new Match(succes, offset);
            match.add(newmatch);
        }
    }

    private void merge(SequenceSearchState op) {
        SequenceSearchState parent = op.parent;
        for (int i = 0; i < 256; ++i) {
            if (parent.trans[i] != op) continue;
            parent.trans[i] = this;
        }
        if (op.success != null) {
            if (this.success == null) {
                this.success = op.success;
            } else {
                ArrayList<DittedBitSequence> tmp = new ArrayList<DittedBitSequence>();
                int i = 0;
                int j = 0;
                int curpat = -1;
                int thispat = this.success.get(i).getIndex();
                int oppat = op.success.get(j).getIndex();
                while (i < this.success.size() || j < op.success.size()) {
                    if (thispat == oppat) {
                        if (curpat != thispat) {
                            tmp.add(this.success.get(i));
                            curpat = thispat;
                        }
                        thispat = ++i == this.success.size() ? Integer.MAX_VALUE : this.success.get(i).getIndex();
                        oppat = j == op.success.size() ? Integer.MAX_VALUE : op.success.get(++j).getIndex();
                        continue;
                    }
                    if (thispat < oppat) {
                        if (curpat != thispat) {
                            tmp.add(this.success.get(i));
                            curpat = thispat;
                        }
                        thispat = ++i == this.success.size() ? Integer.MAX_VALUE : this.success.get(i).getIndex();
                        continue;
                    }
                    if (curpat != oppat) {
                        tmp.add(op.success.get(j));
                        curpat = oppat;
                    }
                    oppat = ++j == op.success.size() ? Integer.MAX_VALUE : op.success.get(j).getIndex();
                }
                this.success = tmp;
            }
        }
    }

    public void sequenceMatch(byte[] bytearray, int numbytes, ArrayList<Match> match) {
        int subindex = 0;
        SequenceSearchState curstate = this;
        do {
            if (curstate.success != null) {
                curstate.exportSuccess(match, 0);
            }
            if (subindex >= numbytes) {
                return;
            }
            curstate = curstate.trans[0xFF & bytearray[subindex]];
            ++subindex;
        } while (curstate != null);
    }

    public void apply(byte[] buffer, ArrayList<Match> match) {
        block0: for (int offset = 0; offset < buffer.length; ++offset) {
            SequenceSearchState curstate = this;
            int subindex = offset;
            do {
                if (curstate.success != null) {
                    curstate.exportSuccess(match, offset);
                }
                if (subindex >= buffer.length) continue block0;
                curstate = curstate.trans[0xFF & buffer[subindex]];
                ++subindex;
            } while (curstate != null);
        }
    }

    public void apply(InputStream in, ArrayList<Match> match, TaskMonitor monitor) throws IOException {
        this.apply(in, -1L, match, monitor);
    }

    public void apply(InputStream in, long maxBytes, ArrayList<Match> match, TaskMonitor monitor) throws IOException {
        byte[] curBuf;
        int subIndex;
        SequenceSearchState curState;
        int fullBuffers;
        long progress = monitor.getProgress();
        int maxSize = this.getMaxSequenceSize() + 1;
        if (maxSize < 4096) {
            maxSize = 4096;
        }
        if (maxBytes > 0L) {
            maxBytes += (long)(this.getMaxSequenceSize() + 1);
        }
        byte[] firstBuf = new byte[maxSize];
        byte[] secondBuf = new byte[maxSize];
        int ra = in.read(firstBuf);
        if (ra == firstBuf.length) {
            ra = in.read(secondBuf);
            if (ra == secondBuf.length) {
                fullBuffers = 2;
            } else {
                if (ra < 0) {
                    ra = 0;
                }
                fullBuffers = 1;
                tmp = new byte[ra];
                for (i = 0; i < ra; ++i) {
                    tmp[i] = secondBuf[i];
                }
                secondBuf = tmp;
            }
        } else {
            if (ra < 0) {
                return;
            }
            tmp = new byte[ra];
            for (i = 0; i < ra; ++i) {
                tmp[i] = firstBuf[i];
            }
            firstBuf = tmp;
            fullBuffers = 0;
            secondBuf = new byte[]{};
        }
        int offset = 0;
        int bufRelativeOffset = 0;
        while (fullBuffers == 2) {
            curState = this;
            subIndex = bufRelativeOffset;
            curBuf = firstBuf;
            do {
                if (curState.success != null) {
                    curState.exportSuccess(match, offset);
                }
                if (subIndex >= curBuf.length) {
                    curBuf = secondBuf;
                    subIndex = 0;
                }
                curState = curState.trans[0xFF & curBuf[subIndex]];
                ++subIndex;
            } while (curState != null);
            if (maxBytes > 0L && (long)(++offset) > maxBytes) break;
            if (++bufRelativeOffset != firstBuf.length) continue;
            byte[] tmp = firstBuf;
            firstBuf = secondBuf;
            secondBuf = tmp;
            ra = in.read(secondBuf);
            if (monitor != null) {
                if (monitor.isCancelled()) {
                    return;
                }
                monitor.setProgress(progress + (long)offset);
            }
            if (ra != secondBuf.length) {
                fullBuffers = 1;
                if (ra < 0) {
                    ra = 0;
                }
                tmp = new byte[ra];
                for (int i = 0; i < ra; ++i) {
                    tmp[i] = secondBuf[i];
                }
                secondBuf = tmp;
            }
            bufRelativeOffset = 0;
        }
        while (fullBuffers >= 0 && (maxBytes <= 0L || (long)offset < maxBytes)) {
            if (secondBuf.length == 0) {
                fullBuffers = 0;
            }
            curState = this;
            subIndex = bufRelativeOffset;
            curBuf = firstBuf;
            do {
                if (curState.success != null) {
                    curState.exportSuccess(match, offset);
                }
                if (subIndex >= curBuf.length) {
                    if (curBuf == secondBuf) break;
                    curBuf = secondBuf;
                    subIndex = 0;
                    if (curBuf.length == 0) break;
                }
                curState = curState.trans[0xFF & curBuf[subIndex]];
                ++subIndex;
            } while (curState != null);
            ++offset;
            if (++bufRelativeOffset != firstBuf.length) continue;
            if (fullBuffers == 0) break;
            firstBuf = secondBuf;
            fullBuffers = 0;
            bufRelativeOffset = 0;
            secondBuf = new byte[]{};
        }
    }

    static ArrayList<SequenceSearchState> buildTransitionLevel(ArrayList<SequenceSearchState> prev, int pos) {
        ArrayList<SequenceSearchState> res = new ArrayList<SequenceSearchState>();
        for (SequenceSearchState next : prev) {
            next.trans = new SequenceSearchState[256];
            for (int i = 0; i < 256; ++i) {
                next.buildSingleTransition(res, pos, i);
            }
        }
        if (res.isEmpty()) {
            return res;
        }
        Collections.sort(res);
        ArrayList<SequenceSearchState> finalres = new ArrayList<SequenceSearchState>();
        Iterator<SequenceSearchState> iter = res.iterator();
        SequenceSearchState curpat = iter.next();
        finalres.add(curpat);
        while (iter.hasNext()) {
            SequenceSearchState nextpat = iter.next();
            int comp = curpat.compareTo(nextpat);
            if (comp == 0) {
                curpat.merge(nextpat);
                continue;
            }
            curpat = nextpat;
            finalres.add(curpat);
        }
        return finalres;
    }

    public static SequenceSearchState buildStateMachine(ArrayList<? extends DittedBitSequence> patterns) {
        SequenceSearchState root = new SequenceSearchState(null);
        for (int i = 0; i < patterns.size(); ++i) {
            DittedBitSequence pat = patterns.get(i);
            pat.setIndex(i);
            root.addSequence(pat, 0);
        }
        root.sortSequences();
        ArrayList<SequenceSearchState> statelevel = new ArrayList<SequenceSearchState>();
        statelevel.add(root);
        int level = 0;
        do {
            statelevel = SequenceSearchState.buildTransitionLevel(statelevel, level);
            ++level;
        } while (!statelevel.isEmpty());
        return root;
    }
}

