/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.xml.DisplaySettingsHandler;
import ghidra.app.util.xml.DtParser;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class DefinedDataXmlMgr {
    private Program program;
    private MessageLog log;

    DefinedDataXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(XmlPullParser parser, Boolean overwriteData, TaskMonitor monitor) throws CancelledException {
        Listing listing = this.program.getListing();
        AddressFactory factory = this.program.getAddressFactory();
        DataTypeManager dataManager = listing.getDataTypeManager();
        int skipCodeUnitErrors = 0;
        try (BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();){
            DtParser dtParser = new DtParser(dataManager);
            XmlElement element = parser.next();
            while (true) {
                block17: {
                    int size;
                    CategoryPath path;
                    if (monitor.isCancelled()) {
                        throw new CancelledException();
                    }
                    element = parser.next();
                    if (!element.getName().equals("DEFINED_DATA")) break;
                    String addrStr = element.getAttribute("ADDRESS");
                    if (addrStr == null) {
                        this.log.appendMsg("Defined data: address not specified.");
                        parser.discardSubTree(element);
                        continue;
                    }
                    Address addr = XmlProgramUtilities.parseAddress((AddressFactory)factory, (String)addrStr);
                    if (addr == null) {
                        this.log.appendMsg("Defined data: invalid address " + addrStr);
                        parser.discardSubTree(element);
                        continue;
                    }
                    String dataTypeName = element.getAttribute("DATATYPE");
                    DataType dt = dtParser.parseDataType(dataTypeName, path = element.hasAttribute("DATATYPE_NAMESPACE") ? new CategoryPath(element.getAttribute("DATATYPE_NAMESPACE")) : CategoryPath.ROOT, size = element.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)element.getAttribute("SIZE")) : -1);
                    if (dt == null) {
                        this.log.appendMsg("Defined data: unknown datatype: " + dataTypeName + " in category: " + path);
                        parser.discardSubTree(element);
                        continue;
                    }
                    if (!this.program.getMemory().contains(addr)) {
                        ++skipCodeUnitErrors;
                        parser.discardSubTree(element);
                        continue;
                    }
                    try {
                        if (overwriteData.booleanValue()) {
                            this.clearExistingData(addr, size, dt, listing);
                        }
                        Data data = listing.createData(addr, dt, size);
                        if (parser.peek().getName().equals("DISPLAY_SETTING")) {
                            DisplaySettingsHandler.readSettings(parser.next(), (Settings)data);
                            parser.next();
                        }
                        if (parser.peek().getName().equals("DISPLAY_SETTINGS")) {
                            DisplaySettingsHandler.readSettings(parser.next(), (Settings)data);
                            parser.next();
                        }
                        if (!parser.peek().getName().equals("TYPEINFO_CMT")) break block17;
                        parser.discardSubTree("TYPEINFO_CMT");
                    }
                    catch (CodeUnitInsertionException e) {
                        Data d = listing.getDefinedDataAt(addr);
                        if (d == null || !d.getDataType().isEquivalent(dt)) {
                            this.log.appendMsg(e.getMessage());
                        }
                        parser.discardSubTree(element);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.appendException((Throwable)e);
                        parser.discardSubTree(element);
                        continue;
                    }
                }
                parser.end(element);
            }
            if (skipCodeUnitErrors != 0) {
                this.log.appendMsg("Skipped " + skipCodeUnitErrors + " Data elements where no memory was defined");
            }
        }
    }

    private void clearExistingData(Address addr, int size, DataType dt, Listing listing) {
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)dt, (MemBuffer)buf, (int)size, (boolean)false);
        if (dti != null) {
            boolean doClear = false;
            Address maxAddr = addr.add((long)(dti.getLength() - 1));
            CodeUnitIterator codeUnits = listing.getCodeUnits((AddressSetView)new AddressSet(addr, maxAddr), true);
            while (codeUnits.hasNext()) {
                CodeUnit cu = codeUnits.next();
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) continue;
                    doClear = true;
                    continue;
                }
                return;
            }
            if (doClear) {
                listing.clearCodeUnits(addr, maxAddr, false);
            }
        }
    }

    void write(XmlWriter writer, AddressSetView addrset, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing DATA ...");
        writer.startElement("DATA");
        Listing listing = this.program.getListing();
        DataIterator iter = listing.getDefinedData(addrset, true);
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Data data = iter.next();
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)data.getMinAddress()));
            DataType dt = data.getDataType();
            attrs.addAttribute("DATATYPE", dt.getDisplayName());
            attrs.addAttribute("DATATYPE_NAMESPACE", dt.getCategoryPath().getPath());
            attrs.addAttribute("SIZE", data.getLength(), true);
            writer.startElement("DEFINED_DATA", attrs);
            DisplaySettingsHandler.writeSettings(writer, (Settings)data);
            writer.endElement("DEFINED_DATA");
        }
        writer.endElement("DATA");
    }
}

