/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.BytesFieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonOptions;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.util.ListingDiff;
import java.awt.Color;
import java.util.ArrayList;

public class ListingDiffHighlightProvider
implements ListingHighlightProvider {
    private static final int NUM_CHARACTERS_PER_BYTE = 3;
    private static final String DEFAULT_OPERAND_SEPARATOR = ",";
    private ListingDiff listingDiff;
    private boolean isListing1;
    private ListingCodeComparisonOptions comparisonOptions;

    public ListingDiffHighlightProvider(ListingDiff listingDiff, boolean isListing1, ListingCodeComparisonOptions comparisonOptions) {
        this.listingDiff = listingDiff;
        this.isListing1 = isListing1;
        this.comparisonOptions = comparisonOptions;
    }

    @Override
    public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
        Highlight[] highlights = NO_HIGHLIGHTS;
        ProxyObj<?> proxy = field.getProxy();
        Object obj = proxy.getObject();
        if (obj instanceof CodeUnit) {
            CodeUnit codeUnit = (CodeUnit)obj;
            Class<?> fieldFactoryClass = field.getFieldFactory().getClass();
            if (fieldFactoryClass == BytesFieldFactory.class) {
                highlights = this.getByteDiffHighlights(text, codeUnit, cursorTextOffset);
            } else if (fieldFactoryClass == MnemonicFieldFactory.class) {
                highlights = this.getMnemonicDiffHighlights(text, codeUnit, cursorTextOffset);
            } else if (fieldFactoryClass == OperandFieldFactory.class) {
                highlights = this.getOperandDiffHighlights(text, codeUnit, cursorTextOffset);
            }
        }
        return highlights;
    }

    private Highlight[] getByteDiffHighlights(String text, CodeUnit codeUnit, int cursorTextOffset) {
        AddressSetView unmatchedDiffs;
        Address minAddress = codeUnit.getMinAddress();
        AddressSetView addressSetView = unmatchedDiffs = this.isListing1 ? this.listingDiff.getListing1UnmatchedCode() : this.listingDiff.getListing2UnmatchedCode();
        if (unmatchedDiffs.contains(minAddress)) {
            return NO_HIGHLIGHTS;
        }
        Color byteDiffsBackgroundColor = this.comparisonOptions.getByteDiffsBackgroundColor();
        AddressSetView byteDiffs = this.isListing1 ? this.listingDiff.getListing1ByteDiffs() : this.listingDiff.getListing2ByteDiffs();
        AddressSet diffSet = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        if (!(diffSet = diffSet.intersect(byteDiffs)).isEmpty()) {
            ArrayList<Highlight> highlights = new ArrayList<Highlight>();
            for (AddressRange addressRange : diffSet) {
                Address rangeMinAddress = addressRange.getMinAddress();
                long minByteIndex = rangeMinAddress.subtract(minAddress);
                int startIndex = (int)minByteIndex * 3;
                Address rangeMaxAddress = addressRange.getMaxAddress();
                long maxByteIndex = rangeMaxAddress.subtract(minAddress);
                int endIndex = (int)(maxByteIndex * 3L) + 1;
                highlights.add(new Highlight(startIndex, endIndex, byteDiffsBackgroundColor));
            }
            return highlights.toArray(new Highlight[highlights.size()]);
        }
        return NO_HIGHLIGHTS;
    }

    private Highlight[] getMnemonicDiffHighlights(String text, CodeUnit codeUnit, int cursorTextOffset) {
        AddressSetView unmatchedDiffs;
        Address minAddress = codeUnit.getMinAddress();
        AddressSetView addressSetView = unmatchedDiffs = this.isListing1 ? this.listingDiff.getListing1UnmatchedCode() : this.listingDiff.getListing2UnmatchedCode();
        if (unmatchedDiffs.contains(minAddress)) {
            return NO_HIGHLIGHTS;
        }
        Color mnemonicDiffsBackgroundColor = this.comparisonOptions.getMnemonicDiffsBackgroundColor();
        AddressSetView codeUnitDiffs = this.isListing1 ? this.listingDiff.getListing1CodeUnitDiffs() : this.listingDiff.getListing2CodeUnitDiffs();
        AddressSet diffSet = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        if (!(diffSet = diffSet.intersect(codeUnitDiffs)).isEmpty()) {
            CodeUnit otherCodeUnit = this.listingDiff.getMatchingCodeUnit(codeUnit, this.isListing1);
            if (otherCodeUnit == null) {
                return this.entireTextHighlight(text, cursorTextOffset, mnemonicDiffsBackgroundColor);
            }
            boolean sameMnemonics = codeUnit.getMnemonicString().equals(otherCodeUnit.getMnemonicString());
            if (!sameMnemonics) {
                return this.entireTextHighlight(text, cursorTextOffset, mnemonicDiffsBackgroundColor);
            }
        }
        return NO_HIGHLIGHTS;
    }

    private Highlight[] getOperandDiffHighlights(String text, CodeUnit codeUnit, int cursorTextOffset) {
        AddressSetView unmatchedDiffs;
        Address minAddress = codeUnit.getMinAddress();
        AddressSetView addressSetView = unmatchedDiffs = this.isListing1 ? this.listingDiff.getListing1UnmatchedCode() : this.listingDiff.getListing2UnmatchedCode();
        if (unmatchedDiffs.contains(minAddress)) {
            return NO_HIGHLIGHTS;
        }
        Color operandDiffsBackgroundColor = this.comparisonOptions.getOperandDiffsBackgroundColor();
        AddressSetView codeUnitDiffs = this.isListing1 ? this.listingDiff.getListing1CodeUnitDiffs() : this.listingDiff.getListing2CodeUnitDiffs();
        AddressSet diffSet = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        if (!(diffSet = diffSet.intersect(codeUnitDiffs)).isEmpty()) {
            int numOperands;
            CodeUnit matchingCodeUnit = this.listingDiff.getMatchingCodeUnit(codeUnit, this.isListing1);
            if (this.listingDiff.doesEntireOperandSetDiffer(codeUnit, matchingCodeUnit)) {
                return this.entireTextHighlight(text, cursorTextOffset, operandDiffsBackgroundColor);
            }
            Pair[] pairs = this.getOperandPairs(text, codeUnit);
            if (pairs.length != (numOperands = codeUnit.getNumOperands())) {
                return this.entireTextHighlight(text, cursorTextOffset, operandDiffsBackgroundColor);
            }
            int[] diffOpIndices = this.listingDiff.getOperandsThatDiffer(codeUnit, matchingCodeUnit);
            ArrayList<Highlight> highlights = new ArrayList<Highlight>();
            for (int diffOpIndex : diffOpIndices) {
                highlights.add(new Highlight(pairs[diffOpIndex].start, pairs[diffOpIndex].end, operandDiffsBackgroundColor));
            }
            return highlights.toArray(new Highlight[highlights.size()]);
        }
        return NO_HIGHLIGHTS;
    }

    private Pair[] getOperandPairs(String text, CodeUnit codeUnit) {
        String separator;
        if (text == null || text.isEmpty()) {
            return new Pair[0];
        }
        Instruction instruction = codeUnit instanceof Instruction ? (Instruction)codeUnit : null;
        ArrayList<Pair> list = new ArrayList<Pair>();
        int opIndex = 0;
        int textLength = text.length();
        int start = 0;
        int separatorIndex = -1;
        String string = separator = instruction != null ? instruction.getSeparator(opIndex) : null;
        if (separator != null && !separator.isEmpty()) {
            separatorIndex = text.indexOf(separator, start);
            start = separatorIndex + separator.length();
        }
        while (start < textLength) {
            ++opIndex;
            separator = DEFAULT_OPERAND_SEPARATOR;
            if (instruction != null) {
                separator = instruction.getSeparator(opIndex);
            }
            int n = separatorIndex = separator != null && !separator.isEmpty() ? text.indexOf(separator, start) : -1;
            if (separatorIndex == -1) {
                list.add(new Pair(start, textLength - 1));
                start = textLength;
                continue;
            }
            list.add(new Pair(start, separatorIndex - 1));
            start = separatorIndex + separator.length();
        }
        return list.toArray(new Pair[list.size()]);
    }

    private Highlight[] entireTextHighlight(String text, int cursorTextOffset, Color color) {
        int startIndex = 0;
        int endIndex = text.length() - 1;
        Highlight highlight = new Highlight(startIndex, endIndex, color);
        return new Highlight[]{highlight};
    }

    public boolean isListing1() {
        return this.isListing1;
    }

    private class Pair {
        private int start;
        private int end;

        private Pair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

