/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class XCoffArchiveMemberHeader {
    private static final int _02 = 2;
    private static final int _04 = 4;
    private static final int _12 = 12;
    private static final int _20 = 20;
    private byte[] ar_size;
    private byte[] ar_nxtmem;
    private byte[] ar_prvmem;
    private byte[] ar_date;
    private byte[] ar_uid;
    private byte[] ar_gid;
    private byte[] ar_mode;
    private byte[] ar_namlen;
    private byte[] ar_name;
    private byte[] ar_fmag;
    long file_offset;

    public XCoffArchiveMemberHeader(BinaryReader reader) throws IOException {
        this.ar_size = reader.readNextByteArray(20);
        this.ar_nxtmem = reader.readNextByteArray(20);
        this.ar_prvmem = reader.readNextByteArray(20);
        this.ar_date = reader.readNextByteArray(12);
        this.ar_uid = reader.readNextByteArray(12);
        this.ar_gid = reader.readNextByteArray(12);
        this.ar_mode = reader.readNextByteArray(12);
        this.ar_namlen = reader.readNextByteArray(4);
        this.ar_name = reader.readNextByteArray(this.getNameLength());
        this.ar_fmag = reader.readNextByteArray(2);
        this.file_offset = reader.getPointerIndex();
        if (this.file_offset % 2L == 1L) {
            ++this.file_offset;
        }
    }

    public long getSize() {
        return Long.parseLong(new String(this.ar_size).trim());
    }

    public long getNextMemberOffset() {
        return Long.parseLong(new String(this.ar_nxtmem).trim());
    }

    public long getPreviousMemberOffset() {
        return Long.parseLong(new String(this.ar_prvmem).trim());
    }

    public long getDate() {
        return Long.parseLong(new String(this.ar_date).trim());
    }

    public long getUserID() {
        return Long.parseLong(new String(this.ar_uid).trim());
    }

    public long getGroupID() {
        return Long.parseLong(new String(this.ar_gid).trim());
    }

    public long getMode() {
        return Long.parseLong(new String(this.ar_mode).trim());
    }

    public int getNameLength() {
        return Integer.parseInt(new String(this.ar_namlen).trim());
    }

    public String getName() {
        return new String(this.ar_name).trim();
    }

    public String getTerminator() {
        return new String(this.ar_fmag).trim();
    }

    public long getObjectDataOffset() {
        return this.file_offset;
    }
}

