/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PEx64UnwindInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImageRuntimeFunctionEntries_X86
implements ImageRuntimeFunctionEntries {
    private static final int ENTRY_SIZE = 12;
    private List<ImageRuntimeFunctionEntry_X86> functionEntries = new ArrayList<ImageRuntimeFunctionEntry_X86>();

    ImageRuntimeFunctionEntries_X86(BinaryReader reader, int size, NTHeader ntHeader) throws IOException {
        int numEntries = size / 12;
        for (int i = 0; i < numEntries; ++i) {
            long beginAddress = reader.readNextUnsignedInt();
            long endAddress = reader.readNextUnsignedInt();
            long unwindInfoAddressOrData = reader.readNextUnsignedInt();
            if (beginAddress == 0L && endAddress == 0L && unwindInfoAddressOrData == 0L) break;
            PEx64UnwindInfo unwindInfo = PEx64UnwindInfo.readUnwindInfo(reader, unwindInfoAddressOrData, ntHeader);
            ImageRuntimeFunctionEntry_X86 entry = new ImageRuntimeFunctionEntry_X86(beginAddress, endAddress, unwindInfoAddressOrData, unwindInfo);
            this.functionEntries.add(entry);
        }
    }

    @Override
    public void markup(Program program, Address headerStart) throws CodeUnitInsertionException, IOException, DuplicateNameException {
        StructureDataType struct = new StructureDataType("_IMAGE_RUNTIME_FUNCTION_ENTRY", 0);
        struct.add(StructConverter.IBO32, "BeginAddress", null);
        struct.add(StructConverter.IBO32, "EndAddress", null);
        struct.add(StructConverter.IBO32, "UnwindInfoAddressOrData", null);
        ArrayDataType arr = new ArrayDataType((DataType)struct, this.functionEntries.size(), struct.getLength());
        DataUtilities.createData((Program)program, (Address)headerStart, (DataType)arr, (int)arr.getLength(), (boolean)true, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        for (ImageRuntimeFunctionEntry_X86 entry : this.functionEntries) {
            entry.markup(program);
        }
    }

    record ImageRuntimeFunctionEntry_X86(long beginAddress, long endAddress, long unwindInfoAddressOrData, PEx64UnwindInfo unwindInfo) {
        public void markup(Program program) throws DuplicateNameException, IOException {
            if (this.unwindInfoAddressOrData > 0L) {
                DataType dt = this.unwindInfo.toDataType();
                Address start = program.getImageBase().add(this.unwindInfoAddressOrData);
                try {
                    DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)dt.getLength(), (boolean)true, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                }
                catch (CodeUnitInsertionException codeUnitInsertionException) {
                    // empty catch block
                }
            }
        }
    }
}

