/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfExternalSymbol
extends OmfRecord {
    private boolean isStatic;
    protected List<OmfSymbol> symbols = new ArrayList<OmfSymbol>();

    protected OmfExternalSymbol(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public OmfExternalSymbol(BinaryReader reader, boolean isStatic) throws IOException {
        this.isStatic = isStatic;
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (reader.getPointerIndex() < max) {
            String name = OmfRecord.readString(reader);
            int type = OmfRecord.readIndex(reader);
            this.symbols.add(new OmfSymbol(name, type, 0L, 0, 0));
        }
        this.readCheckSumByte(reader);
    }

    public List<OmfSymbol> getSymbols() {
        return this.symbols;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

