/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo1
extends DyldCacheSlideInfoCommon {
    private int toc_offset;
    private int toc_count;
    private int entries_offset;
    private int entries_count;
    private int entries_size;
    private short[] toc;
    private byte[][] bits;

    public int getTocOffset() {
        return this.toc_offset;
    }

    public int getTocCount() {
        return this.toc_count;
    }

    public int getEntriesOffset() {
        return this.entries_offset;
    }

    public int getEntriesCount() {
        return this.entries_count;
    }

    public int getEntriesSize() {
        return this.entries_size;
    }

    public short[] getToc() {
        return this.toc;
    }

    public byte[][] getEntries() {
        return this.bits;
    }

    public DyldCacheSlideInfo1(BinaryReader reader) throws IOException {
        super(reader);
        long startIndex = reader.getPointerIndex() - 4L;
        this.toc_offset = reader.readNextInt();
        this.toc_count = reader.readNextInt();
        this.entries_offset = reader.readNextInt();
        this.entries_count = reader.readNextInt();
        this.entries_size = reader.readNextInt();
        reader.setPointerIndex(startIndex + (long)this.toc_offset);
        this.toc = reader.readNextShortArray(this.toc_count);
        reader.setPointerIndex(startIndex + (long)this.entries_offset);
        this.bits = new byte[this.entries_count][];
        for (int i = 0; i < this.entries_count; ++i) {
            this.bits[i] = reader.readNextByteArray(this.entries_size);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "toc_offset", "");
        struct.add(DWORD, "toc_count", "");
        struct.add(DWORD, "entries_offset", "");
        struct.add(DWORD, "entries_count", "");
        struct.add(DWORD, "entries_size", "");
        if (this.toc_offset > 24) {
            struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, this.toc_offset - 24, -1), "tocAlignment", "");
        }
        struct.add((DataType)new ArrayDataType((DataType)WordDataType.dataType, this.toc_count, -1), "toc", "");
        if (this.entries_offset > this.toc_offset + this.toc_count * 2) {
            struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, this.entries_offset - (this.toc_offset + this.toc_count * 2), -1), "entriesAlignment", "");
        }
        struct.add((DataType)new ArrayDataType((DataType)new ArrayDataType((DataType)ByteDataType.dataType, this.entries_size, -1), this.entries_count, -1), "entries", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void fixPageChains(Program program, DyldCacheHeader dyldCacheHeader, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory memory = program.getMemory();
        List<DyldCacheMappingInfo> mappingInfos = dyldCacheHeader.getMappingInfos();
        DyldCacheMappingInfo dyldCacheMappingInfo = mappingInfos.get(1);
        long dataPageStart = dyldCacheMappingInfo.getAddress();
        ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
        monitor.setMessage("Fixing V1 chained data page pointers...");
        monitor.setMaximum((long)this.entries_count);
        for (int tocIndex = 0; tocIndex < this.toc_count; ++tocIndex) {
            monitor.checkCancelled();
            int entryIndex = this.toc[tocIndex] & 0xFFFF;
            if (entryIndex > this.entries_count || entryIndex > this.bits.length) {
                log.appendMsg("Entry too big! [" + tocIndex + "] " + entryIndex + " " + this.entries_count + " " + this.bits.length);
                continue;
            }
            byte[] entry = this.bits[entryIndex];
            long page = dataPageStart + 4096L * (long)tocIndex;
            for (int pageEntriesIndex = 0; pageEntriesIndex < 128; ++pageEntriesIndex) {
                long prtEntryBitmap = (long)entry[pageEntriesIndex] & 0xFFL;
                if (prtEntryBitmap == 0L) continue;
                for (int bitMapIndex = 0; bitMapIndex < 8; ++bitMapIndex) {
                    long origValue;
                    if ((prtEntryBitmap & 1L << bitMapIndex) == 0L) continue;
                    long loc = page + (long)(pageEntriesIndex * 8 * 4) + (long)(bitMapIndex * 4);
                    Address addr = memory.getProgram().getLanguage().getDefaultSpace().getAddress(loc);
                    long value = origValue = memory.getLong(addr);
                    if (addRelocations) {
                        this.addRelocationTableEntry(program, addr, 4096, value, 8, null);
                    }
                    unchainedLocList.add(addr);
                }
            }
            monitor.setProgress((long)tocIndex);
        }
        this.createChainPointers(program, unchainedLocList, monitor);
    }
}

