/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExportTrie {
    private BinaryReader reader;
    private long base;
    private List<ExportEntry> exports = new ArrayList<ExportEntry>();

    public ExportTrie() {
    }

    public ExportTrie(BinaryReader reader) throws IOException {
        this();
        this.reader = reader;
        this.base = reader.getPointerIndex();
        this.parseTrie();
    }

    public List<ExportEntry> getExports() {
        return this.exports;
    }

    public List<ExportEntry> getExports(Predicate<ExportEntry> filter) {
        return this.exports.stream().filter(filter).collect(Collectors.toList());
    }

    private void parseTrie() throws IOException {
        LinkedList<Node> remainingNodes = this.parseNode("", 0);
        while (!remainingNodes.isEmpty()) {
            Node parent = remainingNodes.removeFirst();
            LinkedList<Node> children = this.parseNode(parent.name, parent.offset);
            for (Node child : children) {
                remainingNodes.add(new Node(parent.name + child.name, child.offset));
            }
        }
    }

    private LinkedList<Node> parseNode(String name, int offset) throws IOException {
        LinkedList<Node> children = new LinkedList<Node>();
        this.reader.setPointerIndex(this.base + (long)offset);
        int terminalSize = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        long childrenIndex = this.reader.getPointerIndex() + (long)terminalSize;
        if (terminalSize != 0) {
            long flags = this.reader.readNext(LEB128::unsigned);
            long address = 0L;
            long other = 0L;
            String importName = null;
            if ((flags & 8L) != 0L) {
                other = this.reader.readNext(LEB128::unsigned);
                importName = this.reader.readNextAsciiString();
            } else {
                address = this.reader.readNext(LEB128::unsigned);
                if ((flags & 0x10L) != 0L) {
                    other = this.reader.readNext(LEB128::unsigned);
                }
            }
            ExportEntry export = new ExportEntry(name, address, flags, other, importName);
            this.exports.add(export);
        }
        this.reader.setPointerIndex(childrenIndex);
        int numChildren = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        for (int i = 0; i < numChildren; ++i) {
            String childName = this.reader.readNextAsciiString();
            int childOffset = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
            children.add(new Node(childName, childOffset));
        }
        return children;
    }

    private static class Node {
        String name;
        int offset;

        Node(String name, int offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            return String.format("%s, 0x%x", this.name, this.offset);
        }
    }

    public static class ExportEntry {
        private String name;
        private long address;
        private long flags;
        private long other;
        private String importName;

        public ExportEntry(String name, long address, long flags, long other, String importName) {
            this.name = name;
            this.address = address;
            this.flags = flags;
            this.other = other;
            this.importName = importName;
        }

        public String getName() {
            return this.name;
        }

        public long getAddress() {
            return this.address;
        }

        public long getFlags() {
            return this.flags;
        }

        public long getOther() {
            return this.other;
        }

        public String getImportName() {
            return this.importName;
        }

        public boolean isReExport() {
            return (this.flags & 8L) != 0L;
        }

        public String toString() {
            return String.format("%s addr: 0x%x, flags: 0x%x, other: 0x%x, importName: %s", this.name, this.address, this.flags, this.other, this.importName != null ? this.importName : "<null>");
        }
    }
}

